/*!
 * mjs.js v0.2.0
 * (c) 2018-2023 malk
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.mjs = {})));
}(this, (function (exports) { 'use strict';

var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};



function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var runtime = createCommonjsModule(function (module) {
/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

!(function(global) {
  var Op = Object.prototype;
  var hasOwn = Op.hasOwnProperty;
  var undefined; // More compressible than void 0.
  var $Symbol = typeof Symbol === "function" ? Symbol : {};
  var iteratorSymbol = $Symbol.iterator || "@@iterator";
  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

  var inModule = 'object' === "object";
  var runtime = global.regeneratorRuntime;
  if (runtime) {
    if (inModule) {
      // If regeneratorRuntime is defined globally and we're in a module,
      // make the exports object identical to regeneratorRuntime.
      module.exports = runtime;
    }
    // Don't bother evaluating the rest of this file if the runtime was
    // already defined globally.
    return;
  }

  // Define the runtime globally (as expected by generated code) as either
  // module.exports (if we're in a module) or a new, empty object.
  runtime = global.regeneratorRuntime = inModule ? module.exports : {};

  function wrap(innerFn, outerFn, self, tryLocsList) {
    // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
    var generator = Object.create(protoGenerator.prototype);
    var context = new Context(tryLocsList || []);

    // The ._invoke method unifies the implementations of the .next,
    // .throw, and .return methods.
    generator._invoke = makeInvokeMethod(innerFn, self, context);

    return generator;
  }
  runtime.wrap = wrap;

  // Try/catch helper to minimize deoptimizations. Returns a completion
  // record like context.tryEntries[i].completion. This interface could
  // have been (and was previously) designed to take a closure to be
  // invoked without arguments, but in all the cases we care about we
  // already have an existing method we want to call, so there's no need
  // to create a new function object. We can even get away with assuming
  // the method takes exactly one argument, since that happens to be true
  // in every case, so we don't have to touch the arguments object. The
  // only additional allocation required is the completion record, which
  // has a stable shape and so hopefully should be cheap to allocate.
  function tryCatch(fn, obj, arg) {
    try {
      return { type: "normal", arg: fn.call(obj, arg) };
    } catch (err) {
      return { type: "throw", arg: err };
    }
  }

  var GenStateSuspendedStart = "suspendedStart";
  var GenStateSuspendedYield = "suspendedYield";
  var GenStateExecuting = "executing";
  var GenStateCompleted = "completed";

  // Returning this object from the innerFn has the same effect as
  // breaking out of the dispatch switch statement.
  var ContinueSentinel = {};

  // Dummy constructor functions that we use as the .constructor and
  // .constructor.prototype properties for functions that return Generator
  // objects. For full spec compliance, you may wish to configure your
  // minifier not to mangle the names of these two functions.
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}

  // This is a polyfill for %IteratorPrototype% for environments that
  // don't natively support it.
  var IteratorPrototype = {};
  IteratorPrototype[iteratorSymbol] = function () {
    return this;
  };

  var getProto = Object.getPrototypeOf;
  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  if (NativeIteratorPrototype &&
      NativeIteratorPrototype !== Op &&
      hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
    // This environment has a native %IteratorPrototype%; use it instead
    // of the polyfill.
    IteratorPrototype = NativeIteratorPrototype;
  }

  var Gp = GeneratorFunctionPrototype.prototype =
    Generator.prototype = Object.create(IteratorPrototype);
  GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
  GeneratorFunctionPrototype.constructor = GeneratorFunction;
  GeneratorFunctionPrototype[toStringTagSymbol] =
    GeneratorFunction.displayName = "GeneratorFunction";

  // Helper for defining the .next, .throw, and .return methods of the
  // Iterator interface in terms of a single ._invoke method.
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function(method) {
      prototype[method] = function(arg) {
        return this._invoke(method, arg);
      };
    });
  }

  runtime.isGeneratorFunction = function(genFun) {
    var ctor = typeof genFun === "function" && genFun.constructor;
    return ctor
      ? ctor === GeneratorFunction ||
        // For the native GeneratorFunction constructor, the best we can
        // do is to check its .name property.
        (ctor.displayName || ctor.name) === "GeneratorFunction"
      : false;
  };

  runtime.mark = function(genFun) {
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
    } else {
      genFun.__proto__ = GeneratorFunctionPrototype;
      if (!(toStringTagSymbol in genFun)) {
        genFun[toStringTagSymbol] = "GeneratorFunction";
      }
    }
    genFun.prototype = Object.create(Gp);
    return genFun;
  };

  // Within the body of any async function, `await x` is transformed to
  // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
  // `hasOwn.call(value, "__await")` to determine if the yielded value is
  // meant to be awaited.
  runtime.awrap = function(arg) {
    return { __await: arg };
  };

  function AsyncIterator(generator) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if (record.type === "throw") {
        reject(record.arg);
      } else {
        var result = record.arg;
        var value = result.value;
        if (value &&
            typeof value === "object" &&
            hasOwn.call(value, "__await")) {
          return Promise.resolve(value.__await).then(function(value) {
            invoke("next", value, resolve, reject);
          }, function(err) {
            invoke("throw", err, resolve, reject);
          });
        }

        return Promise.resolve(value).then(function(unwrapped) {
          // When a yielded Promise is resolved, its final value becomes
          // the .value of the Promise<{value,done}> result for the
          // current iteration. If the Promise is rejected, however, the
          // result for this iteration will be rejected with the same
          // reason. Note that rejections of yielded Promises are not
          // thrown back into the generator function, as is the case
          // when an awaited Promise is rejected. This difference in
          // behavior between yield and await is important, because it
          // allows the consumer to decide what to do with the yielded
          // rejection (swallow it and continue, manually .throw it back
          // into the generator, abandon iteration, whatever). With
          // await, by contrast, there is no opportunity to examine the
          // rejection reason outside the generator function, so the
          // only option is to throw it from the await expression, and
          // let the generator function handle the exception.
          result.value = unwrapped;
          resolve(result);
        }, reject);
      }
    }

    var previousPromise;

    function enqueue(method, arg) {
      function callInvokeWithMethodAndArg() {
        return new Promise(function(resolve, reject) {
          invoke(method, arg, resolve, reject);
        });
      }

      return previousPromise =
        // If enqueue has been called before, then we want to wait until
        // all previous Promises have been resolved before calling invoke,
        // so that results are always delivered in the correct order. If
        // enqueue has not been called before, then it is important to
        // call invoke immediately, without waiting on a callback to fire,
        // so that the async generator function has the opportunity to do
        // any necessary setup in a predictable way. This predictability
        // is why the Promise constructor synchronously invokes its
        // executor callback, and why async functions synchronously
        // execute code before the first await. Since we implement simple
        // async functions in terms of async generators, it is especially
        // important to get this right, even though it requires care.
        previousPromise ? previousPromise.then(
          callInvokeWithMethodAndArg,
          // Avoid propagating failures to Promises returned by later
          // invocations of the iterator.
          callInvokeWithMethodAndArg
        ) : callInvokeWithMethodAndArg();
    }

    // Define the unified helper method that is used to implement .next,
    // .throw, and .return (see defineIteratorMethods).
    this._invoke = enqueue;
  }

  defineIteratorMethods(AsyncIterator.prototype);
  AsyncIterator.prototype[asyncIteratorSymbol] = function () {
    return this;
  };
  runtime.AsyncIterator = AsyncIterator;

  // Note that simple async functions are implemented on top of
  // AsyncIterator objects; they just return a Promise for the value of
  // the final result produced by the iterator.
  runtime.async = function(innerFn, outerFn, self, tryLocsList) {
    var iter = new AsyncIterator(
      wrap(innerFn, outerFn, self, tryLocsList)
    );

    return runtime.isGeneratorFunction(outerFn)
      ? iter // If outerFn is a generator, return the full iterator.
      : iter.next().then(function(result) {
          return result.done ? result.value : iter.next();
        });
  };

  function makeInvokeMethod(innerFn, self, context) {
    var state = GenStateSuspendedStart;

    return function invoke(method, arg) {
      if (state === GenStateExecuting) {
        throw new Error("Generator is already running");
      }

      if (state === GenStateCompleted) {
        if (method === "throw") {
          throw arg;
        }

        // Be forgiving, per 25.3.3.3.3 of the spec:
        // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
        return doneResult();
      }

      context.method = method;
      context.arg = arg;

      while (true) {
        var delegate = context.delegate;
        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);
          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }

        if (context.method === "next") {
          // Setting context._sent for legacy support of Babel's
          // function.sent implementation.
          context.sent = context._sent = context.arg;

        } else if (context.method === "throw") {
          if (state === GenStateSuspendedStart) {
            state = GenStateCompleted;
            throw context.arg;
          }

          context.dispatchException(context.arg);

        } else if (context.method === "return") {
          context.abrupt("return", context.arg);
        }

        state = GenStateExecuting;

        var record = tryCatch(innerFn, self, context);
        if (record.type === "normal") {
          // If an exception is thrown from innerFn, we leave state ===
          // GenStateExecuting and loop back for another invocation.
          state = context.done
            ? GenStateCompleted
            : GenStateSuspendedYield;

          if (record.arg === ContinueSentinel) {
            continue;
          }

          return {
            value: record.arg,
            done: context.done
          };

        } else if (record.type === "throw") {
          state = GenStateCompleted;
          // Dispatch the exception by looping back around to the
          // context.dispatchException(context.arg) call above.
          context.method = "throw";
          context.arg = record.arg;
        }
      }
    };
  }

  // Call delegate.iterator[context.method](context.arg) and handle the
  // result, either by returning a { value, done } result from the
  // delegate iterator, or by modifying context.method and context.arg,
  // setting context.delegate to null, and returning the ContinueSentinel.
  function maybeInvokeDelegate(delegate, context) {
    var method = delegate.iterator[context.method];
    if (method === undefined) {
      // A .throw or .return when the delegate iterator has no .throw
      // method always terminates the yield* loop.
      context.delegate = null;

      if (context.method === "throw") {
        if (delegate.iterator.return) {
          // If the delegate iterator has a return method, give it a
          // chance to clean up.
          context.method = "return";
          context.arg = undefined;
          maybeInvokeDelegate(delegate, context);

          if (context.method === "throw") {
            // If maybeInvokeDelegate(context) changed context.method from
            // "return" to "throw", let that override the TypeError below.
            return ContinueSentinel;
          }
        }

        context.method = "throw";
        context.arg = new TypeError(
          "The iterator does not provide a 'throw' method");
      }

      return ContinueSentinel;
    }

    var record = tryCatch(method, delegate.iterator, context.arg);

    if (record.type === "throw") {
      context.method = "throw";
      context.arg = record.arg;
      context.delegate = null;
      return ContinueSentinel;
    }

    var info = record.arg;

    if (! info) {
      context.method = "throw";
      context.arg = new TypeError("iterator result is not an object");
      context.delegate = null;
      return ContinueSentinel;
    }

    if (info.done) {
      // Assign the result of the finished delegate to the temporary
      // variable specified by delegate.resultName (see delegateYield).
      context[delegate.resultName] = info.value;

      // Resume execution at the desired location (see delegateYield).
      context.next = delegate.nextLoc;

      // If context.method was "throw" but the delegate handled the
      // exception, let the outer generator proceed normally. If
      // context.method was "next", forget context.arg since it has been
      // "consumed" by the delegate iterator. If context.method was
      // "return", allow the original .return call to continue in the
      // outer generator.
      if (context.method !== "return") {
        context.method = "next";
        context.arg = undefined;
      }

    } else {
      // Re-yield the result returned by the delegate method.
      return info;
    }

    // The delegate iterator is finished, so forget it and continue with
    // the outer generator.
    context.delegate = null;
    return ContinueSentinel;
  }

  // Define Generator.prototype.{next,throw,return} in terms of the
  // unified ._invoke helper method.
  defineIteratorMethods(Gp);

  Gp[toStringTagSymbol] = "Generator";

  // A Generator should always return itself as the iterator object when the
  // @@iterator function is called on it. Some browsers' implementations of the
  // iterator prototype chain incorrectly implement this, causing the Generator
  // object to not be returned from this call. This ensures that doesn't happen.
  // See https://github.com/facebook/regenerator/issues/274 for more details.
  Gp[iteratorSymbol] = function() {
    return this;
  };

  Gp.toString = function() {
    return "[object Generator]";
  };

  function pushTryEntry(locs) {
    var entry = { tryLoc: locs[0] };

    if (1 in locs) {
      entry.catchLoc = locs[1];
    }

    if (2 in locs) {
      entry.finallyLoc = locs[2];
      entry.afterLoc = locs[3];
    }

    this.tryEntries.push(entry);
  }

  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal";
    delete record.arg;
    entry.completion = record;
  }

  function Context(tryLocsList) {
    // The root entry object (effectively a try statement without a catch
    // or a finally block) gives us a place to store values thrown from
    // locations where there is no enclosing try statement.
    this.tryEntries = [{ tryLoc: "root" }];
    tryLocsList.forEach(pushTryEntry, this);
    this.reset(true);
  }

  runtime.keys = function(object) {
    var keys = [];
    for (var key in object) {
      keys.push(key);
    }
    keys.reverse();

    // Rather than returning an object with a next method, we keep
    // things simple and return the next function itself.
    return function next() {
      while (keys.length) {
        var key = keys.pop();
        if (key in object) {
          next.value = key;
          next.done = false;
          return next;
        }
      }

      // To avoid creating an additional object, we just hang the .value
      // and .done properties off the next function object itself. This
      // also ensures that the minifier will not anonymize the function.
      next.done = true;
      return next;
    };
  };

  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) {
        return iteratorMethod.call(iterable);
      }

      if (typeof iterable.next === "function") {
        return iterable;
      }

      if (!isNaN(iterable.length)) {
        var i = -1, next = function next() {
          while (++i < iterable.length) {
            if (hasOwn.call(iterable, i)) {
              next.value = iterable[i];
              next.done = false;
              return next;
            }
          }

          next.value = undefined;
          next.done = true;

          return next;
        };

        return next.next = next;
      }
    }

    // Return an iterator with no values.
    return { next: doneResult };
  }
  runtime.values = values;

  function doneResult() {
    return { value: undefined, done: true };
  }

  Context.prototype = {
    constructor: Context,

    reset: function(skipTempReset) {
      this.prev = 0;
      this.next = 0;
      // Resetting context._sent for legacy support of Babel's
      // function.sent implementation.
      this.sent = this._sent = undefined;
      this.done = false;
      this.delegate = null;

      this.method = "next";
      this.arg = undefined;

      this.tryEntries.forEach(resetTryEntry);

      if (!skipTempReset) {
        for (var name in this) {
          // Not sure about the optimal order of these conditions:
          if (name.charAt(0) === "t" &&
              hasOwn.call(this, name) &&
              !isNaN(+name.slice(1))) {
            this[name] = undefined;
          }
        }
      }
    },

    stop: function() {
      this.done = true;

      var rootEntry = this.tryEntries[0];
      var rootRecord = rootEntry.completion;
      if (rootRecord.type === "throw") {
        throw rootRecord.arg;
      }

      return this.rval;
    },

    dispatchException: function(exception) {
      if (this.done) {
        throw exception;
      }

      var context = this;
      function handle(loc, caught) {
        record.type = "throw";
        record.arg = exception;
        context.next = loc;

        if (caught) {
          // If the dispatched exception was caught by a catch block,
          // then let that catch block handle the exception normally.
          context.method = "next";
          context.arg = undefined;
        }

        return !! caught;
      }

      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        var record = entry.completion;

        if (entry.tryLoc === "root") {
          // Exception thrown outside of any try block that could handle
          // it, so set the completion value of the entire function to
          // throw the exception.
          return handle("end");
        }

        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc");
          var hasFinally = hasOwn.call(entry, "finallyLoc");

          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            } else if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }

          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            }

          } else if (hasFinally) {
            if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }

          } else {
            throw new Error("try statement without catch or finally");
          }
        }
      }
    },

    abrupt: function(type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev &&
            hasOwn.call(entry, "finallyLoc") &&
            this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }

      if (finallyEntry &&
          (type === "break" ||
           type === "continue") &&
          finallyEntry.tryLoc <= arg &&
          arg <= finallyEntry.finallyLoc) {
        // Ignore the finally entry if control is not jumping to a
        // location outside the try/catch block.
        finallyEntry = null;
      }

      var record = finallyEntry ? finallyEntry.completion : {};
      record.type = type;
      record.arg = arg;

      if (finallyEntry) {
        this.method = "next";
        this.next = finallyEntry.finallyLoc;
        return ContinueSentinel;
      }

      return this.complete(record);
    },

    complete: function(record, afterLoc) {
      if (record.type === "throw") {
        throw record.arg;
      }

      if (record.type === "break" ||
          record.type === "continue") {
        this.next = record.arg;
      } else if (record.type === "return") {
        this.rval = this.arg = record.arg;
        this.method = "return";
        this.next = "end";
      } else if (record.type === "normal" && afterLoc) {
        this.next = afterLoc;
      }

      return ContinueSentinel;
    },

    finish: function(finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) {
          this.complete(entry.completion, entry.afterLoc);
          resetTryEntry(entry);
          return ContinueSentinel;
        }
      }
    },

    "catch": function(tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if (record.type === "throw") {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }

      // The context.catch method must only be called with a location
      // argument that corresponds to a known catch block.
      throw new Error("illegal catch attempt");
    },

    delegateYield: function(iterable, resultName, nextLoc) {
      this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      };

      if (this.method === "next") {
        // Deliberately forget the last sent value so that we don't
        // accidentally pass it on to the delegate.
        this.arg = undefined;
      }

      return ContinueSentinel;
    }
  };
})(
  // In sloppy mode, unbound `this` refers to the global object, fallback to
  // Function constructor if we're in global strict mode. That is sadly a form
  // of indirect eval which violates Content Security Policy.
  (function() { return this })() || Function("return this")()
);
});

/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

// This method of obtaining a reference to the global object needs to be
// kept identical to the way it is obtained in runtime.js
var g = (function() { return this })() || Function("return this")();

// Use `getOwnPropertyNames` because not all browsers support calling
// `hasOwnProperty` on the global `self` object in a worker. See #183.
var hadRuntime = g.regeneratorRuntime &&
  Object.getOwnPropertyNames(g).indexOf("regeneratorRuntime") >= 0;

// Save the old regeneratorRuntime in case it needs to be restored later.
var oldRuntime = hadRuntime && g.regeneratorRuntime;

// Force reevalutation of runtime.js.
g.regeneratorRuntime = undefined;

var runtimeModule = runtime;

if (hadRuntime) {
  // Restore the original runtime.
  g.regeneratorRuntime = oldRuntime;
} else {
  // Remove the global property added by runtime.js.
  try {
    delete g.regeneratorRuntime;
  } catch(e) {
    g.regeneratorRuntime = undefined;
  }
}

var regenerator = runtimeModule;

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
var _toInteger = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};

// 7.2.1 RequireObjectCoercible(argument)
var _defined = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};

// true  -> String#at
// false -> String#codePointAt
var _stringAt = function (TO_STRING) {
  return function (that, pos) {
    var s = String(_defined(that));
    var i = _toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};

var _library = true;

var _global = createCommonjsModule(function (module) {
// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef
});

var _core = createCommonjsModule(function (module) {
var core = module.exports = { version: '2.6.11' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef
});

var _core_1 = _core.version;

var _aFunction = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};

// optional / simple context binding

var _ctx = function (fn, that, length) {
  _aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

var _isObject = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

var _anObject = function (it) {
  if (!_isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};

var _fails = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};

// Thank's IE8 for his funny defineProperty
var _descriptors = !_fails(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});

var document$1 = _global.document;
// typeof document.createElement is 'object' in old IE
var is = _isObject(document$1) && _isObject(document$1.createElement);
var _domCreate = function (it) {
  return is ? document$1.createElement(it) : {};
};

var _ie8DomDefine = !_descriptors && !_fails(function () {
  return Object.defineProperty(_domCreate('div'), 'a', { get: function () { return 7; } }).a != 7;
});

// 7.1.1 ToPrimitive(input [, PreferredType])

// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
var _toPrimitive = function (it, S) {
  if (!_isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !_isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !_isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !_isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};

var dP = Object.defineProperty;

var f = _descriptors ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  _anObject(O);
  P = _toPrimitive(P, true);
  _anObject(Attributes);
  if (_ie8DomDefine) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var _objectDp = {
	f: f
};

var _propertyDesc = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var _hide = _descriptors ? function (object, key, value) {
  return _objectDp.f(object, key, _propertyDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var hasOwnProperty = {}.hasOwnProperty;
var _has = function (it, key) {
  return hasOwnProperty.call(it, key);
};

var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? _core : _core[name] || (_core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? _global : IS_STATIC ? _global[name] : (_global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && _has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? _ctx(out, _global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? _ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) _hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
var _export = $export;

var _redefine = _hide;

var _iterators = {};

var toString = {}.toString;

var _cof = function (it) {
  return toString.call(it).slice(8, -1);
};

// fallback for non-array-like ES3 and non-enumerable old V8 strings

// eslint-disable-next-line no-prototype-builtins
var _iobject = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return _cof(it) == 'String' ? it.split('') : Object(it);
};

// to indexed object, toObject with fallback for non-array-like ES3 strings


var _toIobject = function (it) {
  return _iobject(_defined(it));
};

// 7.1.15 ToLength

var min = Math.min;
var _toLength = function (it) {
  return it > 0 ? min(_toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};

var max = Math.max;
var min$1 = Math.min;
var _toAbsoluteIndex = function (index, length) {
  index = _toInteger(index);
  return index < 0 ? max(index + length, 0) : min$1(index, length);
};

// false -> Array#indexOf
// true  -> Array#includes



var _arrayIncludes = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = _toIobject($this);
    var length = _toLength(O.length);
    var index = _toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var _shared = createCommonjsModule(function (module) {
var SHARED = '__core-js_shared__';
var store = _global[SHARED] || (_global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: _core.version,
  mode: _library ? 'pure' : 'global',
  copyright: '© 2019 Denis Pushkarev (zloirock.ru)'
});
});

var id = 0;
var px = Math.random();
var _uid = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};

var shared = _shared('keys');

var _sharedKey = function (key) {
  return shared[key] || (shared[key] = _uid(key));
};

var arrayIndexOf = _arrayIncludes(false);
var IE_PROTO$1 = _sharedKey('IE_PROTO');

var _objectKeysInternal = function (object, names) {
  var O = _toIobject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO$1) _has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (_has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};

// IE 8- don't enum bug keys
var _enumBugKeys = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');

// 19.1.2.14 / 15.2.3.14 Object.keys(O)



var _objectKeys = Object.keys || function keys(O) {
  return _objectKeysInternal(O, _enumBugKeys);
};

var _objectDps = _descriptors ? Object.defineProperties : function defineProperties(O, Properties) {
  _anObject(O);
  var keys = _objectKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) _objectDp.f(O, P = keys[i++], Properties[P]);
  return O;
};

var document$2 = _global.document;
var _html = document$2 && document$2.documentElement;

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])



var IE_PROTO = _sharedKey('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE$1 = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = _domCreate('iframe');
  var i = _enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  _html.appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE$1][_enumBugKeys[i]];
  return createDict();
};

var _objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE$1] = _anObject(O);
    result = new Empty();
    Empty[PROTOTYPE$1] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : _objectDps(result, Properties);
};

var _wks = createCommonjsModule(function (module) {
var store = _shared('wks');

var Symbol = _global.Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : _uid)('Symbol.' + name));
};

$exports.store = store;
});

var def = _objectDp.f;

var TAG = _wks('toStringTag');

var _setToStringTag = function (it, tag, stat) {
  if (it && !_has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};

var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
_hide(IteratorPrototype, _wks('iterator'), function () { return this; });

var _iterCreate = function (Constructor, NAME, next) {
  Constructor.prototype = _objectCreate(IteratorPrototype, { next: _propertyDesc(1, next) });
  _setToStringTag(Constructor, NAME + ' Iterator');
};

// 7.1.13 ToObject(argument)

var _toObject = function (it) {
  return Object(_defined(it));
};

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)


var IE_PROTO$2 = _sharedKey('IE_PROTO');
var ObjectProto = Object.prototype;

var _objectGpo = Object.getPrototypeOf || function (O) {
  O = _toObject(O);
  if (_has(O, IE_PROTO$2)) return O[IE_PROTO$2];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};

var ITERATOR = _wks('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

var _iterDefine = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  _iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = _objectGpo($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      _setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!_library && typeof IteratorPrototype[ITERATOR] != 'function') _hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!_library || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    _hide(proto, ITERATOR, $default);
  }
  // Plug for library
  _iterators[NAME] = $default;
  _iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) _redefine(proto, key, methods[key]);
    } else _export(_export.P + _export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};

var $at = _stringAt(true);

// 21.1.3.27 String.prototype[@@iterator]()
_iterDefine(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});

var _iterStep = function (done, value) {
  return { value: value, done: !!done };
};

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
var es6_array_iterator = _iterDefine(Array, 'Array', function (iterated, kind) {
  this._t = _toIobject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return _iterStep(1);
  }
  if (kind == 'keys') return _iterStep(0, index);
  if (kind == 'values') return _iterStep(0, O[index]);
  return _iterStep(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
_iterators.Arguments = _iterators.Array;

var TO_STRING_TAG = _wks('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = _global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) _hide(proto, TO_STRING_TAG, NAME);
  _iterators[NAME] = _iterators.Array;
}

// getting tag from 19.1.3.6 Object.prototype.toString()

var TAG$1 = _wks('toStringTag');
// ES3 wrong here
var ARG = _cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

var _classof = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG$1)) == 'string' ? T
    // builtinTag case
    : ARG ? _cof(O)
    // ES3 arguments fallback
    : (B = _cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};

var _anInstance = function (it, Constructor, name, forbiddenField) {
  if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
    throw TypeError(name + ': incorrect invocation!');
  } return it;
};

// call something on iterator step with safe closing on error

var _iterCall = function (iterator, fn, value, entries) {
  try {
    return entries ? fn(_anObject(value)[0], value[1]) : fn(value);
  // 7.4.6 IteratorClose(iterator, completion)
  } catch (e) {
    var ret = iterator['return'];
    if (ret !== undefined) _anObject(ret.call(iterator));
    throw e;
  }
};

// check on default Array iterator

var ITERATOR$1 = _wks('iterator');
var ArrayProto = Array.prototype;

var _isArrayIter = function (it) {
  return it !== undefined && (_iterators.Array === it || ArrayProto[ITERATOR$1] === it);
};

var ITERATOR$2 = _wks('iterator');

var core_getIteratorMethod = _core.getIteratorMethod = function (it) {
  if (it != undefined) return it[ITERATOR$2]
    || it['@@iterator']
    || _iterators[_classof(it)];
};

var _forOf = createCommonjsModule(function (module) {
var BREAK = {};
var RETURN = {};
var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
  var iterFn = ITERATOR ? function () { return iterable; } : core_getIteratorMethod(iterable);
  var f = _ctx(fn, that, entries ? 2 : 1);
  var index = 0;
  var length, step, iterator, result;
  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
  // fast case for arrays with default iterator
  if (_isArrayIter(iterFn)) for (length = _toLength(iterable.length); length > index; index++) {
    result = entries ? f(_anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
    if (result === BREAK || result === RETURN) return result;
  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
    result = _iterCall(iterator, f, step.value, entries);
    if (result === BREAK || result === RETURN) return result;
  }
};
exports.BREAK = BREAK;
exports.RETURN = RETURN;
});

// 7.3.20 SpeciesConstructor(O, defaultConstructor)


var SPECIES = _wks('species');
var _speciesConstructor = function (O, D) {
  var C = _anObject(O).constructor;
  var S;
  return C === undefined || (S = _anObject(C)[SPECIES]) == undefined ? D : _aFunction(S);
};

// fast apply, http://jsperf.lnkit.com/fast-apply/5
var _invoke = function (fn, args, that) {
  var un = that === undefined;
  switch (args.length) {
    case 0: return un ? fn()
                      : fn.call(that);
    case 1: return un ? fn(args[0])
                      : fn.call(that, args[0]);
    case 2: return un ? fn(args[0], args[1])
                      : fn.call(that, args[0], args[1]);
    case 3: return un ? fn(args[0], args[1], args[2])
                      : fn.call(that, args[0], args[1], args[2]);
    case 4: return un ? fn(args[0], args[1], args[2], args[3])
                      : fn.call(that, args[0], args[1], args[2], args[3]);
  } return fn.apply(that, args);
};

var process$2 = _global.process;
var setTask = _global.setImmediate;
var clearTask = _global.clearImmediate;
var MessageChannel = _global.MessageChannel;
var Dispatch = _global.Dispatch;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var defer;
var channel;
var port;
var run = function () {
  var id = +this;
  // eslint-disable-next-line no-prototype-builtins
  if (queue.hasOwnProperty(id)) {
    var fn = queue[id];
    delete queue[id];
    fn();
  }
};
var listener = function (event) {
  run.call(event.data);
};
// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!setTask || !clearTask) {
  setTask = function setImmediate(fn) {
    var args = [];
    var i = 1;
    while (arguments.length > i) args.push(arguments[i++]);
    queue[++counter] = function () {
      // eslint-disable-next-line no-new-func
      _invoke(typeof fn == 'function' ? fn : Function(fn), args);
    };
    defer(counter);
    return counter;
  };
  clearTask = function clearImmediate(id) {
    delete queue[id];
  };
  // Node.js 0.8-
  if (_cof(process$2) == 'process') {
    defer = function (id) {
      process$2.nextTick(_ctx(run, id, 1));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(_ctx(run, id, 1));
    };
  // Browsers with MessageChannel, includes WebWorkers
  } else if (MessageChannel) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = _ctx(port.postMessage, port, 1);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (_global.addEventListener && typeof postMessage == 'function' && !_global.importScripts) {
    defer = function (id) {
      _global.postMessage(id + '', '*');
    };
    _global.addEventListener('message', listener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in _domCreate('script')) {
    defer = function (id) {
      _html.appendChild(_domCreate('script'))[ONREADYSTATECHANGE] = function () {
        _html.removeChild(this);
        run.call(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(_ctx(run, id, 1), 0);
    };
  }
}
var _task = {
  set: setTask,
  clear: clearTask
};

var macrotask = _task.set;
var Observer = _global.MutationObserver || _global.WebKitMutationObserver;
var process$3 = _global.process;
var Promise$1 = _global.Promise;
var isNode$1 = _cof(process$3) == 'process';

var _microtask = function () {
  var head, last, notify;

  var flush = function () {
    var parent, fn;
    if (isNode$1 && (parent = process$3.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (e) {
        if (head) notify();
        else last = undefined;
        throw e;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  // Node.js
  if (isNode$1) {
    notify = function () {
      process$3.nextTick(flush);
    };
  // browsers with MutationObserver, except iOS Safari - https://github.com/zloirock/core-js/issues/339
  } else if (Observer && !(_global.navigator && _global.navigator.standalone)) {
    var toggle = true;
    var node = document.createTextNode('');
    new Observer(flush).observe(node, { characterData: true }); // eslint-disable-line no-new
    notify = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (Promise$1 && Promise$1.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    var promise = Promise$1.resolve(undefined);
    notify = function () {
      promise.then(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessag
  // - onreadystatechange
  // - setTimeout
  } else {
    notify = function () {
      // strange IE + webpack dev server bug - use .call(global)
      macrotask.call(_global, flush);
    };
  }

  return function (fn) {
    var task = { fn: fn, next: undefined };
    if (last) last.next = task;
    if (!head) {
      head = task;
      notify();
    } last = task;
  };
};

// 25.4.1.5 NewPromiseCapability(C)


function PromiseCapability(C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = _aFunction(resolve);
  this.reject = _aFunction(reject);
}

var f$1 = function (C) {
  return new PromiseCapability(C);
};

var _newPromiseCapability = {
	f: f$1
};

var _perform = function (exec) {
  try {
    return { e: false, v: exec() };
  } catch (e) {
    return { e: true, v: e };
  }
};

var navigator$1 = _global.navigator;

var _userAgent = navigator$1 && navigator$1.userAgent || '';

var _promiseResolve = function (C, x) {
  _anObject(C);
  if (_isObject(x) && x.constructor === C) return x;
  var promiseCapability = _newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};

var _redefineAll = function (target, src, safe) {
  for (var key in src) {
    if (safe && target[key]) target[key] = src[key];
    else _hide(target, key, src[key]);
  } return target;
};

var SPECIES$1 = _wks('species');

var _setSpecies = function (KEY) {
  var C = typeof _core[KEY] == 'function' ? _core[KEY] : _global[KEY];
  if (_descriptors && C && !C[SPECIES$1]) _objectDp.f(C, SPECIES$1, {
    configurable: true,
    get: function () { return this; }
  });
};

var ITERATOR$3 = _wks('iterator');
var SAFE_CLOSING = false;

try {
  var riter = [7][ITERATOR$3]();
  riter['return'] = function () { SAFE_CLOSING = true; };
  // eslint-disable-next-line no-throw-literal
  
} catch (e) { /* empty */ }

var _iterDetect = function (exec, skipClosing) {
  if (!skipClosing && !SAFE_CLOSING) return false;
  var safe = false;
  try {
    var arr = [7];
    var iter = arr[ITERATOR$3]();
    iter.next = function () { return { done: safe = true }; };
    arr[ITERATOR$3] = function () { return iter; };
    exec(arr);
  } catch (e) { /* empty */ }
  return safe;
};

var task = _task.set;
var microtask = _microtask();




var PROMISE = 'Promise';
var TypeError$1 = _global.TypeError;
var process$1 = _global.process;
var versions = process$1 && process$1.versions;
var v8 = versions && versions.v8 || '';
var $Promise = _global[PROMISE];
var isNode = _classof(process$1) == 'process';
var empty = function () { /* empty */ };
var Internal;
var newGenericPromiseCapability;
var OwnPromiseCapability;
var Wrapper;
var newPromiseCapability = newGenericPromiseCapability = _newPromiseCapability.f;

var USE_NATIVE = !!function () {
  try {
    // correct subclassing with @@species support
    var promise = $Promise.resolve(1);
    var FakePromise = (promise.constructor = {})[_wks('species')] = function (exec) {
      exec(empty, empty);
    };
    // unhandled rejections tracking support, NodeJS Promise without it fails @@species test
    return (isNode || typeof PromiseRejectionEvent == 'function')
      && promise.then(empty) instanceof FakePromise
      // v8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
      // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
      // we can't detect it synchronously, so just check versions
      && v8.indexOf('6.6') !== 0
      && _userAgent.indexOf('Chrome/66') === -1;
  } catch (e) { /* empty */ }
}();

// helpers
var isThenable = function (it) {
  var then;
  return _isObject(it) && typeof (then = it.then) == 'function' ? then : false;
};
var notify = function (promise, isReject) {
  if (promise._n) return;
  promise._n = true;
  var chain = promise._c;
  microtask(function () {
    var value = promise._v;
    var ok = promise._s == 1;
    var i = 0;
    var run = function (reaction) {
      var handler = ok ? reaction.ok : reaction.fail;
      var resolve = reaction.resolve;
      var reject = reaction.reject;
      var domain = reaction.domain;
      var result, then, exited;
      try {
        if (handler) {
          if (!ok) {
            if (promise._h == 2) onHandleUnhandled(promise);
            promise._h = 1;
          }
          if (handler === true) result = value;
          else {
            if (domain) domain.enter();
            result = handler(value); // may throw
            if (domain) {
              domain.exit();
              exited = true;
            }
          }
          if (result === reaction.promise) {
            reject(TypeError$1('Promise-chain cycle'));
          } else if (then = isThenable(result)) {
            then.call(result, resolve, reject);
          } else resolve(result);
        } else reject(value);
      } catch (e) {
        if (domain && !exited) domain.exit();
        reject(e);
      }
    };
    while (chain.length > i) run(chain[i++]); // variable length - can't use forEach
    promise._c = [];
    promise._n = false;
    if (isReject && !promise._h) onUnhandled(promise);
  });
};
var onUnhandled = function (promise) {
  task.call(_global, function () {
    var value = promise._v;
    var unhandled = isUnhandled(promise);
    var result, handler, console;
    if (unhandled) {
      result = _perform(function () {
        if (isNode) {
          process$1.emit('unhandledRejection', value, promise);
        } else if (handler = _global.onunhandledrejection) {
          handler({ promise: promise, reason: value });
        } else if ((console = _global.console) && console.error) {
          console.error('Unhandled promise rejection', value);
        }
      });
      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
      promise._h = isNode || isUnhandled(promise) ? 2 : 1;
    } promise._a = undefined;
    if (unhandled && result.e) throw result.v;
  });
};
var isUnhandled = function (promise) {
  return promise._h !== 1 && (promise._a || promise._c).length === 0;
};
var onHandleUnhandled = function (promise) {
  task.call(_global, function () {
    var handler;
    if (isNode) {
      process$1.emit('rejectionHandled', promise);
    } else if (handler = _global.onrejectionhandled) {
      handler({ promise: promise, reason: promise._v });
    }
  });
};
var $reject = function (value) {
  var promise = this;
  if (promise._d) return;
  promise._d = true;
  promise = promise._w || promise; // unwrap
  promise._v = value;
  promise._s = 2;
  if (!promise._a) promise._a = promise._c.slice();
  notify(promise, true);
};
var $resolve = function (value) {
  var promise = this;
  var then;
  if (promise._d) return;
  promise._d = true;
  promise = promise._w || promise; // unwrap
  try {
    if (promise === value) throw TypeError$1("Promise can't be resolved itself");
    if (then = isThenable(value)) {
      microtask(function () {
        var wrapper = { _w: promise, _d: false }; // wrap
        try {
          then.call(value, _ctx($resolve, wrapper, 1), _ctx($reject, wrapper, 1));
        } catch (e) {
          $reject.call(wrapper, e);
        }
      });
    } else {
      promise._v = value;
      promise._s = 1;
      notify(promise, false);
    }
  } catch (e) {
    $reject.call({ _w: promise, _d: false }, e); // wrap
  }
};

// constructor polyfill
if (!USE_NATIVE) {
  // 25.4.3.1 Promise(executor)
  $Promise = function Promise(executor) {
    _anInstance(this, $Promise, PROMISE, '_h');
    _aFunction(executor);
    Internal.call(this);
    try {
      executor(_ctx($resolve, this, 1), _ctx($reject, this, 1));
    } catch (err) {
      $reject.call(this, err);
    }
  };
  // eslint-disable-next-line no-unused-vars
  Internal = function Promise(executor) {
    this._c = [];             // <- awaiting reactions
    this._a = undefined;      // <- checked in isUnhandled reactions
    this._s = 0;              // <- state
    this._d = false;          // <- done
    this._v = undefined;      // <- value
    this._h = 0;              // <- rejection state, 0 - default, 1 - handled, 2 - unhandled
    this._n = false;          // <- notify
  };
  Internal.prototype = _redefineAll($Promise.prototype, {
    // 25.4.5.3 Promise.prototype.then(onFulfilled, onRejected)
    then: function then(onFulfilled, onRejected) {
      var reaction = newPromiseCapability(_speciesConstructor(this, $Promise));
      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
      reaction.fail = typeof onRejected == 'function' && onRejected;
      reaction.domain = isNode ? process$1.domain : undefined;
      this._c.push(reaction);
      if (this._a) this._a.push(reaction);
      if (this._s) notify(this, false);
      return reaction.promise;
    },
    // 25.4.5.1 Promise.prototype.catch(onRejected)
    'catch': function (onRejected) {
      return this.then(undefined, onRejected);
    }
  });
  OwnPromiseCapability = function () {
    var promise = new Internal();
    this.promise = promise;
    this.resolve = _ctx($resolve, promise, 1);
    this.reject = _ctx($reject, promise, 1);
  };
  _newPromiseCapability.f = newPromiseCapability = function (C) {
    return C === $Promise || C === Wrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };
}

_export(_export.G + _export.W + _export.F * !USE_NATIVE, { Promise: $Promise });
_setToStringTag($Promise, PROMISE);
_setSpecies(PROMISE);
Wrapper = _core[PROMISE];

// statics
_export(_export.S + _export.F * !USE_NATIVE, PROMISE, {
  // 25.4.4.5 Promise.reject(r)
  reject: function reject(r) {
    var capability = newPromiseCapability(this);
    var $$reject = capability.reject;
    $$reject(r);
    return capability.promise;
  }
});
_export(_export.S + _export.F * (_library || !USE_NATIVE), PROMISE, {
  // 25.4.4.6 Promise.resolve(x)
  resolve: function resolve(x) {
    return _promiseResolve(_library && this === Wrapper ? $Promise : this, x);
  }
});
_export(_export.S + _export.F * !(USE_NATIVE && _iterDetect(function (iter) {
  $Promise.all(iter)['catch'](empty);
})), PROMISE, {
  // 25.4.4.1 Promise.all(iterable)
  all: function all(iterable) {
    var C = this;
    var capability = newPromiseCapability(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = _perform(function () {
      var values = [];
      var index = 0;
      var remaining = 1;
      _forOf(iterable, false, function (promise) {
        var $index = index++;
        var alreadyCalled = false;
        values.push(undefined);
        remaining++;
        C.resolve(promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[$index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.e) reject(result.v);
    return capability.promise;
  },
  // 25.4.4.4 Promise.race(iterable)
  race: function race(iterable) {
    var C = this;
    var capability = newPromiseCapability(C);
    var reject = capability.reject;
    var result = _perform(function () {
      _forOf(iterable, false, function (promise) {
        C.resolve(promise).then(capability.resolve, reject);
      });
    });
    if (result.e) reject(result.v);
    return capability.promise;
  }
});

_export(_export.P + _export.R, 'Promise', { 'finally': function (onFinally) {
  var C = _speciesConstructor(this, _core.Promise || _global.Promise);
  var isFunction = typeof onFinally == 'function';
  return this.then(
    isFunction ? function (x) {
      return _promiseResolve(C, onFinally()).then(function () { return x; });
    } : onFinally,
    isFunction ? function (e) {
      return _promiseResolve(C, onFinally()).then(function () { throw e; });
    } : onFinally
  );
} });

// https://github.com/tc39/proposal-promise-try




_export(_export.S, 'Promise', { 'try': function (callbackfn) {
  var promiseCapability = _newPromiseCapability.f(this);
  var result = _perform(callbackfn);
  (result.e ? promiseCapability.reject : promiseCapability.resolve)(result.v);
  return promiseCapability.promise;
} });

var promise$1 = _core.Promise;

var promise = createCommonjsModule(function (module) {
module.exports = { "default": promise$1, __esModule: true };
});

var _Promise = unwrapExports(promise);

var asyncToGenerator = createCommonjsModule(function (module, exports) {
exports.__esModule = true;



var _promise2 = _interopRequireDefault(promise);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (fn) {
  return function () {
    var gen = fn.apply(this, arguments);
    return new _promise2.default(function (resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }

        if (info.done) {
          resolve(value);
        } else {
          return _promise2.default.resolve(value).then(function (value) {
            step("next", value);
          }, function (err) {
            step("throw", err);
          });
        }
      }

      return step("next");
    });
  };
};
});

var _asyncToGenerator = unwrapExports(asyncToGenerator);

var vconsole_min = createCommonjsModule(function (module, exports) {
/*!
 * vConsole v3.3.4 (https://github.com/Tencent/vConsole)
 * 
 * Tencent is pleased to support the open source community by making vConsole available.
 * Copyright (C) 2017 THL A29 Limited, a Tencent company. All rights reserved.
 * Licensed under the MIT License (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://opensource.org/licenses/MIT
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
!function(e,t){module.exports=t();}(window,function(){return function(e){var t={};function o(n){if(t[n])return t[n].exports;var r=t[n]={i:n,l:!1,exports:{}};return e[n].call(r.exports,r,r.exports,o), r.l=!0, r.exports}return o.m=e, o.c=t, o.d=function(e,t,n){o.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n});}, o.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}), Object.defineProperty(e,"__esModule",{value:!0});}, o.t=function(e,t){if(1&t&&(e=o(e)), 8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(o.r(n), Object.defineProperty(n,"default",{enumerable:!0,value:e}), 2&t&&"string"!=typeof e)for(var r in e)o.d(n,r,function(t){return e[t]}.bind(null,r));return n}, o.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return o.d(t,"a",t), t}, o.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)}, o.p="", o(o.s=6)}([function(e,t,o){var n,r,i;r=[t], void 0===(i="function"==typeof(n=function(e){function t(e){return(t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function o(e){return"[object Number]"==Object.prototype.toString.call(e)}function n(e){return"[object String]"==Object.prototype.toString.call(e)}function r(e){return"[object Array]"==Object.prototype.toString.call(e)}function i(e){return"[object Boolean]"==Object.prototype.toString.call(e)}function a(e){return void 0===e}function l(e){return null===e}function c(e){return"[object Symbol]"==Object.prototype.toString.call(e)}function s(e){return!("[object Object]"!=Object.prototype.toString.call(e)&&(o(e)||n(e)||i(e)||r(e)||l(e)||d(e)||a(e)||c(e)))}function d(e){return"[object Function]"==Object.prototype.toString.call(e)}function u(e){var t=Object.prototype.toString.call(e);return"[object global]"==t||"[object Window]"==t||"[object DOMWindow]"==t}function v(e){if(!s(e)&&!r(e))return[];if(r(e)){var t=[];return e.forEach(function(e,o){t.push(o);}), t}return Object.getOwnPropertyNames(e).sort()}Object.defineProperty(e,"__esModule",{value:!0}), e.getDate=function(e){var t=e>0?new Date(e):new Date,o=t.getDate()<10?"0"+t.getDate():t.getDate(),n=t.getMonth()<9?"0"+(t.getMonth()+1):t.getMonth()+1,r=t.getFullYear(),i=t.getHours()<10?"0"+t.getHours():t.getHours(),a=t.getMinutes()<10?"0"+t.getMinutes():t.getMinutes(),l=t.getSeconds()<10?"0"+t.getSeconds():t.getSeconds(),c=t.getMilliseconds()<10?"0"+t.getMilliseconds():t.getMilliseconds();return c<100&&(c="0"+c), {time:+t,year:r,month:n,day:o,hour:i,minute:a,second:l,millisecond:c}}, e.isNumber=o, e.isString=n, e.isArray=r, e.isBoolean=i, e.isUndefined=a, e.isNull=l, e.isSymbol=c, e.isObject=s, e.isFunction=d, e.isElement=function(e){return"object"===("undefined"==typeof HTMLElement?"undefined":t(HTMLElement))?e instanceof HTMLElement:e&&"object"===t(e)&&null!==e&&1===e.nodeType&&"string"==typeof e.nodeName}, e.isWindow=u, e.isPlainObject=function(e){var o,n=Object.prototype.hasOwnProperty;if(!e||"object"!==t(e)||e.nodeType||u(e))return!1;try{if(e.constructor&&!n.call(e,"constructor")&&!n.call(e.constructor.prototype,"isPrototypeOf"))return!1}catch(e){return!1}for(o in e);return void 0===o||n.call(e,o)}, e.htmlEncode=function(e){return document.createElement("a").appendChild(document.createTextNode(e)).parentNode.innerHTML}, e.JSONStringify=function(e){if(!s(e)&&!r(e))return JSON.stringify(e);var t="{",o="}";r(e)&&(t="[", o="]");for(var n=t,i=v(e),a=0;a<i.length;a++){var l=i[a],u=e[l];try{r(e)||(s(l)||r(l)||c(l)?n+=Object.prototype.toString.call(l):n+=l, n+=": "), r(u)?n+="Array["+u.length+"]":s(u)||c(u)||d(u)?n+=Object.prototype.toString.call(u):n+=JSON.stringify(u), a<i.length-1&&(n+=", ");}catch(e){continue}}return n+=o}, e.getObjAllKeys=v, e.getObjName=function(e){return Object.prototype.toString.call(e).replace("[object ","").replace("]","")}, e.setStorage=function(e,t){window.localStorage&&(e="vConsole_"+e, localStorage.setItem(e,t));}, e.getStorage=function(e){if(window.localStorage)return e="vConsole_"+e, localStorage.getItem(e)};})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n,r,i;r=[t,o(0),o(10)], void 0===(i="function"==typeof(n=function(o,n,r){var i;Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, r=(i=r)&&i.__esModule?i:{default:i};var a={one:function(e,t){try{return(t||document).querySelector(e)||void 0}catch(e){return}},all:function(e,t){try{var o=(t||document).querySelectorAll(e);return Array.from(o)}catch(e){return[]}},addClass:function(e,t){if(e){(0, n.isArray)(e)||(e=[e]);for(var o=0;o<e.length;o++){var r=(e[o].className||"").split(" ");r.indexOf(t)>-1||(r.push(t), e[o].className=r.join(" "));}}},removeClass:function(e,t){if(e){(0, n.isArray)(e)||(e=[e]);for(var o=0;o<e.length;o++){for(var r=e[o].className.split(" "),i=0;i<r.length;i++)r[i]==t&&(r[i]="");e[o].className=r.join(" ").trim();}}},hasClass:function(e,t){return!(!e||!e.classList)&&e.classList.contains(t)},bind:function(e,t,o,r){e&&((0, n.isArray)(e)||(e=[e]), e.forEach(function(e){e.addEventListener(t,o,!!r);}));},delegate:function(e,t,o,n){e&&e.addEventListener(t,function(t){var r=a.all(o,e);if(r)e:for(var i=0;i<r.length;i++)for(var l=t.target;l;){if(l==r[i]){n.call(l,t);break e}if((l=l.parentNode)==e)break}},!1);}};a.render=r.default;var l=a;o.default=l, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n,r,i;r=[t], void 0===(i="function"==typeof(n=function(o){function n(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0;var r=function(){function e(t){var o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"newPlugin";!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e), this.id=t, this.name=o, this.isReady=!1, this.eventList={};}var t,o,r;return t=e, (o=[{key:"on",value:function(e,t){return this.eventList[e]=t, this}},{key:"trigger",value:function(e,t){if("function"==typeof this.eventList[e])this.eventList[e].call(this,t);else{var o="on"+e.charAt(0).toUpperCase()+e.slice(1);"function"==typeof this[o]&&this[o].call(this,t);}return this}},{key:"id",get:function(){return this._id},set:function(e){if(!e)throw"Plugin ID cannot be empty";this._id=e.toLowerCase();}},{key:"name",get:function(){return this._name},set:function(e){if(!e)throw"Plugin name cannot be empty";this._name=e;}},{key:"vConsole",get:function(){return this._vConsole||void 0},set:function(e){if(!e)throw"vConsole cannot be empty";this._vConsole=e;}}])&&n(t.prototype,o), r&&n(t,r), e}();o.default=r, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n,r,i;r=[t,o(0),o(1),o(2),o(18),o(19),o(20)], void 0===(i="function"==typeof(n=function(o,n,r,i,a,l,c){function s(e){return e&&e.__esModule?e:{default:e}}function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function u(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function v(e,t){return!t||"object"!==d(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e):t}function f(e){return(f=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function p(e,t){return(p=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(n), r=s(r), i=s(i), a=s(a), l=s(l), c=s(c);var b=1e3,g=[],h={},m=function(e){function t(){var e,o;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);for(var n=arguments.length,r=new Array(n),i=0;i<n;i++)r[i]=arguments[i];return o=v(this,(e=f(t)).call.apply(e,[this].concat(r))), g.push(o.id), o.tplTabbox="", o.allowUnformattedLog=!0, o.isReady=!1, o.isShow=!1, o.$tabbox=null, o.console={}, o.logList=[], o.isInBottom=!0, o.maxLogNumber=b, o.logNumber=0, o.mockConsole(), o}var o,s,m;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&p(e,t);}(t,i.default), o=t, (s=[{key:"onInit",value:function(){this.$tabbox=r.default.render(this.tplTabbox,{}), this.updateMaxLogNumber();}},{key:"onRenderTab",value:function(e){e(this.$tabbox);}},{key:"onAddTopBar",value:function(e){for(var t=this,o=["All","Log","Info","Warn","Error"],n=[],i=0;i<o.length;i++)n.push({name:o[i],data:{type:o[i].toLowerCase()},className:"",onClick:function(){if(r.default.hasClass(this,"vc-actived"))return!1;t.showLogType(this.dataset.type||"all");}});n[0].className="vc-actived", e(n);}},{key:"onAddTool",value:function(e){var t=this;e([{name:"Clear",global:!1,onClick:function(){t.clearLog(), t.vConsole.triggerEvent("clearLog");}}]);}},{key:"onReady",value:function(){var e=this;e.isReady=!0;var t=r.default.all(".vc-subtab",e.$tabbox);r.default.bind(t,"click",function(o){if(o.preventDefault(), r.default.hasClass(this,"vc-actived"))return!1;r.default.removeClass(t,"vc-actived"), r.default.addClass(this,"vc-actived");var n=this.dataset.type,i=r.default.one(".vc-log",e.$tabbox);r.default.removeClass(i,"vc-log-partly-log"), r.default.removeClass(i,"vc-log-partly-info"), r.default.removeClass(i,"vc-log-partly-warn"), r.default.removeClass(i,"vc-log-partly-error"), "all"==n?r.default.removeClass(i,"vc-log-partly"):(r.default.addClass(i,"vc-log-partly"), r.default.addClass(i,"vc-log-partly-"+n));});var o=r.default.one(".vc-content");r.default.bind(o,"scroll",function(t){e.isShow&&(o.scrollTop+o.offsetHeight>=o.scrollHeight?e.isInBottom=!0:e.isInBottom=!1);});for(var n=0;n<e.logList.length;n++)e.printLog(e.logList[n]);e.logList=[];}},{key:"onRemove",value:function(){window.console.log=this.console.log, window.console.info=this.console.info, window.console.warn=this.console.warn, window.console.debug=this.console.debug, window.console.error=this.console.error, window.console.time=this.console.time, window.console.timeEnd=this.console.timeEnd, window.console.clear=this.console.clear, this.console={};var e=g.indexOf(this.id);e>-1&&g.splice(e,1);}},{key:"onShow",value:function(){this.isShow=!0, 1==this.isInBottom&&this.autoScrollToBottom();}},{key:"onHide",value:function(){this.isShow=!1;}},{key:"onShowConsole",value:function(){1==this.isInBottom&&this.autoScrollToBottom();}},{key:"onUpdateOption",value:function(){this.vConsole.option.maxLogNumber!=this.maxLogNumber&&(this.updateMaxLogNumber(), this.limitMaxLogs());}},{key:"updateMaxLogNumber",value:function(){this.maxLogNumber=this.vConsole.option.maxLogNumber||b, this.maxLogNumber=Math.max(1,this.maxLogNumber);}},{key:"limitMaxLogs",value:function(){if(this.isReady)for(;this.logNumber>this.maxLogNumber;){var e=r.default.one(".vc-item",this.$tabbox);if(!e)break;e.parentNode.removeChild(e), this.logNumber--;}}},{key:"showLogType",value:function(e){var t=r.default.one(".vc-log",this.$tabbox);r.default.removeClass(t,"vc-log-partly-log"), r.default.removeClass(t,"vc-log-partly-info"), r.default.removeClass(t,"vc-log-partly-warn"), r.default.removeClass(t,"vc-log-partly-error"), "all"==e?r.default.removeClass(t,"vc-log-partly"):(r.default.addClass(t,"vc-log-partly"), r.default.addClass(t,"vc-log-partly-"+e));}},{key:"autoScrollToBottom",value:function(){this.vConsole.option.disableLogScrolling||this.scrollToBottom();}},{key:"scrollToBottom",value:function(){var e=r.default.one(".vc-content");e&&(e.scrollTop=e.scrollHeight-e.offsetHeight);}},{key:"mockConsole",value:function(){var e=this,t=this,o=["log","info","warn","debug","error"];window.console?(o.map(function(e){t.console[e]=window.console[e];}), t.console.time=window.console.time, t.console.timeEnd=window.console.timeEnd, t.console.clear=window.console.clear):window.console={}, o.map(function(t){window.console[t]=function(){for(var o=arguments.length,n=new Array(o),r=0;r<o;r++)n[r]=arguments[r];e.printLog({logType:t,logs:n});};});var n={};window.console.time=function(e){n[e]=Date.now();}, window.console.timeEnd=function(e){var t=n[e];t?(console.log(e+":",Date.now()-t+"ms"), delete n[e]):console.log(e+": 0ms");}, window.console.clear=function(){t.clearLog();for(var e=arguments.length,o=new Array(e),n=0;n<e;n++)o[n]=arguments[n];t.console.clear.apply(window.console,o);};}},{key:"clearLog",value:function(){r.default.one(".vc-log",this.$tabbox).innerHTML="", this.logNumber=0, h={};}},{key:"printOriginLog",value:function(e){"function"==typeof this.console[e.logType]&&this.console[e.logType].apply(window.console,e.logs);}},{key:"printLog",value:function(e){var t=e.logs||[];if(t.length||e.content){t=[].slice.call(t||[]);var o=/^\[(\w+)\]$/i,r="",i=!1;if(n.isString(t[0])){var a=t[0].match(o);null!==a&&a.length>0&&(r=a[1].toLowerCase(), i=g.indexOf(r)>-1);}if(r===this.id||!0!==i&&"default"===this.id)if(e._id||(e._id="__vc_"+Math.random().toString(36).substring(2,8)), e.date||(e.date=+new Date), this.isReady){n.isString(t[0])&&i&&(t[0]=t[0].replace(o,""), ""===t[0]&&t.shift());for(var l={_id:e._id,logType:e.logType,logText:[],hasContent:!!e.content,count:1},c=0;c<t.length;c++)n.isFunction(t[c])?l.logText.push(t[c].toString()):n.isObject(t[c])||n.isArray(t[c])?l.logText.push(n.JSONStringify(t[c])):l.logText.push(t[c]);l.logText=l.logText.join(" "), l.hasContent||h.logType!==l.logType||h.logText!==l.logText?(this.printNewLog(e,t), h=l):this.printRepeatLog(), this.isInBottom&&this.isShow&&this.autoScrollToBottom(), e.noOrigin||this.printOriginLog(e);}else this.logList.push(e);else e.noOrigin||this.printOriginLog(e);}}},{key:"printRepeatLog",value:function(){var e=r.default.one("#"+h._id),t=r.default.one(".vc-item-repeat",e);t||((t=document.createElement("i")).className="vc-item-repeat", e.insertBefore(t,e.lastChild)), h.count, h.count++, t.innerHTML=h.count;}},{key:"printNewLog",value:function(e,t){var o=r.default.render(a.default,{_id:e._id,logType:e.logType,style:e.style||""}),i=/(\%c )|( \%c)/g,l=[];if(n.isString(t[0])&&i.test(t[0])){for(var c=t[0].split(i).filter(function(e){return void 0!==e&&""!==e&&!/ ?\%c ?/.test(e)}),s=t[0].match(i),u=0;u<s.length;u++)n.isString(t[u+1])&&l.push(t[u+1]);for(var v=s.length+1;v<t.length;v++)c.push(t[v]);t=c;}for(var f=r.default.one(".vc-item-content",o),p=0;p<t.length;p++){var b=void 0;try{if(""===t[p])continue;b=n.isFunction(t[p])?"<span> "+t[p].toString()+"</span>":n.isObject(t[p])||n.isArray(t[p])?this.getFoldedLine(t[p]):(l[p]?'<span style="'.concat(l[p],'"> '):"<span> ")+n.htmlEncode(t[p]).replace(/\n/g,"<br/>")+"</span>";}catch(e){b="<span> ["+d(t[p])+"]</span>";}b&&("string"==typeof b?f.insertAdjacentHTML("beforeend",b):f.insertAdjacentElement("beforeend",b));}n.isObject(e.content)&&f.insertAdjacentElement("beforeend",e.content), r.default.one(".vc-log",this.$tabbox).insertAdjacentElement("beforeend",o), this.logNumber++, this.limitMaxLogs();}},{key:"getFoldedLine",value:function(e,t){var o=this;if(!t){var i=n.JSONStringify(e),a=i.substr(0,36);t=n.getObjName(e), i.length>36&&(a+="..."), t+=" "+a;}var s=r.default.render(l.default,{outer:t,lineType:"obj"});return r.default.bind(r.default.one(".vc-fold-outer",s),"click",function(t){t.preventDefault(), t.stopPropagation(), r.default.hasClass(s,"vc-toggle")?(r.default.removeClass(s,"vc-toggle"), r.default.removeClass(r.default.one(".vc-fold-inner",s),"vc-toggle"), r.default.removeClass(r.default.one(".vc-fold-outer",s),"vc-toggle")):(r.default.addClass(s,"vc-toggle"), r.default.addClass(r.default.one(".vc-fold-inner",s),"vc-toggle"), r.default.addClass(r.default.one(".vc-fold-outer",s),"vc-toggle"));var i=r.default.one(".vc-fold-inner",s);return setTimeout(function(){if(0==i.children.length&&e){for(var t=n.getObjAllKeys(e),a=0;a<t.length;a++){var s=void 0,d="undefined",u="";try{s=e[t[a]];}catch(e){continue}n.isString(s)?(d="string", s='"'+s+'"'):n.isNumber(s)?d="number":n.isBoolean(s)?d="boolean":n.isNull(s)?(d="null", s="null"):n.isUndefined(s)?(d="undefined", s="undefined"):n.isFunction(s)?(d="function", s="function()"):n.isSymbol(s)&&(d="symbol");var v=void 0;if(n.isArray(s)){var f=n.getObjName(s)+"["+s.length+"]";v=o.getFoldedLine(s,r.default.render(c.default,{key:t[a],keyType:u,value:f,valueType:"array"},!0));}else if(n.isObject(s)){var p=n.getObjName(s);v=o.getFoldedLine(s,r.default.render(c.default,{key:n.htmlEncode(t[a]),keyType:u,value:p,valueType:"object"},!0));}else{e.hasOwnProperty&&!e.hasOwnProperty(t[a])&&(u="private");var b={lineType:"kv",key:n.htmlEncode(t[a]),keyType:u,value:n.htmlEncode(s),valueType:d};v=r.default.render(l.default,b);}i.insertAdjacentElement("beforeend",v);}if(n.isObject(e)){var g,h=e.__proto__;g=n.isObject(h)?o.getFoldedLine(h,r.default.render(c.default,{key:"__proto__",keyType:"private",value:n.getObjName(h),valueType:"object"},!0)):r.default.render(c.default,{key:"__proto__",keyType:"private",value:"null",valueType:"null"}), i.insertAdjacentElement("beforeend",g);}}}), !1}), s}}])&&u(o.prototype,s), m&&u(o,m), t}();m.AddedLogID=[];var y=m;o.default=y, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){e.exports=function(e){var t=[];return t.toString=function(){return this.map(function(t){var o=function(e,t){var o=e[1]||"",n=e[3];if(!n)return o;if(t&&"function"==typeof btoa){var r=(a=n, l=btoa(unescape(encodeURIComponent(JSON.stringify(a)))), c="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(l), "/*# ".concat(c," */")),i=n.sources.map(function(e){return"/*# sourceURL=".concat(n.sourceRoot).concat(e," */")});return[o].concat(i).concat([r]).join("\n")}var a,l,c;return[o].join("\n")}(t,e);return t[2]?"@media ".concat(t[2],"{").concat(o,"}"):o}).join("")}, t.i=function(e,o){"string"==typeof e&&(e=[[null,e,""]]);for(var n={},r=0;r<this.length;r++){var i=this[r][0];null!=i&&(n[i]=!0);}for(var a=0;a<e.length;a++){var l=e[a];null!=l[0]&&n[l[0]]||(o&&!l[2]?l[2]=o:o&&(l[2]="(".concat(l[2],") and (").concat(o,")")), t.push(l));}}, t};},function(e,t,o){var n,r={},i=function(){return void 0===n&&(n=Boolean(window&&document&&document.all&&!window.atob)), n},a=function(){var e={};return function(t){if(void 0===e[t]){var o=document.querySelector(t);if(window.HTMLIFrameElement&&o instanceof window.HTMLIFrameElement)try{o=o.contentDocument.head;}catch(e){o=null;}e[t]=o;}return e[t]}}();function l(e,t){for(var o=[],n={},r=0;r<e.length;r++){var i=e[r],a=t.base?i[0]+t.base:i[0],l={css:i[1],media:i[2],sourceMap:i[3]};n[a]?n[a].parts.push(l):o.push(n[a]={id:a,parts:[l]});}return o}function c(e,t){for(var o=0;o<e.length;o++){var n=e[o],i=r[n.id],a=0;if(i){for(i.refs++;a<i.parts.length;a++)i.parts[a](n.parts[a]);for(;a<n.parts.length;a++)i.parts.push(b(n.parts[a],t));}else{for(var l=[];a<n.parts.length;a++)l.push(b(n.parts[a],t));r[n.id]={id:n.id,refs:1,parts:l};}}}function s(e){var t=document.createElement("style");if(void 0===e.attributes.nonce){var n=o.nc;n&&(e.attributes.nonce=n);}if(Object.keys(e.attributes).forEach(function(o){t.setAttribute(o,e.attributes[o]);}), "function"==typeof e.insert)e.insert(t);else{var r=a(e.insert||"head");if(!r)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");r.appendChild(t);}return t}var d,u=(d=[], function(e,t){return d[e]=t, d.filter(Boolean).join("\n")});function v(e,t,o,n){var r=o?"":n.css;if(e.styleSheet)e.styleSheet.cssText=u(t,r);else{var i=document.createTextNode(r),a=e.childNodes;a[t]&&e.removeChild(a[t]), a.length?e.insertBefore(i,a[t]):e.appendChild(i);}}var f=null,p=0;function b(e,t){var o,n,r;if(t.singleton){var i=p++;o=f||(f=s(t)), n=v.bind(null,o,i,!1), r=v.bind(null,o,i,!0);}else o=s(t), n=function(e,t,o){var n=o.css,r=o.media,i=o.sourceMap;if(r&&e.setAttribute("media",r), i&&btoa&&(n+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(i))))," */")), e.styleSheet)e.styleSheet.cssText=n;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(n));}}.bind(null,o,t), r=function(){!function(e){if(null===e.parentNode)return!1;e.parentNode.removeChild(e);}(o);};return n(e), function(t){if(t){if(t.css===e.css&&t.media===e.media&&t.sourceMap===e.sourceMap)return;n(e=t);}else r();}}e.exports=function(e,t){(t=t||{}).attributes="object"==typeof t.attributes?t.attributes:{}, t.singleton||"boolean"==typeof t.singleton||(t.singleton=i());var o=l(e,t);return c(o,t), function(e){for(var n=[],i=0;i<o.length;i++){var a=o[i],s=r[a.id];s&&(s.refs--, n.push(s));}e&&c(l(e,t),t);for(var d=0;d<n.length;d++){var u=n[d];if(0===u.refs){for(var v=0;v<u.parts.length;v++)u.parts[v]();delete r[u.id];}}}};},function(e,t,o){var n,r,i;r=[t,o(7),o(8)], void 0===(i="function"==typeof(n=function(o,n,r){Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0;var i,a=(i=r, r=i&&i.__esModule?i:{default:i}).default;o.default=a, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n,r,i;r=[], void 0===(i="function"==typeof(n=function(){if("undefined"==typeof Symbol){window.Symbol=function(){};var e="__symbol_iterator_key";window.Symbol.iterator=e, Array.prototype[e]=function(){var e=this,t=0;return{next:function(){return{done:e.length===t,value:e.length===t?void 0:e[t++]}}}};}})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n,r,i;r=[t,o(9),o(0),o(1),o(11),o(13),o(14),o(15),o(16),o(17),o(2),o(3),o(21),o(24),o(26),o(30),o(37)], void 0===(i="function"==typeof(n=function(o,n,r,i,a,l,c,s,d,u,v,f,p,b,g,h,m){function y(e){return e&&e.__esModule?e:{default:e}}function _(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=y(n), r=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(r), i=y(i), l=y(l), c=y(c), s=y(s), d=y(d), u=y(u), v=y(v), f=y(f), p=y(p), b=y(b), g=y(g), h=y(h), m=y(m);var w="#__vconsole",x=function(){function e(t){if(function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e), i.default.one(w))console.debug("vConsole is already exists.");else{var o=this;if(this.version=n.default.version, this.$dom=null, this.isInited=!1, this.option={defaultPlugins:["system","network","element","storage"]}, this.activedTab="", this.tabList=[], this.pluginList={}, this.switchPos={x:10,y:10,startX:0,startY:0,endX:0,endY:0}, this.tool=r, this.$=i.default, r.isObject(t))for(var a in t)this.option[a]=t[a];this._addBuiltInPlugins();var l,c=function(){o.isInited||(o._render(), o._mockTap(), o._bindEvent(), o._autoRun());};if(void 0!==document)"loading"===document.readyState?i.default.bind(window,"DOMContentLoaded",c):c();else l=setTimeout(function e(){document&&"complete"==document.readyState?(l&&clearTimeout(l), c()):l=setTimeout(e,1);},1);}}var t,o,a;return t=e, (o=[{key:"_addBuiltInPlugins",value:function(){this.addPlugin(new p.default("default","Log"));var e=this.option.defaultPlugins,t={system:{proto:b.default,name:"System"},network:{proto:g.default,name:"Network"},element:{proto:h.default,name:"Element"},storage:{proto:m.default,name:"Storage"}};if(e&&r.isArray(e))for(var o=0;o<e.length;o++){var n=t[e[o]];n?this.addPlugin(new n.proto(e[o],n.name)):console.debug("Unrecognized default plugin ID:",e[o]);}}},{key:"_render",value:function(){if(!i.default.one(w)){var e=document.createElement("div");e.innerHTML=l.default, document.documentElement.insertAdjacentElement("beforeend",e.children[0]);}this.$dom=i.default.one(w);var t=i.default.one(".vc-switch",this.$dom),o=1*r.getStorage("switch_x"),n=1*r.getStorage("switch_y");(o||n)&&(o+t.offsetWidth>document.documentElement.offsetWidth&&(o=document.documentElement.offsetWidth-t.offsetWidth), n+t.offsetHeight>document.documentElement.offsetHeight&&(n=document.documentElement.offsetHeight-t.offsetHeight), o<0&&(o=0), n<0&&(n=0), this.switchPos.x=o, this.switchPos.y=n, i.default.one(".vc-switch").style.right=o+"px", i.default.one(".vc-switch").style.bottom=n+"px");var a=window.devicePixelRatio||1,c=document.querySelector('[name="viewport"]');if(c&&c.content){var s=c.content.match(/initial\-scale\=\d+(\.\d+)?/);(s?parseFloat(s[0].split("=")[1]):1)<1&&(this.$dom.style.fontSize=13*a+"px");}i.default.one(".vc-mask",this.$dom).style.display="none";}},{key:"_mockTap",value:function(){var e,t,o,n=!1,r=null;this.$dom.addEventListener("touchstart",function(n){if(void 0===e){var i=n.targetTouches[0];t=i.pageX, o=i.pageY, e=n.timeStamp, r=n.target.nodeType===Node.TEXT_NODE?n.target.parentNode:n.target;}},!1), this.$dom.addEventListener("touchmove",function(e){var r=e.changedTouches[0];(Math.abs(r.pageX-t)>10||Math.abs(r.pageY-o)>10)&&(n=!0);}), this.$dom.addEventListener("touchend",function(t){if(!1===n&&t.timeStamp-e<700&&null!=r){var o=!1;switch(r.tagName.toLowerCase()){case"textarea":o=!0;break;case"input":switch(r.type){case"button":case"checkbox":case"file":case"image":case"radio":case"submit":o=!1;break;default:o=!r.disabled&&!r.readOnly;}}o?r.focus():t.preventDefault();var i=t.changedTouches[0],a=document.createEvent("MouseEvents");a.initMouseEvent("click",!0,!0,window,1,i.screenX,i.screenY,i.clientX,i.clientY,!1,!1,!1,!1,0,null), a.forwardedTouchEvent=!0, a.initEvent("click",!0,!0), r.dispatchEvent(a);}e=void 0, n=!1, r=null;},!1);}},{key:"_bindEvent",value:function(){var e=this,t=i.default.one(".vc-switch",e.$dom);i.default.bind(t,"touchstart",function(t){e.switchPos.startX=t.touches[0].pageX, e.switchPos.startY=t.touches[0].pageY;}), i.default.bind(t,"touchend",function(t){e.switchPos.x=e.switchPos.endX, e.switchPos.y=e.switchPos.endY, e.switchPos.startX=0, e.switchPos.startY=0, r.setStorage("switch_x",e.switchPos.x), r.setStorage("switch_y",e.switchPos.y);}), i.default.bind(t,"touchmove",function(o){if(o.touches.length>0){var n=o.touches[0].pageX-e.switchPos.startX,r=o.touches[0].pageY-e.switchPos.startY,i=e.switchPos.x-n,a=e.switchPos.y-r;i+t.offsetWidth>document.documentElement.offsetWidth&&(i=document.documentElement.offsetWidth-t.offsetWidth), a+t.offsetHeight>document.documentElement.offsetHeight&&(a=document.documentElement.offsetHeight-t.offsetHeight), i<0&&(i=0), a<0&&(a=0), t.style.right=i+"px", t.style.bottom=a+"px", e.switchPos.endX=i, e.switchPos.endY=a, o.preventDefault();}}), i.default.bind(i.default.one(".vc-switch",e.$dom),"click",function(){e.show();}), i.default.bind(i.default.one(".vc-hide",e.$dom),"click",function(){e.hide();}), i.default.bind(i.default.one(".vc-mask",e.$dom),"click",function(t){if(t.target!=i.default.one(".vc-mask"))return!1;e.hide();}), i.default.delegate(i.default.one(".vc-tabbar",e.$dom),"click",".vc-tab",function(t){var o=this.dataset.tab;o!=e.activedTab&&e.showTab(o);}), i.default.bind(i.default.one(".vc-panel",e.$dom),"transitionend webkitTransitionEnd oTransitionEnd otransitionend",function(t){if(t.target!=i.default.one(".vc-panel"))return!1;i.default.hasClass(e.$dom,"vc-toggle")||(t.target.style.display="none");});var o=i.default.one(".vc-content",e.$dom),n=!1;i.default.bind(o,"touchstart",function(e){var t=o.scrollTop,r=o.scrollHeight,a=t+o.offsetHeight;0===t?(o.scrollTop=1, 0===o.scrollTop&&(i.default.hasClass(e.target,"vc-cmd-input")||(n=!0))):a===r&&(o.scrollTop=t-1, o.scrollTop===t&&(i.default.hasClass(e.target,"vc-cmd-input")||(n=!0)));}), i.default.bind(o,"touchmove",function(e){n&&e.preventDefault();}), i.default.bind(o,"touchend",function(e){n=!1;});}},{key:"_autoRun",value:function(){for(var e in this.isInited=!0, this.pluginList)this._initPlugin(this.pluginList[e]);this.tabList.length>0&&this.showTab(this.tabList[0]), this.triggerEvent("ready");}},{key:"triggerEvent",value:function(e,t){e="on"+e.charAt(0).toUpperCase()+e.slice(1), r.isFunction(this.option[e])&&this.option[e].apply(this,t);}},{key:"_initPlugin",value:function(e){var t=this;e.vConsole=this, e.trigger("init"), e.trigger("renderTab",function(o){t.tabList.push(e.id);var n=i.default.render(c.default,{id:e.id,name:e.name});i.default.one(".vc-tabbar",t.$dom).insertAdjacentElement("beforeend",n);var a=i.default.render(s.default,{id:e.id});o&&(r.isString(o)?a.innerHTML+=o:r.isFunction(o.appendTo)?o.appendTo(a):r.isElement(o)&&a.insertAdjacentElement("beforeend",o)), i.default.one(".vc-content",t.$dom).insertAdjacentElement("beforeend",a);}), e.trigger("addTopBar",function(o){if(o)for(var n=i.default.one(".vc-topbar",t.$dom),a=function(t){var a=o[t],l=i.default.render(d.default,{name:a.name||"Undefined",className:a.className||"",pluginID:e.id});if(a.data)for(var c in a.data)l.dataset[c]=a.data[c];r.isFunction(a.onClick)&&i.default.bind(l,"click",function(t){!1===a.onClick.call(l)||(i.default.removeClass(i.default.all(".vc-topbar-"+e.id),"vc-actived"), i.default.addClass(l,"vc-actived"));}), n.insertAdjacentElement("beforeend",l);},l=0;l<o.length;l++)a(l);}), e.trigger("addTool",function(o){if(o)for(var n=i.default.one(".vc-tool-last",t.$dom),a=function(t){var a=o[t],l=i.default.render(u.default,{name:a.name||"Undefined",pluginID:e.id});1==a.global&&i.default.addClass(l,"vc-global-tool"), r.isFunction(a.onClick)&&i.default.bind(l,"click",function(e){a.onClick.call(l);}), n.parentNode.insertBefore(l,n);},l=0;l<o.length;l++)a(l);}), e.isReady=!0, e.trigger("ready");}},{key:"_triggerPluginsEvent",value:function(e){for(var t in this.pluginList)this.pluginList[t].isReady&&this.pluginList[t].trigger(e);}},{key:"_triggerPluginEvent",value:function(e,t){var o=this.pluginList[e];o&&o.isReady&&o.trigger(t);}},{key:"addPlugin",value:function(e){return void 0!==this.pluginList[e.id]?(console.debug("Plugin "+e.id+" has already been added."), !1):(this.pluginList[e.id]=e, this.isInited&&(this._initPlugin(e), 1==this.tabList.length&&this.showTab(this.tabList[0])), !0)}},{key:"removePlugin",value:function(e){e=(e+"").toLowerCase();var t=this.pluginList[e];if(void 0===t)return console.debug("Plugin "+e+" does not exist."), !1;if(t.trigger("remove"), this.isInited){var o=i.default.one("#__vc_tab_"+e);o&&o.parentNode.removeChild(o);for(var n=i.default.all(".vc-topbar-"+e,this.$dom),r=0;r<n.length;r++)n[r].parentNode.removeChild(n[r]);var a=i.default.one("#__vc_log_"+e);a&&a.parentNode.removeChild(a);for(var l=i.default.all(".vc-tool-"+e,this.$dom),c=0;c<l.length;c++)l[c].parentNode.removeChild(l[c]);}var s=this.tabList.indexOf(e);s>-1&&this.tabList.splice(s,1);try{delete this.pluginList[e];}catch(t){this.pluginList[e]=void 0;}return this.activedTab==e&&this.tabList.length>0&&this.showTab(this.tabList[0]), !0}},{key:"show",value:function(){if(this.isInited){var e=this;i.default.one(".vc-panel",this.$dom).style.display="block", setTimeout(function(){i.default.addClass(e.$dom,"vc-toggle"), e._triggerPluginsEvent("showConsole"), i.default.one(".vc-mask",e.$dom).style.display="block";},10);}}},{key:"hide",value:function(){if(this.isInited){i.default.removeClass(this.$dom,"vc-toggle"), this._triggerPluginsEvent("hideConsole");var e=i.default.one(".vc-mask",this.$dom),t=i.default.one(".vc-panel",this.$dom);i.default.bind(e,"transitionend",function(o){e.style.display="none", t.style.display="none";});}}},{key:"showSwitch",value:function(){this.isInited&&(i.default.one(".vc-switch",this.$dom).style.display="block");}},{key:"hideSwitch",value:function(){this.isInited&&(i.default.one(".vc-switch",this.$dom).style.display="none");}},{key:"showTab",value:function(e){if(this.isInited){var t=i.default.one("#__vc_log_"+e);i.default.removeClass(i.default.all(".vc-tab",this.$dom),"vc-actived"), i.default.addClass(i.default.one("#__vc_tab_"+e),"vc-actived"), i.default.removeClass(i.default.all(".vc-logbox",this.$dom),"vc-actived"), i.default.addClass(t,"vc-actived");var o=i.default.all(".vc-topbar-"+e,this.$dom);i.default.removeClass(i.default.all(".vc-toptab",this.$dom),"vc-toggle"), i.default.addClass(o,"vc-toggle"), o.length>0?i.default.addClass(i.default.one(".vc-content",this.$dom),"vc-has-topbar"):i.default.removeClass(i.default.one(".vc-content",this.$dom),"vc-has-topbar"), i.default.removeClass(i.default.all(".vc-tool",this.$dom),"vc-toggle"), i.default.addClass(i.default.all(".vc-tool-"+e,this.$dom),"vc-toggle"), this.activedTab&&this._triggerPluginEvent(this.activedTab,"hide"), this.activedTab=e, this._triggerPluginEvent(this.activedTab,"show");}}},{key:"setOption",value:function(e,t){if(r.isString(e))this.option[e]=t, this._triggerPluginsEvent("updateOption");else if(r.isObject(e)){for(var o in e)this.option[o]=e[o];this._triggerPluginsEvent("updateOption");}else console.debug("The first parameter of vConsole.setOption() must be a string or an object.");}},{key:"destroy",value:function(){if(this.isInited){for(var e=Object.keys(this.pluginList),t=e.length-1;t>=0;t--)this.removePlugin(e[t]);this.$dom.parentNode.removeChild(this.$dom), this.isInited=!1;}}}])&&_(t.prototype,o), a&&_(t,a), e}();x.VConsolePlugin=v.default, x.VConsoleLogPlugin=f.default, x.VConsoleDefaultPlugin=p.default, x.VConsoleSystemPlugin=b.default, x.VConsoleNetworkPlugin=g.default, x.VConsoleElementPlugin=h.default, x.VConsoleStoragePlugin=m.default;var k=x;o.default=k, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e){e.exports=JSON.parse('{"name":"vconsole","version":"3.3.4","description":"A lightweight, extendable front-end developer tool for mobile web page.","homepage":"https://github.com/Tencent/vConsole","main":"dist/vconsole.min.js","typings":"dist/vconsole.min.d.ts","scripts":{"test":"mocha","build":"webpack"},"keywords":["console","debug","mobile"],"repository":{"type":"git","url":"git+https://github.com/Tencent/vConsole.git"},"dependencies":{},"devDependencies":{"@babel/core":"^7.5.5","@babel/plugin-proposal-class-properties":"^7.5.5","@babel/plugin-proposal-export-namespace-from":"^7.5.2","@babel/plugin-proposal-object-rest-spread":"^7.5.5","@babel/preset-env":"^7.5.5","babel-loader":"^8.0.6","babel-plugin-add-module-exports":"^1.0.2","chai":"^4.2.0","copy-webpack-plugin":"^5.0.4","css-loader":"^3.2.0","html-loader":"^0.5.5","jsdom":"^15.1.1","json-loader":"^0.5.7","less":"^3.10.0","less-loader":"^5.0.0","mocha":"^5.2.0","style-loader":"^1.0.0","webpack":"^4.39.2","webpack-cli":"^3.3.6"},"author":"Tencent","license":"MIT"}');},function(e,t,o){var n,r,i;r=[t], void 0===(i="function"==typeof(n=function(o){Object.defineProperty(o,"__esModule",{value:!0}), o.default=function(e,t,o){var n=/\{\{([^\}]+)\}\}/g,r="",i="",a=0,l=[],c=function(e,t){""!==e&&(t?e.match(/^ ?else/g)?r+="} "+e+" {\n":e.match(/\/(if|for|switch)/g)?r+="}\n":e.match(/^ ?if|for|switch/g)?r+=e+" {\n":e.match(/^ ?(break|continue) ?$/g)?r+=e+";\n":e.match(/^ ?(case|default)/g)?r+=e+":\n":r+="arr.push("+e+");\n":r+='arr.push("'+e.replace(/"/g,'\\"')+'");\n');};for(window.__mito_data=t, window.__mito_code="", window.__mito_result="", e=(e=e.replace(/(\{\{ ?switch(.+?)\}\})[\r\n\t ]+\{\{/g,"$1{{")).replace(/^[\r\n]/,"").replace(/\n/g,"\\\n").replace(/\r/g,"\\\r"), i="(function(){\n", r="var arr = [];\n";l=n.exec(e);)c(e.slice(a,l.index),!1), c(l[1],!0), a=l.index+l[0].length;c(e.substr(a,e.length-a),!1), i+=r="with (__mito_data) {\n"+(r+='__mito_result = arr.join("");')+"\n}", i+="})();";var s=document.getElementsByTagName("script"),d="";s.length>0&&(d=s[0].nonce||"");var u=document.createElement("SCRIPT");u.innerHTML=i, u.setAttribute("nonce",d), document.documentElement.appendChild(u);var v=__mito_result;if(document.documentElement.removeChild(u), !o){var f=document.createElement("DIV");f.innerHTML=v, v=f.children[0];}return v}, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n=o(12);"string"==typeof n&&(n=[[e.i,n,""]]);var r={insert:"head",singleton:!1};o(5)(n,r);n.locals&&(e.exports=n.locals);},function(e,t,o){(e.exports=o(4)(!1)).push([e.i,'#__vconsole {\n  color: #000;\n  font-size: 13px;\n  font-family: Helvetica Neue, Helvetica, Arial, sans-serif;\n  /* global */\n  /* compoment */\n}\n#__vconsole .vc-max-height {\n  max-height: 19.23076923em;\n}\n#__vconsole .vc-max-height-line {\n  max-height: 3.38461538em;\n}\n#__vconsole .vc-min-height {\n  min-height: 3.07692308em;\n}\n#__vconsole dd,\n#__vconsole dl,\n#__vconsole pre {\n  margin: 0;\n}\n#__vconsole .vc-switch {\n  display: block;\n  position: fixed;\n  right: 0.76923077em;\n  bottom: 0.76923077em;\n  color: #FFF;\n  background-color: #04BE02;\n  line-height: 1;\n  font-size: 1.07692308em;\n  padding: 0.61538462em 1.23076923em;\n  z-index: 10000;\n  border-radius: 0.30769231em;\n  box-shadow: 0 0 0.61538462em rgba(0, 0, 0, 0.4);\n}\n#__vconsole .vc-mask {\n  display: none;\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background: rgba(0, 0, 0, 0);\n  z-index: 10001;\n  transition: background 0.3s;\n  -webkit-tap-highlight-color: transparent;\n  overflow-y: scroll;\n}\n#__vconsole .vc-panel {\n  display: none;\n  position: fixed;\n  min-height: 85%;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10002;\n  background-color: #EFEFF4;\n  -webkit-transition: -webkit-transform 0.3s;\n  transition: -webkit-transform 0.3s;\n  transition: transform 0.3s;\n  transition: transform 0.3s, -webkit-transform 0.3s;\n  -webkit-transform: translate(0, 100%);\n  transform: translate(0, 100%);\n}\n#__vconsole .vc-tabbar {\n  border-bottom: 1px solid #D9D9D9;\n  overflow-x: auto;\n  height: 3em;\n  width: auto;\n  white-space: nowrap;\n}\n#__vconsole .vc-tabbar .vc-tab {\n  display: inline-block;\n  line-height: 3em;\n  padding: 0 1.15384615em;\n  border-right: 1px solid #D9D9D9;\n  text-decoration: none;\n  color: #000;\n  -webkit-tap-highlight-color: transparent;\n  -webkit-touch-callout: none;\n}\n#__vconsole .vc-tabbar .vc-tab:active {\n  background-color: rgba(0, 0, 0, 0.15);\n}\n#__vconsole .vc-tabbar .vc-tab.vc-actived {\n  background-color: #FFF;\n}\n#__vconsole .vc-content {\n  background-color: #FFF;\n  overflow-x: hidden;\n  overflow-y: auto;\n  position: absolute;\n  top: 3.07692308em;\n  left: 0;\n  right: 0;\n  bottom: 3.07692308em;\n  -webkit-overflow-scrolling: touch;\n  margin-bottom: constant(safe-area-inset-bottom);\n  margin-bottom: env(safe-area-inset-bottom);\n}\n#__vconsole .vc-content.vc-has-topbar {\n  top: 5.46153846em;\n}\n#__vconsole .vc-topbar {\n  background-color: #FBF9FE;\n  display: flex;\n  display: -webkit-box;\n  flex-direction: row;\n  flex-wrap: wrap;\n  -webkit-box-direction: row;\n  -webkit-flex-wrap: wrap;\n  width: 100%;\n}\n#__vconsole .vc-topbar .vc-toptab {\n  display: none;\n  flex: 1;\n  -webkit-box-flex: 1;\n  line-height: 2.30769231em;\n  padding: 0 1.15384615em;\n  border-bottom: 1px solid #D9D9D9;\n  text-decoration: none;\n  text-align: center;\n  color: #000;\n  -webkit-tap-highlight-color: transparent;\n  -webkit-touch-callout: none;\n}\n#__vconsole .vc-topbar .vc-toptab.vc-toggle {\n  display: block;\n}\n#__vconsole .vc-topbar .vc-toptab:active {\n  background-color: rgba(0, 0, 0, 0.15);\n}\n#__vconsole .vc-topbar .vc-toptab.vc-actived {\n  border-bottom: 1px solid #3e82f7;\n}\n#__vconsole .vc-logbox {\n  display: none;\n  position: relative;\n  min-height: 100%;\n}\n#__vconsole .vc-logbox i {\n  font-style: normal;\n}\n#__vconsole .vc-logbox .vc-log {\n  padding-bottom: 3em;\n  -webkit-tap-highlight-color: transparent;\n}\n#__vconsole .vc-logbox .vc-log:empty:before {\n  content: "Empty";\n  color: #999;\n  position: absolute;\n  top: 45%;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  font-size: 1.15384615em;\n  text-align: center;\n}\n#__vconsole .vc-logbox .vc-item {\n  margin: 0;\n  padding: 0.46153846em 0.61538462em;\n  overflow: hidden;\n  line-height: 1.3;\n  border-bottom: 1px solid #EEE;\n  word-break: break-word;\n}\n#__vconsole .vc-logbox .vc-item-info {\n  color: #6A5ACD;\n}\n#__vconsole .vc-logbox .vc-item-debug {\n  color: #DAA520;\n}\n#__vconsole .vc-logbox .vc-item-warn {\n  color: #FFA500;\n  border-color: #FFB930;\n  background-color: #FFFACD;\n}\n#__vconsole .vc-logbox .vc-item-error {\n  color: #DC143C;\n  border-color: #F4A0AB;\n  background-color: #FFE4E1;\n}\n#__vconsole .vc-logbox .vc-log.vc-log-partly .vc-item {\n  display: none;\n}\n#__vconsole .vc-logbox .vc-log.vc-log-partly-log .vc-item-log,\n#__vconsole .vc-logbox .vc-log.vc-log-partly-info .vc-item-info,\n#__vconsole .vc-logbox .vc-log.vc-log-partly-warn .vc-item-warn,\n#__vconsole .vc-logbox .vc-log.vc-log-partly-error .vc-item-error {\n  display: block;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-content {\n  margin-right: 4.61538462em;\n  display: inline-block;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-repeat {\n  display: inline-block;\n  margin-right: 0.30769231em;\n  padding: 0 6.5px;\n  color: #D7E0EF;\n  background-color: #42597F;\n  border-radius: 8.66666667px;\n}\n#__vconsole .vc-logbox .vc-item.vc-item-error .vc-item-repeat {\n  color: #901818;\n  background-color: #DC2727;\n}\n#__vconsole .vc-logbox .vc-item.vc-item-warn .vc-item-repeat {\n  color: #987D20;\n  background-color: #F4BD02;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-code {\n  display: block;\n  white-space: pre-wrap;\n  overflow: auto;\n  position: relative;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-code.vc-item-code-input,\n#__vconsole .vc-logbox .vc-item .vc-item-code.vc-item-code-output {\n  padding-left: 0.92307692em;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-code.vc-item-code-input:before,\n#__vconsole .vc-logbox .vc-item .vc-item-code.vc-item-code-output:before {\n  content: "›";\n  position: absolute;\n  top: -0.23076923em;\n  left: 0;\n  font-size: 1.23076923em;\n  color: #6A5ACD;\n}\n#__vconsole .vc-logbox .vc-item .vc-item-code.vc-item-code-output:before {\n  content: "‹";\n}\n#__vconsole .vc-logbox .vc-item .vc-fold {\n  display: block;\n  overflow: auto;\n  -webkit-overflow-scrolling: touch;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-outer {\n  display: block;\n  font-style: italic;\n  padding-left: 0.76923077em;\n  position: relative;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-outer:active {\n  background-color: #E6E6E6;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-outer:before {\n  content: "";\n  position: absolute;\n  top: 0.30769231em;\n  left: 0.15384615em;\n  width: 0;\n  height: 0;\n  border: transparent solid 0.30769231em;\n  border-left-color: #000;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-outer.vc-toggle:before {\n  top: 0.46153846em;\n  left: 0;\n  border-top-color: #000;\n  border-left-color: transparent;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-inner {\n  display: none;\n  margin-left: 0.76923077em;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-inner.vc-toggle {\n  display: block;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-inner .vc-code-key {\n  margin-left: 0.76923077em;\n}\n#__vconsole .vc-logbox .vc-item .vc-fold .vc-fold-outer .vc-code-key {\n  margin-left: 0;\n}\n#__vconsole .vc-logbox .vc-code-key {\n  color: #905;\n}\n#__vconsole .vc-logbox .vc-code-private-key {\n  color: #D391B5;\n}\n#__vconsole .vc-logbox .vc-code-function {\n  color: #905;\n  font-style: italic;\n}\n#__vconsole .vc-logbox .vc-code-number,\n#__vconsole .vc-logbox .vc-code-boolean {\n  color: #0086B3;\n}\n#__vconsole .vc-logbox .vc-code-string {\n  color: #183691;\n}\n#__vconsole .vc-logbox .vc-code-null,\n#__vconsole .vc-logbox .vc-code-undefined {\n  color: #666;\n}\n#__vconsole .vc-logbox .vc-cmd {\n  position: absolute;\n  height: 3.07692308em;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border-top: 1px solid #D9D9D9;\n  display: block!important;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-input-wrap {\n  display: block;\n  height: 2.15384615em;\n  margin-right: 3.07692308em;\n  padding: 0.46153846em 0.61538462em;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-input {\n  width: 100%;\n  border: none;\n  resize: none;\n  outline: none;\n  padding: 0;\n  font-size: 0.92307692em;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-input::-webkit-input-placeholder {\n  line-height: 2.15384615em;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-btn {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  width: 3.07692308em;\n  border: none;\n  background-color: #EFEFF4;\n  outline: none;\n  -webkit-touch-callout: none;\n  font-size: 1em;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-btn:active {\n  background-color: rgba(0, 0, 0, 0.15);\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-prompted {\n  position: fixed;\n  width: 100%;\n  background-color: #FBF9FE;\n  border: 1px solid #D9D9D9;\n  overflow-x: scroll;\n  display: none;\n}\n#__vconsole .vc-logbox .vc-cmd .vc-cmd-prompted li {\n  list-style: none;\n  line-height: 30px;\n  padding: 0 0.46153846em;\n  border-bottom: 1px solid #D9D9D9;\n}\n#__vconsole .vc-logbox .vc-group .vc-group-preview {\n  -webkit-touch-callout: none;\n}\n#__vconsole .vc-logbox .vc-group .vc-group-preview:active {\n  background-color: #E6E6E6;\n}\n#__vconsole .vc-logbox .vc-group .vc-group-detail {\n  display: none;\n  padding: 0 0 0.76923077em 1.53846154em;\n  border-bottom: 1px solid #EEE;\n}\n#__vconsole .vc-logbox .vc-group.vc-actived .vc-group-detail {\n  display: block;\n  background-color: #FBF9FE;\n}\n#__vconsole .vc-logbox .vc-group.vc-actived .vc-table-row {\n  background-color: #FFF;\n}\n#__vconsole .vc-logbox .vc-group.vc-actived .vc-group-preview {\n  background-color: #FBF9FE;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-row {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  flex-wrap: wrap;\n  -webkit-box-direction: row;\n  -webkit-flex-wrap: wrap;\n  overflow: hidden;\n  border-bottom: 1px solid #EEE;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-row.vc-left-border {\n  border-left: 1px solid #EEE;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col {\n  flex: 1;\n  -webkit-box-flex: 1;\n  padding: 0.23076923em 0.30769231em;\n  border-left: 1px solid #EEE;\n  overflow: auto;\n  white-space: pre-wrap;\n  word-break: break-word;\n  /*white-space: nowrap;\n        text-overflow: ellipsis;*/\n  -webkit-overflow-scrolling: touch;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col:first-child {\n  border: none;\n}\n#__vconsole .vc-logbox .vc-table .vc-small .vc-table-col {\n  padding: 0 0.30769231em;\n  font-size: 0.92307692em;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-2 {\n  flex: 2;\n  -webkit-box-flex: 2;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-3 {\n  flex: 3;\n  -webkit-box-flex: 3;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-4 {\n  flex: 4;\n  -webkit-box-flex: 4;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-5 {\n  flex: 5;\n  -webkit-box-flex: 5;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-6 {\n  flex: 6;\n  -webkit-box-flex: 6;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-row-error {\n  border-color: #F4A0AB;\n  background-color: #FFE4E1;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-row-error .vc-table-col {\n  color: #DC143C;\n  border-color: #F4A0AB;\n}\n#__vconsole .vc-logbox .vc-table .vc-table-col-title {\n  font-weight: bold;\n}\n#__vconsole .vc-logbox.vc-actived {\n  display: block;\n}\n#__vconsole .vc-toolbar {\n  border-top: 1px solid #D9D9D9;\n  line-height: 3em;\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  display: -webkit-box;\n  flex-direction: row;\n  -webkit-box-direction: row;\n}\n#__vconsole .vc-toolbar .vc-tool {\n  display: none;\n  text-decoration: none;\n  color: #000;\n  width: 50%;\n  flex: 1;\n  -webkit-box-flex: 1;\n  text-align: center;\n  position: relative;\n  -webkit-touch-callout: none;\n}\n#__vconsole .vc-toolbar .vc-tool.vc-toggle,\n#__vconsole .vc-toolbar .vc-tool.vc-global-tool {\n  display: block;\n}\n#__vconsole .vc-toolbar .vc-tool:active {\n  background-color: rgba(0, 0, 0, 0.15);\n}\n#__vconsole .vc-toolbar .vc-tool:after {\n  content: " ";\n  position: absolute;\n  top: 0.53846154em;\n  bottom: 0.53846154em;\n  right: 0;\n  border-left: 1px solid #D9D9D9;\n}\n#__vconsole .vc-toolbar .vc-tool-last:after {\n  border: none;\n}\n@supports (bottom: constant(safe-area-inset-bottom)) or (bottom: env(safe-area-inset-bottom)) {\n  #__vconsole .vc-toolbar,\n  #__vconsole .vc-switch {\n    bottom: constant(safe-area-inset-bottom);\n    bottom: env(safe-area-inset-bottom);\n  }\n}\n#__vconsole.vc-toggle .vc-switch {\n  display: none;\n}\n#__vconsole.vc-toggle .vc-mask {\n  background: rgba(0, 0, 0, 0.6);\n  display: block;\n}\n#__vconsole.vc-toggle .vc-panel {\n  -webkit-transform: translate(0, 0);\n  transform: translate(0, 0);\n}\n',""]);},function(e,t){e.exports='<div id="__vconsole" class="">\n  <div class="vc-switch">vConsole</div>\n  <div class="vc-mask">\n  </div>\n  <div class="vc-panel">\n    <div class="vc-tabbar">\n    </div>\n    <div class="vc-topbar">\n    </div>\n    <div class="vc-content">\n    </div>\n    <div class="vc-toolbar">\n      <a class="vc-tool vc-global-tool vc-tool-last vc-hide">Hide</a>\n    </div>\n  </div>\n</div>';},function(e,t){e.exports='<a class="vc-tab" data-tab="{{id}}" id="__vc_tab_{{id}}">{{name}}</a>';},function(e,t){e.exports='<div class="vc-logbox" id="__vc_log_{{id}}">\n  \n</div>';},function(e,t){e.exports='<a class="vc-toptab vc-topbar-{{pluginID}}{{if (className)}} {{className}}{{/if}}">{{name}}</a>';},function(e,t){e.exports='<a class="vc-tool vc-tool-{{pluginID}}">{{name}}</a>';},function(e,t){e.exports='<div id="{{_id}}" class="vc-item vc-item-{{logType}} {{style}}">\n\t<div class="vc-item-content"></div>\n</div>';},function(e,t){e.exports='<div class="vc-fold">\n  {{if (lineType == \'obj\')}}\n    <i class="vc-fold-outer">{{outer}}</i>\n    <div class="vc-fold-inner"></div>\n  {{else if (lineType == \'value\')}}\n    <i class="vc-code-{{valueType}}">{{value}}</i>\n  {{else if (lineType == \'kv\')}}\n    <i class="vc-code-key{{if (keyType)}} vc-code-{{keyType}}-key{{/if}}">{{key}}</i>: <i class="vc-code-{{valueType}}">{{value}}</i>\n  {{/if}}\n</div>';},function(e,t){e.exports='<span>\n  <i class="vc-code-key{{if (keyType)}} vc-code-{{keyType}}-key{{/if}}">{{key}}</i>: <i class="vc-code-{{valueType}}">{{value}}</i>\n</span>';},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_FACTORY__,__WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__,factory;factory=function(_exports,_query,tool,_log,_tabbox_default,_item_code){function _interopRequireWildcard(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function _defineProperties(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function _createClass(e,t,o){return t&&_defineProperties(e.prototype,t), o&&_defineProperties(e,o), e}function _possibleConstructorReturn(e,t){return!t||"object"!==_typeof(t)&&"function"!=typeof t?_assertThisInitialized(e):t}function _assertThisInitialized(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function _get(e,t,o){return(_get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,o){var n=_superPropBase(e,t);if(n){var r=Object.getOwnPropertyDescriptor(n,t);return r.get?r.get.call(o):r.value}})(e,t,o||e)}function _superPropBase(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&null!==(e=_getPrototypeOf(e)););return e}function _getPrototypeOf(e){return(_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function _inherits(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&_setPrototypeOf(e,t);}function _setPrototypeOf(e,t){return(_setPrototypeOf=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(_exports,"__esModule",{value:!0}), _exports.default=void 0, _query=_interopRequireDefault(_query), tool=_interopRequireWildcard(tool), _log=_interopRequireDefault(_log), _tabbox_default=_interopRequireDefault(_tabbox_default), _item_code=_interopRequireDefault(_item_code);var VConsoleDefaultTab=function(_VConsoleLogTab){function VConsoleDefaultTab(){var e,t;_classCallCheck(this,VConsoleDefaultTab);for(var o=arguments.length,n=new Array(o),r=0;r<o;r++)n[r]=arguments[r];return(t=_possibleConstructorReturn(this,(e=_getPrototypeOf(VConsoleDefaultTab)).call.apply(e,[this].concat(n)))).tplTabbox=_tabbox_default.default, t}return _inherits(VConsoleDefaultTab,_VConsoleLogTab), _createClass(VConsoleDefaultTab,[{key:"onReady",value:function onReady(){var that=this;_get(_getPrototypeOf(VConsoleDefaultTab.prototype),"onReady",this).call(this), window.winKeys=Object.getOwnPropertyNames(window).sort(), window.keyTypes={};for(var i=0;i<winKeys.length;i++)keyTypes[winKeys[i]]=_typeof(window[winKeys[i]]);var cacheObj={},ID_REGEX=/[a-zA-Z_0-9\$\-\u00A2-\uFFFF]/,retrievePrecedingIdentifier=function(e,t,o){o=o||ID_REGEX;for(var n=[],r=t-1;r>=0&&o.test(e[r]);r--)n.push(e[r]);if(0==n.length){o=/\./;for(var i=t-1;i>=0&&o.test(e[i]);i--)n.push(e[i]);}if(0===n.length){var a=e.match(/[\(\)\[\]\{\}]/gi)||[];return a[a.length-1]}return n.reverse().join("")};_query.default.bind(_query.default.one(".vc-cmd-input"),"keyup",function(e){var isDeleteKeyCode=8===e.keyCode||46===e.keyCode,$prompted=_query.default.one(".vc-cmd-prompted");$prompted.style.display="none", $prompted.innerHTML="";var tempValue=this.value,value=retrievePrecedingIdentifier(this.value,this.value.length);if(value&&value.length>0){if(/\(/.test(value)&&!isDeleteKeyCode)return void(_query.default.one(".vc-cmd-input").value+=")");if(/\[/.test(value)&&!isDeleteKeyCode)return void(_query.default.one(".vc-cmd-input").value+="]");if(/\{/.test(value)&&!isDeleteKeyCode)return void(_query.default.one(".vc-cmd-input").value+="}");if("."===value){var key=retrievePrecedingIdentifier(tempValue,tempValue.length-1);if(!cacheObj[key])try{cacheObj[key]=Object.getOwnPropertyNames(eval("("+key+")")).sort();}catch(e){}try{for(var _i3=0;_i3<cacheObj[key].length;_i3++){var $li=document.createElement("li"),_key=cacheObj[key][_i3];$li.innerHTML=_key, $li.onclick=function(){_query.default.one(".vc-cmd-input").value="", _query.default.one(".vc-cmd-input").value=tempValue+this.innerHTML, $prompted.style.display="none";}, $prompted.appendChild($li);}}catch(e){}}else if("."!==value.substring(value.length-1)&&value.indexOf(".")<0){for(var _i4=0;_i4<winKeys.length;_i4++)if(winKeys[_i4].toLowerCase().indexOf(value.toLowerCase())>=0){var _$li=document.createElement("li");_$li.innerHTML=winKeys[_i4], _$li.onclick=function(){_query.default.one(".vc-cmd-input").value="", _query.default.one(".vc-cmd-input").value=this.innerHTML, "function"==keyTypes[this.innerHTML]&&(_query.default.one(".vc-cmd-input").value+="()"), $prompted.style.display="none";}, $prompted.appendChild(_$li);}}else{var arr=value.split(".");if(cacheObj[arr[0]]){cacheObj[arr[0]].sort();for(var _i5=0;_i5<cacheObj[arr[0]].length;_i5++){var _$li2=document.createElement("li"),_key3=cacheObj[arr[0]][_i5];_key3.indexOf(arr[1])>=0&&(_$li2.innerHTML=_key3, _$li2.onclick=function(){_query.default.one(".vc-cmd-input").value="", _query.default.one(".vc-cmd-input").value=tempValue+this.innerHTML, $prompted.style.display="none";}, $prompted.appendChild(_$li2));}}}if($prompted.children.length>0){var m=Math.min(200,31*$prompted.children.length);$prompted.style.display="block", $prompted.style.height=m+"px", $prompted.style.marginTop=-m+"px";}}else $prompted.style.display="none";}), _query.default.bind(_query.default.one(".vc-cmd",this.$tabbox),"submit",function(e){e.preventDefault();var t=_query.default.one(".vc-cmd-input",e.target),o=t.value;t.value="", ""!==o&&that.evalCommand(o);var n=_query.default.one(".vc-cmd-prompted");n&&(n.style.display="none");});var code="";code+="if (!!window) {", code+="window.__vConsole_cmd_result = undefined;", code+="window.__vConsole_cmd_error = false;", code+="}";var scriptList=document.getElementsByTagName("script"),nonce="";scriptList.length>0&&(nonce=scriptList[0].nonce||"");var script=document.createElement("SCRIPT");script.innerHTML=code, script.setAttribute("nonce",nonce), document.documentElement.appendChild(script), document.documentElement.removeChild(script);}},{key:"mockConsole",value:function(){_get(_getPrototypeOf(VConsoleDefaultTab.prototype),"mockConsole",this).call(this);var e=this;tool.isFunction(window.onerror)&&(this.windowOnError=window.onerror), window.onerror=function(t,o,n,r,i){var a=t;o&&(a+="\n"+o.replace(location.origin,"")), (n||r)&&(a+=":"+n+":"+r);var l=!!i&&!!i.stack&&i.stack.toString()||"";e.printLog({logType:"error",logs:[a,l],noOrigin:!0}), tool.isFunction(e.windowOnError)&&e.windowOnError.call(window,t,o,n,r,i);};}},{key:"evalCommand",value:function(e){this.printLog({logType:"log",content:_query.default.render(_item_code.default,{content:e,type:"input"}),style:""});var t,o=void 0;try{o=eval.call(window,"("+e+")");}catch(t){try{o=eval.call(window,e);}catch(e){}}tool.isArray(o)||tool.isObject(o)?t=this.getFoldedLine(o):(tool.isNull(o)?o="null":tool.isUndefined(o)?o="undefined":tool.isFunction(o)?o="function()":tool.isString(o)&&(o='"'+o+'"'), t=_query.default.render(_item_code.default,{content:o,type:"output"})), this.printLog({logType:"log",content:t,style:""}), window.winKeys=Object.getOwnPropertyNames(window).sort();}}]), VConsoleDefaultTab}(_log.default),_default=VConsoleDefaultTab;_exports.default=_default, module.exports=exports.default;}, __WEBPACK_AMD_DEFINE_ARRAY__=[exports,__webpack_require__(1),__webpack_require__(0),__webpack_require__(3),__webpack_require__(22),__webpack_require__(23)], void 0===(__WEBPACK_AMD_DEFINE_RESULT__="function"==typeof(__WEBPACK_AMD_DEFINE_FACTORY__=factory)?__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__):__WEBPACK_AMD_DEFINE_FACTORY__)||(module.exports=__WEBPACK_AMD_DEFINE_RESULT__);},function(e,t){e.exports='<div>\n  <div class="vc-log"></div>\n  <form class="vc-cmd">\n    <button class="vc-cmd-btn" type="submit">OK</button>\n    <ul class=\'vc-cmd-prompted\'></ul>\n    <div class="vc-cmd-input-wrap">\n      <textarea class="vc-cmd-input" placeholder="command..."></textarea>\n    </div>\n  </form>\n</div>';},function(e,t){e.exports='<pre class="vc-item-code vc-item-code-{{type}}">{{content}}</pre>';},function(e,t,o){var n,r,i;r=[t,o(3),o(25)], void 0===(i="function"==typeof(n=function(o,n,r){function i(e){return e&&e.__esModule?e:{default:e}}function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function l(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function c(e,t){return!t||"object"!==a(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e):t}function s(e,t,o){return(s="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(e,t,o){var n=function(e,t){for(;!Object.prototype.hasOwnProperty.call(e,t)&&null!==(e=d(e)););return e}(e,t);if(n){var r=Object.getOwnPropertyDescriptor(n,t);return r.get?r.get.call(o):r.value}})(e,t,o||e)}function d(e){return(d=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function u(e,t){return(u=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=i(n), r=i(r);var v=function(e){function t(){var e,o;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);for(var n=arguments.length,i=new Array(n),a=0;a<n;a++)i[a]=arguments[a];return(o=c(this,(e=d(t)).call.apply(e,[this].concat(i)))).tplTabbox=r.default, o.allowUnformattedLog=!1, o}var o,i,a;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&u(e,t);}(t,n.default), o=t, (i=[{key:"onInit",value:function(){s(d(t.prototype),"onInit",this).call(this), this.printSystemInfo();}},{key:"printSystemInfo",value:function(){var e=navigator.userAgent,t="",o=e.match(/(ipod).*\s([\d_]+)/i),n=e.match(/(ipad).*\s([\d_]+)/i),r=e.match(/(iphone)\sos\s([\d_]+)/i),i=e.match(/(android)\s([\d\.]+)/i);t="Unknown", i?t="Android "+i[2]:r?t="iPhone, iOS "+r[2].replace(/_/g,"."):n?t="iPad, iOS "+n[2].replace(/_/g,"."):o&&(t="iPod, iOS "+o[2].replace(/_/g,"."));var a=t,l=e.match(/MicroMessenger\/([\d\.]+)/i);t="Unknown", l&&l[1]?(a+=", WeChat "+(t=l[1]), console.info("[system]","System:",a)):console.info("[system]","System:",a), t="Unknown", a=t="https:"==location.protocol?"HTTPS":"http:"==location.protocol?"HTTP":location.protocol.replace(":","");var c=e.toLowerCase().match(/ nettype\/([^ ]+)/g);t="Unknown", c&&c[0]?(a+=", "+(t=(c=c[0].split("/"))[1]), console.info("[system]","Network:",a)):console.info("[system]","Protocol:",a), console.info("[system]","UA:",e), setTimeout(function(){var e=window.performance||window.msPerformance||window.webkitPerformance;if(e&&e.timing){var t=e.timing;t.navigationStart&&console.info("[system]","navigationStart:",t.navigationStart), t.navigationStart&&t.domainLookupStart&&console.info("[system]","navigation:",t.domainLookupStart-t.navigationStart+"ms"), t.domainLookupEnd&&t.domainLookupStart&&console.info("[system]","dns:",t.domainLookupEnd-t.domainLookupStart+"ms"), t.connectEnd&&t.connectStart&&(t.connectEnd&&t.secureConnectionStart?console.info("[system]","tcp (ssl):",t.connectEnd-t.connectStart+"ms ("+(t.connectEnd-t.secureConnectionStart)+"ms)"):console.info("[system]","tcp:",t.connectEnd-t.connectStart+"ms")), t.responseStart&&t.requestStart&&console.info("[system]","request:",t.responseStart-t.requestStart+"ms"), t.responseEnd&&t.responseStart&&console.info("[system]","response:",t.responseEnd-t.responseStart+"ms"), t.domComplete&&t.domLoading&&(t.domContentLoadedEventStart&&t.domLoading?console.info("[system]","domComplete (domLoaded):",t.domComplete-t.domLoading+"ms ("+(t.domContentLoadedEventStart-t.domLoading)+"ms)"):console.info("[system]","domComplete:",t.domComplete-t.domLoading+"ms")), t.loadEventEnd&&t.loadEventStart&&console.info("[system]","loadEvent:",t.loadEventEnd-t.loadEventStart+"ms"), t.navigationStart&&t.loadEventEnd&&console.info("[system]","total (DOM):",t.loadEventEnd-t.navigationStart+"ms ("+(t.domComplete-t.navigationStart)+"ms)");}},0);}}])&&l(o.prototype,i), a&&l(o,a), t}();o.default=v, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t){e.exports='<div>\n  <div class="vc-log"></div>\n</div>';},function(e,t,o){var n,r,i;r=[t,o(1),o(0),o(2),o(27),o(28),o(29)], void 0===(i="function"==typeof(n=function(o,n,r,i,a,l,c){function s(e){return e&&e.__esModule?e:{default:e}}function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function u(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function v(e,t){return!t||"object"!==d(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e):t}function f(e){return(f=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function p(e,t){return(p=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=s(n), r=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(r), i=s(i), a=s(a), l=s(l), c=s(c);var b=function(e){function t(){var e,o;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);for(var r=arguments.length,i=new Array(r),l=0;l<r;l++)i[l]=arguments[l];return(o=v(this,(e=f(t)).call.apply(e,[this].concat(i)))).$tabbox=n.default.render(a.default,{}), o.$header=null, o.reqList={}, o.domList={}, o.isReady=!1, o.isShow=!1, o.isInBottom=!0, o._open=void 0, o._send=void 0, o.mockAjax(), o}var o,s,d;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&p(e,t);}(t,i.default), o=t, (s=[{key:"onRenderTab",value:function(e){e(this.$tabbox);}},{key:"onAddTool",value:function(e){var t=this;e([{name:"Clear",global:!1,onClick:function(e){t.clearLog();}}]);}},{key:"onReady",value:function(){var e=this;e.isReady=!0, this.renderHeader(), n.default.delegate(n.default.one(".vc-log",this.$tabbox),"click",".vc-group-preview",function(t){var o=this.dataset.reqid,r=this.parentNode;n.default.hasClass(r,"vc-actived")?(n.default.removeClass(r,"vc-actived"), e.updateRequest(o,{actived:!1})):(n.default.addClass(r,"vc-actived"), e.updateRequest(o,{actived:!0})), t.preventDefault();});var t=n.default.one(".vc-content");for(var o in n.default.bind(t,"scroll",function(o){e.isShow&&(t.scrollTop+t.offsetHeight>=t.scrollHeight?e.isInBottom=!0:e.isInBottom=!1);}), e.reqList)e.updateRequest(o,{});}},{key:"onRemove",value:function(){window.XMLHttpRequest&&(window.XMLHttpRequest.prototype.open=this._open, window.XMLHttpRequest.prototype.send=this._send, this._open=void 0, this._send=void 0);}},{key:"onShow",value:function(){this.isShow=!0, 1==this.isInBottom&&this.scrollToBottom();}},{key:"onHide",value:function(){this.isShow=!1;}},{key:"onShowConsole",value:function(){1==this.isInBottom&&this.scrollToBottom();}},{key:"scrollToBottom",value:function(){var e=n.default.one(".vc-content");e.scrollTop=e.scrollHeight-e.offsetHeight;}},{key:"clearLog",value:function(){for(var e in this.reqList={}, this.domList)this.domList[e].parentNode.removeChild(this.domList[e]), this.domList[e]=void 0;this.domList={}, this.renderHeader();}},{key:"renderHeader",value:function(){var e=Object.keys(this.reqList).length,t=n.default.render(l.default,{count:e}),o=n.default.one(".vc-log",this.$tabbox);this.$header?this.$header.parentNode.replaceChild(t,this.$header):o.parentNode.insertBefore(t,o), this.$header=t;}},{key:"updateRequest",value:function(e,t){var o=Object.keys(this.reqList).length,i=this.reqList[e]||{};for(var a in t)i[a]=t[a];if(this.reqList[e]=i, this.isReady){var l={id:e,url:i.url,status:i.status,method:i.method||"-",costTime:i.costTime>0?i.costTime+"ms":"-",header:i.header||null,getData:i.getData||null,postData:i.postData||null,response:null,actived:!!i.actived};switch(i.responseType){case"":case"text":if(r.isString(i.response))try{l.response=JSON.parse(i.response), l.response=JSON.stringify(l.response,null,1), l.response=r.htmlEncode(l.response);}catch(e){l.response=r.htmlEncode(i.response);}else void 0!==i.response&&(l.response=Object.prototype.toString.call(i.response));break;case"json":void 0!==i.response&&(l.response=JSON.stringify(i.response,null,1), l.response=r.htmlEncode(l.response));break;case"blob":case"document":case"arraybuffer":default:void 0!==i.response&&(l.response=Object.prototype.toString.call(i.response));}0==i.readyState||1==i.readyState?l.status="Pending":2==i.readyState||3==i.readyState?l.status="Loading":4==i.readyState||(l.status="Unknown");var s=n.default.render(c.default,l),d=this.domList[e];i.status>=400&&n.default.addClass(n.default.one(".vc-group-preview",s),"vc-table-row-error"), d?d.parentNode.replaceChild(s,d):n.default.one(".vc-log",this.$tabbox).insertAdjacentElement("beforeend",s), this.domList[e]=s, Object.keys(this.reqList).length!=o&&this.renderHeader(), this.isInBottom&&this.scrollToBottom();}}},{key:"mockAjax",value:function(){if(window.XMLHttpRequest){var e=this,t=window.XMLHttpRequest.prototype.open,o=window.XMLHttpRequest.prototype.send;e._open=t, e._send=o, window.XMLHttpRequest.prototype.open=function(){var o=this,n=[].slice.call(arguments),r=n[0],i=n[1],a=e.getUniqueID(),l=null;o._requestID=a, o._method=r, o._url=i;var c=o.onreadystatechange||function(){},s=function(){var t=e.reqList[a]||{};if(t.readyState=o.readyState, t.status=0, o.readyState>1&&(t.status=o.status), t.responseType=o.responseType, 0==o.readyState)t.startTime||(t.startTime=+new Date);else if(1==o.readyState)t.startTime||(t.startTime=+new Date);else if(2==o.readyState){t.header={};for(var n=o.getAllResponseHeaders()||"",r=n.split("\n"),i=0;i<r.length;i++){var s=r[i];if(s){var d=s.split(": "),u=d[0],v=d.slice(1).join(": ");t.header[u]=v;}}}else 3==o.readyState||(4==o.readyState?(clearInterval(l), t.endTime=+new Date, t.costTime=t.endTime-(t.startTime||t.endTime), t.response=o.response):clearInterval(l));return o._noVConsole||e.updateRequest(a,t), c.apply(o,arguments)};o.onreadystatechange=s;var d=-1;return l=setInterval(function(){d!=o.readyState&&(d=o.readyState, s.call(o));},10), t.apply(o,n)}, window.XMLHttpRequest.prototype.send=function(){var t=this,n=[].slice.call(arguments),i=n[0],a=e.reqList[t._requestID]||{};a.method=t._method.toUpperCase();var l=t._url.split("?");if(a.url=l.shift(), l.length>0){a.getData={}, l=(l=l.join("?")).split("&");var c=!0,s=!1,d=void 0;try{for(var u,v=l[Symbol.iterator]();!(c=(u=v.next()).done);c=!0){var f=u.value;f=f.split("="), a.getData[f[0]]=decodeURIComponent(f[1]);}}catch(e){s=!0, d=e;}finally{try{c||null==v.return||v.return();}finally{if(s)throw d}}}if("POST"==a.method)if(r.isString(i)){var p=i.split("&");a.postData={};var b=!0,g=!1,h=void 0;try{for(var m,y=p[Symbol.iterator]();!(b=(m=y.next()).done);b=!0){var _=m.value;_=_.split("="), a.postData[_[0]]=_[1];}}catch(e){g=!0, h=e;}finally{try{b||null==y.return||y.return();}finally{if(g)throw h}}}else r.isPlainObject(i)&&(a.postData=i);return t._noVConsole||e.updateRequest(t._requestID,a), o.apply(t,n)};}}},{key:"getUniqueID",value:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)})}}])&&u(o.prototype,s), d&&u(o,d), t}();o.default=b, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t){e.exports='<div class="vc-table">\n  <div class="vc-log"></div>\n</div>';},function(e,t){e.exports='<dl class="vc-table-row">\n  <dd class="vc-table-col vc-table-col-4">Name {{if (count > 0)}}({{count}}){{/if}}</dd>\n  <dd class="vc-table-col">Method</dd>\n  <dd class="vc-table-col">Status</dd>\n  <dd class="vc-table-col">Time</dd>\n</dl>';},function(e,t){e.exports='<div class="vc-group {{actived ? \'vc-actived\' : \'\'}}">\n  <dl class="vc-table-row vc-group-preview" data-reqid="{{id}}">\n    <dd class="vc-table-col vc-table-col-4">{{url}}</dd>\n    <dd class="vc-table-col">{{method}}</dd>\n    <dd class="vc-table-col">{{status}}</dd>\n    <dd class="vc-table-col">{{costTime}}</dd>\n  </dl>\n  <div class="vc-group-detail">\n    {{if (header !== null)}}\n    <div>\n      <dl class="vc-table-row vc-left-border">\n        <dt class="vc-table-col vc-table-col-title">Headers</dt>\n      </dl>\n      {{for (var key in header)}}\n      <div class="vc-table-row vc-left-border vc-small">\n        <div class="vc-table-col vc-table-col-2">{{key}}</div>\n        <div class="vc-table-col vc-table-col-4 vc-max-height-line">{{header[key]}}</div>\n      </div>\n      {{/for}}\n    </div>\n    {{/if}}\n    {{if (getData !== null)}}\n    <div>\n      <dl class="vc-table-row vc-left-border">\n        <dt class="vc-table-col vc-table-col-title">Query String Parameters</dt>\n      </dl>\n      {{for (var key in getData)}}\n      <div class="vc-table-row vc-left-border vc-small">\n        <div class="vc-table-col vc-table-col-2">{{key}}</div>\n        <div class="vc-table-col vc-table-col-4 vc-max-height-line">{{getData[key]}}</div>\n      </div>\n      {{/for}}\n    </div>\n    {{/if}}\n    {{if (postData !== null)}}\n    <div>\n      <dl class="vc-table-row vc-left-border">\n        <dt class="vc-table-col vc-table-col-title">Form Data</dt>\n      </dl>\n      {{for (var key in postData)}}\n      <div class="vc-table-row vc-left-border vc-small">\n        <div class="vc-table-col vc-table-col-2">{{key}}</div>\n        <div class="vc-table-col vc-table-col-4 vc-max-height-line">{{postData[key]}}</div>\n      </div>\n      {{/for}}\n    </div>\n    {{/if}}\n    <div>\n      <dl class="vc-table-row vc-left-border">\n        <dt class="vc-table-col vc-table-col-title">Response</dt>\n      </dl>\n      <div class="vc-table-row vc-left-border vc-small">\n        <pre class="vc-table-col vc-max-height vc-min-height">{{response || \'\'}}</pre>\n      </div>\n    </div>\n  </div>\n</div>';},function(e,t,o){var n,r,i;r=[t,o(31),o(2),o(33),o(34),o(0),o(1)], void 0===(i="function"==typeof(n=function(o,n,r,i,a,l,c){function s(e){return e&&e.__esModule?e:{default:e}}function d(e){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function u(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function v(e){return(v=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function f(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}function p(e,t){return(p=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, r=s(r), i=s(i), a=s(a), l=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(l), c=s(c);var b=function(e){function t(){var e,o,n,r;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);for(var a=arguments.length,l=new Array(a),s=0;s<a;s++)l[s]=arguments[s];n=this, o=!(r=(e=v(t)).call.apply(e,[this].concat(l)))||"object"!==d(r)&&"function"!=typeof r?f(n):r;var u=f(o);u.isInited=!1, u.node={}, u.$tabbox=c.default.render(i.default,{}), u.nodes=[], u.activedElem={};var p=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;return u.observer=new p(function(e){for(var t=0;t<e.length;t++){var o=e[t];u._isInVConsole(o.target)||u.onMutation(o);}}), o}var o,n,l;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&p(e,t);}(t,r.default), o=t, (n=[{key:"onRenderTab",value:function(e){e(this.$tabbox);}},{key:"onAddTool",value:function(e){var t=this;e([{name:"Expand",global:!1,onClick:function(e){if(t.activedElem)if(c.default.hasClass(t.activedElem,"vc-toggle"))for(var o=0;o<t.activedElem.childNodes.length;o++){var n=t.activedElem.childNodes[o];if(c.default.hasClass(n,"vcelm-l")&&!c.default.hasClass(n,"vcelm-noc")&&!c.default.hasClass(n,"vc-toggle")){c.default.one(".vcelm-node",n).click();break}}else c.default.one(".vcelm-node",t.activedElem).click();}},{name:"Collapse",global:!1,onClick:function(e){t.activedElem&&(c.default.hasClass(t.activedElem,"vc-toggle")?c.default.one(".vcelm-node",t.activedElem).click():t.activedElem.parentNode&&c.default.hasClass(t.activedElem.parentNode,"vcelm-l")&&c.default.one(".vcelm-node",t.activedElem.parentNode).click());}}]);}},{key:"onShow",value:function(){if(!this.isInited){this.isInited=!0, this.node=this.getNode(document.documentElement);var e=this.renderView(this.node,c.default.one(".vc-log",this.$tabbox)),t=c.default.one(".vcelm-node",e);t&&t.click(), this.observer.observe(document.documentElement,{attributes:!0,childList:!0,characterData:!0,subtree:!0});}}},{key:"onRemove",value:function(){this.observer.disconnect();}},{key:"onMutation",value:function(e){switch(e.type){case"childList":e.removedNodes.length>0&&this.onChildRemove(e), e.addedNodes.length>0&&this.onChildAdd(e);break;case"attributes":this.onAttributesChange(e);break;case"characterData":this.onCharacterDataChange(e);}}},{key:"onChildRemove",value:function(e){var t=e.target;if(t.__vconsole_node){for(var o=0;o<e.removedNodes.length;o++){var n=e.removedNodes[o].__vconsole_node;n&&n.view&&n.view.parentNode.removeChild(n.view);}this.getNode(t);}}},{key:"onChildAdd",value:function(e){var t=e.target,o=t.__vconsole_node;if(o){this.getNode(t), o.view&&c.default.removeClass(o.view,"vcelm-noc");for(var n=0;n<e.addedNodes.length;n++){var r=e.addedNodes[n].__vconsole_node;if(r)if(null!==e.nextSibling){var i=e.nextSibling.__vconsole_node;i.view&&this.renderView(r,i.view,"insertBefore");}else o.view&&(o.view.lastChild?this.renderView(r,o.view.lastChild,"insertBefore"):this.renderView(r,o.view));}}}},{key:"onAttributesChange",value:function(e){var t=e.target.__vconsole_node;t&&(t=this.getNode(e.target)).view&&this.renderView(t,t.view,!0);}},{key:"onCharacterDataChange",value:function(e){var t=e.target.__vconsole_node;t&&(t=this.getNode(e.target)).view&&this.renderView(t,t.view,!0);}},{key:"renderView",value:function(e,t,o){var n=this,r=new a.default(e).get();switch(e.view=r, c.default.delegate(r,"click",".vcelm-node",function(t){t.stopPropagation();var o=this.parentNode;if(!c.default.hasClass(o,"vcelm-noc")){n.activedElem=o, c.default.hasClass(o,"vc-toggle")?c.default.removeClass(o,"vc-toggle"):c.default.addClass(o,"vc-toggle");for(var r=-1,i=0;i<o.children.length;i++){var a=o.children[i];c.default.hasClass(a,"vcelm-l")&&(r++, a.children.length>0||(e.childNodes[r]?n.renderView(e.childNodes[r],a,"replace"):a.style.display="none"));}}}), o){case"replace":t.parentNode.replaceChild(r,t);break;case"insertBefore":t.parentNode.insertBefore(r,t);break;default:t.appendChild(r);}return r}},{key:"getNode",value:function(e){if(!this._isIgnoredElement(e)){var t=e.__vconsole_node||{};if(t.nodeType=e.nodeType, t.nodeName=e.nodeName, t.tagName=e.tagName||"", t.textContent="", t.nodeType!=e.TEXT_NODE&&t.nodeType!=e.DOCUMENT_TYPE_NODE||(t.textContent=e.textContent), t.id=e.id||"", t.className=e.className||"", t.attributes=[], e.hasAttributes&&e.hasAttributes())for(var o=0;o<e.attributes.length;o++)t.attributes.push({name:e.attributes[o].name,value:e.attributes[o].value||""});if(t.childNodes=[], e.childNodes.length>0)for(var n=0;n<e.childNodes.length;n++){var r=this.getNode(e.childNodes[n]);r&&t.childNodes.push(r);}return e.__vconsole_node=t, t}}},{key:"_isIgnoredElement",value:function(e){return e.nodeType==e.TEXT_NODE&&""==e.textContent.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$|\n+/g,"")}},{key:"_isInVConsole",value:function(e){for(var t=e;null!=t;){if("__vconsole"==t.id)return!0;t=t.parentNode||void 0;}return!1}}])&&u(o.prototype,n), l&&u(o,l), t}();o.default=b, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t,o){var n=o(32);"string"==typeof n&&(n=[[e.i,n,""]]);var r={insert:"head",singleton:!1};o(5)(n,r);n.locals&&(e.exports=n.locals);},function(e,t,o){(e.exports=o(4)(!1)).push([e.i,'/* color */\n.vcelm-node {\n  color: #183691;\n}\n.vcelm-k {\n  color: #0086B3;\n}\n.vcelm-v {\n  color: #905;\n}\n/* layout */\n.vcelm-l {\n  padding-left: 8px;\n  position: relative;\n  word-wrap: break-word;\n  line-height: 1;\n}\n/*.vcelm-l.vcelm-noc {\n  padding-left: 0;\n}*/\n.vcelm-l.vc-toggle > .vcelm-node {\n  display: block;\n}\n.vcelm-l .vcelm-node:active {\n  background-color: rgba(0, 0, 0, 0.15);\n}\n.vcelm-l.vcelm-noc .vcelm-node:active {\n  background-color: transparent;\n}\n.vcelm-t {\n  white-space: pre-wrap;\n  word-wrap: break-word;\n}\n/* level */\n.vcelm-l .vcelm-l {\n  display: none;\n}\n.vcelm-l.vc-toggle > .vcelm-l {\n  margin-left: 4px;\n  display: block;\n}\n/* arrow */\n.vcelm-l:before {\n  content: "";\n  display: block;\n  position: absolute;\n  top: 6px;\n  left: 3px;\n  width: 0;\n  height: 0;\n  border: transparent solid 3px;\n  border-left-color: #000;\n}\n.vcelm-l.vc-toggle:before {\n  display: block;\n  top: 6px;\n  left: 0;\n  border-top-color: #000;\n  border-left-color: transparent;\n}\n.vcelm-l.vcelm-noc:before {\n  display: none;\n}\n',""]);},function(e,t){e.exports='<div>\n  <div class="vc-log"></div>\n</div>';},function(e,t,o){var n,r,i;r=[t,o(35),o(36),o(0),o(1)], void 0===(i="function"==typeof(n=function(o,n,r,i,a){function l(e){return e&&e.__esModule?e:{default:e}}function c(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=l(n), r=l(r), i=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(i), a=l(a);var s=function(){function e(t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e), this.node=t, this.view=this._create(this.node);}var t,o,i;return t=e, (o=[{key:"get",value:function(){return this.view}},{key:"_create",value:function(e,t){var o=document.createElement("DIV");switch(a.default.addClass(o,"vcelm-l"), e.nodeType){case o.ELEMENT_NODE:this._createElementNode(e,o);break;case o.TEXT_NODE:this._createTextNode(e,o);break;case o.COMMENT_NODE:case o.DOCUMENT_NODE:case o.DOCUMENT_TYPE_NODE:case o.DOCUMENT_FRAGMENT_NODE:}return o}},{key:"_createTextNode",value:function(e,t){a.default.addClass(t,"vcelm-t vcelm-noc"), e.textContent&&t.appendChild(function(e){return document.createTextNode(e)}(e.textContent.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")));}},{key:"_createElementNode",value:function(e,t){var o,i=(o=(o=e.tagName)?o.toLowerCase():"", ["br","hr","img","input","link","meta"].indexOf(o)>-1),l=i;0==e.childNodes.length&&(l=!0);var c=a.default.render(n.default,{node:e}),s=a.default.render(r.default,{node:e});if(l)a.default.addClass(t,"vcelm-noc"), t.appendChild(c), i||t.appendChild(s);else{t.appendChild(c);for(var d=0;d<e.childNodes.length;d++){var u=document.createElement("DIV");a.default.addClass(u,"vcelm-l"), t.appendChild(u);}i||t.appendChild(s);}}}])&&c(t.prototype,o), i&&c(t,i), e}();o.default=s, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t){e.exports='<span class="vcelm-node">&lt;{{node.tagName.toLowerCase()}}{{if (node.className || node.attributes.length)}}\n  <i class="vcelm-k">\n    {{for (var i = 0; i < node.attributes.length; i++)}}\n      {{if (node.attributes[i].value !== \'\')}}\n        {{node.attributes[i].name}}="<i class="vcelm-v">{{node.attributes[i].value}}</i>"{{else}}\n        {{node.attributes[i].name}}{{/if}}{{/for}}</i>{{/if}}&gt;</span>';},function(e,t){e.exports='<span class="vcelm-node">&lt;/{{node.tagName.toLowerCase()}}&gt;</span>';},function(e,t,o){var n,r,i;r=[t,o(2),o(38),o(39),o(0),o(1)], void 0===(i="function"==typeof(n=function(o,n,r,i,a,l){function c(e){return e&&e.__esModule?e:{default:e}}function s(e){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function d(e,t){for(var o=0;o<t.length;o++){var n=t[o];n.enumerable=n.enumerable||!1, n.configurable=!0, "value"in n&&(n.writable=!0), Object.defineProperty(e,n.key,n);}}function u(e,t){return!t||"object"!==s(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return e}(e):t}function v(e){return(v=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function f(e,t){return(f=Object.setPrototypeOf||function(e,t){return e.__proto__=t, e})(e,t)}Object.defineProperty(o,"__esModule",{value:!0}), o.default=void 0, n=c(n), r=c(r), i=c(i), a=function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var o in e)if(Object.prototype.hasOwnProperty.call(e,o)){var n=Object.defineProperty&&Object.getOwnPropertyDescriptor?Object.getOwnPropertyDescriptor(e,o):{};n.get||n.set?Object.defineProperty(t,o,n):t[o]=e[o];}return t.default=e, t}(a), l=c(l);var p=function(e){function t(){var e,o;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,t);for(var n=arguments.length,i=new Array(n),a=0;a<n;a++)i[a]=arguments[a];return(o=u(this,(e=v(t)).call.apply(e,[this].concat(i)))).$tabbox=l.default.render(r.default,{}), o.currentType="", o.typeNameMap={cookies:"Cookies",localstorage:"LocalStorage",sessionstorage:"SessionStorage"}, o}var o,c,s;return function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}), t&&f(e,t);}(t,n.default), o=t, (c=[{key:"onRenderTab",value:function(e){e(this.$tabbox);}},{key:"onAddTopBar",value:function(e){for(var t=this,o=["Cookies","LocalStorage","SessionStorage"],n=[],r=0;r<o.length;r++)n.push({name:o[r],data:{type:o[r].toLowerCase()},className:"",onClick:function(){if(l.default.hasClass(this,"vc-actived"))return!1;t.currentType=this.dataset.type, t.renderStorage();}});n[0].className="vc-actived", e(n);}},{key:"onAddTool",value:function(e){var t=this;e([{name:"Refresh",global:!1,onClick:function(e){t.renderStorage();}},{name:"Clear",global:!1,onClick:function(e){t.clearLog();}}]);}},{key:"onReady",value:function(){}},{key:"onShow",value:function(){""==this.currentType&&(this.currentType="cookies", this.renderStorage());}},{key:"clearLog",value:function(){if(this.currentType&&window.confirm&&!window.confirm("Remove all "+this.typeNameMap[this.currentType]+"?"))return!1;switch(this.currentType){case"cookies":this.clearCookieList();break;case"localstorage":this.clearLocalStorageList();break;case"sessionstorage":this.clearSessionStorageList();break;default:return!1}this.renderStorage();}},{key:"renderStorage",value:function(){var e=[];switch(this.currentType){case"cookies":e=this.getCookieList();break;case"localstorage":e=this.getLocalStorageList();break;case"sessionstorage":e=this.getSessionStorageList();break;default:return!1}var t=l.default.one(".vc-log",this.$tabbox);if(0==e.length)t.innerHTML="";else{for(var o=0;o<e.length;o++)e[o].name=a.htmlEncode(e[o].name), e[o].value=a.htmlEncode(e[o].value);t.innerHTML=l.default.render(i.default,{list:e},!0);}}},{key:"getCookieList",value:function(){if(!document.cookie||!navigator.cookieEnabled)return[];for(var e=[],t=document.cookie.split(";"),o=0;o<t.length;o++){var n=t[o].split("="),r=n.shift().replace(/^ /,""),i=n.join("=");try{r=decodeURIComponent(r), i=decodeURIComponent(i);}catch(e){console.log(e,r,i);}e.push({name:r,value:i});}return e}},{key:"getLocalStorageList",value:function(){if(!window.localStorage)return[];try{for(var e=[],t=0;t<localStorage.length;t++){var o=localStorage.key(t),n=localStorage.getItem(o);e.push({name:o,value:n});}return e}catch(e){return[]}}},{key:"getSessionStorageList",value:function(){if(!window.sessionStorage)return[];try{for(var e=[],t=0;t<sessionStorage.length;t++){var o=sessionStorage.key(t),n=sessionStorage.getItem(o);e.push({name:o,value:n});}return e}catch(e){return[]}}},{key:"clearCookieList",value:function(){if(document.cookie&&navigator.cookieEnabled){for(var e=window.location.hostname,t=this.getCookieList(),o=0;o<t.length;o++){var n=t[o].name;document.cookie="".concat(n,"=;expires=Thu, 01 Jan 1970 00:00:00 GMT"), document.cookie="".concat(n,"=;expires=Thu, 01 Jan 1970 00:00:00 GMT;path=/"), document.cookie="".concat(n,"=;expires=Thu, 01 Jan 1970 00:00:00 GMT;path=/;domain=.").concat(e.split(".").slice(-2).join("."));}this.renderStorage();}}},{key:"clearLocalStorageList",value:function(){if(window.localStorage)try{localStorage.clear(), this.renderStorage();}catch(e){alert("localStorage.clear() fail.");}}},{key:"clearSessionStorageList",value:function(){if(window.sessionStorage)try{sessionStorage.clear(), this.renderStorage();}catch(e){alert("sessionStorage.clear() fail.");}}}])&&d(o.prototype,c), s&&d(o,s), t}();o.default=p, e.exports=t.default;})?n.apply(t,r):n)||(e.exports=i);},function(e,t){e.exports='<div class="vc-table">\n  <div class="vc-log"></div>\n</div>';},function(e,t){e.exports='<div>\n  <dl class="vc-table-row">\n    <dd class="vc-table-col">Name</dd>\n    <dd class="vc-table-col vc-table-col-2">Value</dd>\n  </dl>\n  {{for (var i = 0; i < list.length; i++)}}\n  <dl class="vc-table-row">\n    <dd class="vc-table-col">{{list[i].name}}</dd>\n    <dd class="vc-table-col vc-table-col-2">{{list[i].value}}</dd>\n  </dl>\n  {{/for}}\n</div>';}])});
});

var vConsole = unwrapExports(vconsole_min);
var vconsole_min_1 = vconsole_min.VConsole;

// todo 动态加载vconsole
function loadVConsole(isLoad) {
  if (isLoad) new vConsole();
}

var auth = {};

/** @授权成功后挂载API */
auth.requestLib = function () {
  return new _Promise(function (resolve, reject) {
    var appType = pageConfig.appType || pageConfig.appKey;
    setTimeout(function () {
      var resp = {
        success: true,
        code: 200,
        message: "请求成功",
        msg: "success",
        data: {
          appType: appType,
          desc: "产品授权"
        }
      };

      resolve(resp);
      // const msg = `mjs load failure. ♨ 访问应用: ${resp.data.appType} ${resp.message} ©️ 版权请请联系: https://www.aliwork.com/o/mc`;
      // reject(msg);
    }, 750);
  });
};

/** @打开钉钉名片 */
auth.contactNoDing = function (noDing) {
  window.open("dingtalk://dingtalkclient/action/sendmsg?dingtalk_id=" + noDing, // 燕江钉钉号
  "_self");
};

/** @钉钉名片牧语 */
auth.contactUs = function () {
  window.open("dingtalk://dingtalkclient/action/sendmsg?dingtalk_id=yanjiangboy", // 燕江钉钉号
  "_self");
};

////// 阿竹：invitedDeptId=58279212，invitedCode=P127003E238004，dingtalk_id=k9b-l2lrvwk1v //////

/** @钉钉商务名片 */
auth.contactBusiness = function () {
  window.open("dingtalk://dingtalkclient/action/sendmsg?dingtalk_id=k9b-l2lrvwk1v", "_self");
};

/** @创建场景群 */
auth.contactLeads = function () {
  var channel = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "上海云璞宜搭模板";

  window.open("https://partner.dingtalk.com/opportunity_web.html?templateId=75fe8503808347c6ab6269b431a1e254&invitedCode=P127003E238004&invitedDeptId=58279212&channel=" + channel + "#/consultingService", "_blank");
};

var com = {};

// 页面环境: 0提交(其它)，1查看，2编辑(审批)
com.checkEnv = function () {
  var instanceData = mjs.$this.utils.getFormInstanceData();
  var _instanceData$flowDat = instanceData.flowData,
      flowData = _instanceData$flowDat === undefined ? {} : _instanceData$flowDat;
  var editMode = flowData.editMode,
      viewMode = flowData.viewMode;

  if (editMode) return 2; // 审批页面为2, 编辑状态
  if (viewMode) return 1;
  return 0;
};

// 冗余Toast提示方法
com.showMessage = function (title) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "success";
  var size = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "medium";
  var duration = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "750";

  if (!title) return;
  mjs.$this.utils.toast({ type: type, title: title, size: size, duration: duration });
};

// type: 'success', 'warning', 'error', 'notice', 'help', 'loading'
com.showErrorMessage = function (title) {
  this.showMessage(title, "error");
};

// size: large, medium
com.showSuccessMessage = function (title) {
  this.showMessage(title);
};

// 冗余显示全屏loading: 全局对象
var G_DIALOG = void 0;
com.showLoading = function () {
  var title = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "拼命加载中...";

  if (G_DIALOG) return; // 避免多次闪屏
  G_DIALOG = mjs.$this.utils.toast({ type: "loading", title: title, closeable: false, footer: false, messageProps: { type: "loading" } });
};

// 冗余隐藏全屏loading: 全局对象
com.hideLoading = function () {
  G_DIALOG && G_DIALOG();
  G_DIALOG = null;
};

// 弹出确认框
com.showConfirm = function (title, content) {
  var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "confirm";

  if (!title && !content) {
    throw new Error(type + " => The title and content are empty.");
  }
  return new _Promise(function (resolve, reject) {
    mjs.$this.utils.dialog({
      type: type, title: title, content: content, /* 如需换行可传入 HTML/JSX 来实现 */
      onOk: function onOk() {
        return resolve();
      },
      onCancel: function onCancel() {
        return reject("用户取消了");
      }
    });
  });
};

// 提交校验toast
com.toastAccess = function (isShow, title, resolve, reject) {
  console.log(isShow, title);
  if (isShow) {
    mjs.$this.utils.toast({
      title: title, // 'success', 'warning', 'error', 'notice', 'help', 'loading'
      type: 'error',
      size: 'large',
      duration: 2000 // 毫秒, type 为 loding 时无效
    });
    reject && reject(title);
    return false;
  }
  resolve && resolve();
  return true;
};

/**
 * ppExt: 提交校验 [存在请求若报错无需catch]
 * 1. 返回Promise时，不能在Promise外直接return，会提示undefined
 * 2. 失败需要返回reject，否则不会重置按钮loading状态，无法重新发起提交
 */

// 提交错误toast
com.toastError = function (title, resolve, reject) {
  return this.toastAccess(!!title, title, resolve, reject);
};

// 提交弱校验【后置: 置于所有判断的最后, 避免命中若校验直接提交了】
com.dialogTips = function (title, message, resolve, reject) {
  if (title || message) {
    mjs.$this.utils.dialog({
      method: 'alert', // 'alert', 'confirm', 'show'
      title: title,
      content: message, // 如需换行可传入 HTML/JSX 来实现
      onOk: function onOk() {
        resolve && resolve();
      },
      onCancel: function onCancel() {
        reject && reject();
      }
    });
    return false;
  }
  return true;
};

// 获取当前地址的表单实例ID
com.getFormInstIdByUrl = function () {
  if (mjs.$this) {
    // 智障的设计：流程从管理页面进入是 formInstId ，流程提交完成是 procInsId
    var query = mjs.$this.utils.router.getQuery();
    return query.procInsId || query.formInstId;
  }
  var url = window.location.href;
  if (url.includes("procInsId=")) {
    return url.split("procInsId=")[1].split("&")[0];
  }
  return url.split("formInstId=")[1].split("&")[0];
};

var $JSON = _core.JSON || (_core.JSON = { stringify: JSON.stringify });
var stringify$1 = function stringify(it) { // eslint-disable-line no-unused-vars
  return $JSON.stringify.apply($JSON, arguments);
};

var stringify = createCommonjsModule(function (module) {
module.exports = { "default": stringify$1, __esModule: true };
});

var _JSON$stringify = unwrapExports(stringify);

var sdkLib = createCommonjsModule(function (module, exports) {
function isFunction(o){return"function"==typeof o}function compareVersion(o,e){function r(o){return parseInt(o,10)||0}for(var n=o.split(".").map(r),t=e.split(".").map(r),E=0;E<n.length;E++){if(void 0===t[E])return!1;if(n[E]<t[E])return!1;if(n[E]>t[E])return!0}return!0}Object.defineProperty(exports,"__esModule",{value:!0}), exports.LogLevel=exports.APP_TYPE=exports.ENV_ENUM_SUB=exports.ENV_ENUM=exports.ERROR_CODE=exports.compareVersion=exports.isFunction=void 0, exports.isFunction=isFunction, exports.compareVersion=compareVersion;var ERROR_CODE;!function(o){o.cancel="-1", o.not_exist="1", o.no_permission="7", o.jsapi_internal_error="22";}(ERROR_CODE=exports.ERROR_CODE||(exports.ERROR_CODE={}));var ENV_ENUM;!function(o){o.pc="pc", o.android="android", o.ios="ios", o.notInDingTalk="notInDingTalk";}(ENV_ENUM=exports.ENV_ENUM||(exports.ENV_ENUM={}));var ENV_ENUM_SUB;!function(o){o.mac="mac", o.win="win", o.noSub="noSub";}(ENV_ENUM_SUB=exports.ENV_ENUM_SUB||(exports.ENV_ENUM_SUB={}));var APP_TYPE;!function(o){o.WEB="WEB", o.MINI_APP="MINI_APP", o.WEEX="WEEX", o.WEBVIEW_IN_MINIAPP="WEBVIEW_IN_MINIAPP", o.WEEX_WIDGET="WEEX_WIDGET";}(APP_TYPE=exports.APP_TYPE||(exports.APP_TYPE={}));var LogLevel;!function(o){o[o.INFO=1]="INFO", o[o.WARNING=2]="WARNING", o[o.ERROR=3]="ERROR";}(LogLevel=exports.LogLevel||(exports.LogLevel={}));
});

unwrapExports(sdkLib);
var sdkLib_1 = sdkLib.LogLevel;
var sdkLib_2 = sdkLib.APP_TYPE;
var sdkLib_3 = sdkLib.ENV_ENUM_SUB;
var sdkLib_4 = sdkLib.ENV_ENUM;
var sdkLib_5 = sdkLib.ERROR_CODE;
var sdkLib_6 = sdkLib.compareVersion;
var sdkLib_7 = sdkLib.isFunction;

var sdk = createCommonjsModule(function (module, exports) {
function getTargetApiConfigVS(e,o){var i=e&&e.vs;return"object"==typeof i&&(i=i[o.platformSub]), i}Object.defineProperty(exports,"__esModule",{value:!0}), exports.Sdk=exports.LogLevel=exports.APP_TYPE=exports.isFunction=exports.compareVersion=exports.ENV_ENUM_SUB=exports.ENV_ENUM=void 0;Object.defineProperty(exports,"APP_TYPE",{enumerable:!0,get:function(){return sdkLib.APP_TYPE}}), Object.defineProperty(exports,"LogLevel",{enumerable:!0,get:function(){return sdkLib.LogLevel}}), Object.defineProperty(exports,"isFunction",{enumerable:!0,get:function(){return sdkLib.isFunction}}), Object.defineProperty(exports,"compareVersion",{enumerable:!0,get:function(){return sdkLib.compareVersion}}), Object.defineProperty(exports,"ENV_ENUM",{enumerable:!0,get:function(){return sdkLib.ENV_ENUM}}), Object.defineProperty(exports,"ENV_ENUM_SUB",{enumerable:!0,get:function(){return sdkLib.ENV_ENUM_SUB}});var Sdk=function(){function e(e,o){var i=this;this.configJsApiList=[], this.hadConfig=!1, this.p={}, this.config$=new Promise(function(e,o){i.p.reject=o, i.p.resolve=e;}), this.logQueue=[], this.devConfig={debug:!1}, this.platformConfigMap={}, this.invokeAPIConfigMapByMethod={}, this.isBridgeDrity=!0, this.getExportSdk=function(){return i.exportSdk}, this.setAPI=function(e,o){i.invokeAPIConfigMapByMethod[e]=o;}, this.setPlatform=function(e){i.isBridgeDrity=!0, i.platformConfigMap[e.platform]=e, e.platform===i.env.platform&&e.bridgeInit().catch(function(e){i.customLog(sdkLib.LogLevel.WARNING,["auto bridgeInit error",e||""]);});}, this.getPlatformConfigMap=function(){return i.platformConfigMap}, this.deleteApiConfig=function(e,o){var n=i.invokeAPIConfigMapByMethod[e];n&&delete n[o];}, this.invokeAPI=function(e,o,n){void 0===o&&(o={}), void 0===n&&(n=!0), i.customLog(sdkLib.LogLevel.INFO,['==> "'+e+'" params: ',o]);var t=+new Date,r=t+"_"+Math.floor(1e3*Math.random());if(i.devConfig.onBeforeInvokeAPI)try{i.devConfig.onBeforeInvokeAPI({invokeId:r,method:e,params:o,startTime:t});}catch(e){i.customLog(sdkLib.LogLevel.ERROR,["call Hook:onBeforeInvokeAPI failed, reason:",e]);}return!1===i.devConfig.isAuthApi&&(n=!1), i.bridgeInitFn().then(function(s){var a=i.invokeAPIConfigMapByMethod[e],f=i.devConfig.forceEnableDealApiFnMap&&i.devConfig.forceEnableDealApiFnMap[e]&&!0===i.devConfig.forceEnableDealApiFnMap[e](o),d=!f&&(!0===i.devConfig.isDisableDeal||i.devConfig.disbaleDealApiWhiteList&&-1!==i.devConfig.disbaleDealApiWhiteList.indexOf(e));if(a||!n){var c;if(a&&(c=a[i.env.platform]), c||!n){var u={};u=!d&&c&&c.paramsDeal&&sdkLib.isFunction(c.paramsDeal)?c.paramsDeal(o):Object.assign({},o);var g=function(e){return!d&&c&&c.resultDeal&&sdkLib.isFunction(c.resultDeal)?c.resultDeal(e):e};if(sdkLib.isFunction(u.onSuccess)){var l=u.onSuccess;u.onSuccess=function(e){l(g(e));};}return s(e,u).then(g,function(o){var t=i.hadConfig&&void 0===i.isReady&&-1!==i.configJsApiList.indexOf(e),r="object"==typeof o&&"string"==typeof o.errorCode&&o.errorCode===sdkLib.ERROR_CODE.no_permission,a="object"==typeof o&&"string"==typeof o.errorCode&&o.errorCode===sdkLib.ERROR_CODE.cancel,f=getTargetApiConfigVS(c,i.env),d=f&&i.env.version&&sdkLib.compareVersion(i.env.version,f),l=(i.env.platform===sdkLib.ENV_ENUM.ios||i.env.platform===sdkLib.ENV_ENUM.android)&&t&&r,p=i.env.platform===sdkLib.ENV_ENUM.pc&&t&&(d&&!a&&n||r);return l||p?i.config$.then(function(){return s(e,u).then(g)}):Promise.reject(o)}).then(function(n){if(i.devConfig.onAfterInvokeAPI)try{i.devConfig.onAfterInvokeAPI({invokeId:r,method:e,params:o,payload:n,isSuccess:!0,startTime:t,duration:+new Date-t});}catch(e){i.customLog(sdkLib.LogLevel.ERROR,["call Hook:onAfterInvokeAPI failed, reason:",e]);}return i.customLog(sdkLib.LogLevel.INFO,['<== "'+e+'" success result: ',n]), n},function(n){if(i.devConfig.onAfterInvokeAPI)try{i.devConfig.onAfterInvokeAPI({invokeId:r,method:e,params:o,payload:n,startTime:t,duration:+new Date-t,isSuccess:!1});}catch(n){i.customLog(sdkLib.LogLevel.ERROR,["call Hook:onAfterInvokeAPI failed, reason:",n]);}return i.customLog(sdkLib.LogLevel.WARNING,['<== "'+e+'" fail result: ',n]), Promise.reject(n)})}var p='"'+e+'" do not support the current platform ('+i.env.platform+")";return i.customLog(sdkLib.LogLevel.ERROR,[p]), Promise.reject({errorCode:sdkLib.ERROR_CODE.jsapi_internal_error,errorMessage:p})}var p="This API method is not configured for the platform ("+i.env.platform+")";return i.customLog(sdkLib.LogLevel.ERROR,[p]), Promise.reject({errorCode:sdkLib.ERROR_CODE.jsapi_internal_error,errorMessage:p})})}, this.customLog=function(e,o){var n={level:e,text:o,time:new Date};if(!0===i.devConfig.debug)i.customLogInstance(n);else{i.logQueue.push(n);i.logQueue.length>10&&(i.logQueue=i.logQueue.slice(i.logQueue.length-10));}}, this.clearLogQueue=function(){i.logQueue.forEach(function(e){i.customLogInstance(e);}), i.logQueue=[];}, this.customLogInstance=o, this.env=e, this.bridgeInitFn=function(){if(i.bridgeInitFnPromise&&!i.isBridgeDrity)return i.bridgeInitFnPromise;i.isBridgeDrity=!1;var o=i.platformConfigMap[e.platform];if(o)i.bridgeInitFnPromise=o.bridgeInit().catch(function(e){return i.customLog(sdkLib.LogLevel.ERROR,["\b\b\b\b\bJsBridge initialization fails, jsapi will not work"]), Promise.reject(e)});else{var n="Do not support the current environment："+e.platform;i.customLog(sdkLib.LogLevel.WARNING,[n]), i.bridgeInitFnPromise=Promise.reject(new Error(n));}return i.bridgeInitFnPromise};var n=function(e){void 0===e&&(e={}), i.devConfig=Object.assign(i.devConfig,e), !0===e.debug&&i.clearLogQueue(), e.extraPlatform&&i.setPlatform(e.extraPlatform);};this.exportSdk={config:function(o){void 0===o&&(o={});var t=!0;Object.keys(o).forEach(function(e){-1===["debug","usePromise"].indexOf(e)&&(t=!1);}), t?(i.customLog(sdkLib.LogLevel.WARNING,["This is a deprecated feature, recommend use dd.devConfig"]), n(o)):i.hadConfig?i.customLog(sdkLib.LogLevel.WARNING,["Config has been executed"]):(o.jsApiList&&(i.configJsApiList=o.jsApiList), i.hadConfig=!0, i.bridgeInitFn().then(function(n){var t=i.platformConfigMap[e.platform],r=o;t.authParamsDeal&&(r=t.authParamsDeal(r)), n(t.authMethod,r).then(function(e){i.isReady=!0, i.p.resolve(e);}).catch(function(e){i.isReady=!1, i.p.reject(e);});},function(){i.customLog(sdkLib.LogLevel.ERROR,['\b\b\b\b\bJsBridge initialization failed and "dd.config" failed to call']);}));},devConfig:n,ready:function(e){!1===i.hadConfig?(i.customLog(sdkLib.LogLevel.WARNING,["You don 't use a dd.config, so you don't need to wrap dd.ready, recommend remove dd.ready"]), i.bridgeInitFn().then(function(){e();})):i.config$.then(function(o){e();});},error:function(e){i.config$.catch(function(o){e(o);});},on:function(o,n){i.bridgeInitFn().then(function(){i.platformConfigMap[e.platform].event.on(o,n);});},off:function(o,n){i.bridgeInitFn().then(function(){i.platformConfigMap[e.platform].event.off(o,n);});},env:e,checkJsApi:function(o){void 0===o&&(o={});var n={};return o.jsApiList&&o.jsApiList.forEach(function(o){var t=i.invokeAPIConfigMapByMethod[o];if(t){var r=t[e.platform],s=getTargetApiConfigVS(r,e);s&&e.version&&sdkLib.compareVersion(e.version,s)&&(n[o]=!0);}n[o]||(n[o]=!1);}), Promise.resolve(n)},_invoke:function(e,o){return void 0===o&&(o={}), i.invokeAPI(e,o,!1)}};}return e}();exports.Sdk=Sdk;
});

unwrapExports(sdk);
var sdk_1 = sdk.Sdk;
var sdk_2 = sdk.LogLevel;
var sdk_3 = sdk.APP_TYPE;
var sdk_4 = sdk.isFunction;
var sdk_5 = sdk.compareVersion;
var sdk_6 = sdk.ENV_ENUM_SUB;
var sdk_7 = sdk.ENV_ENUM;

var whichOneRuntime_1 = createCommonjsModule(function (module, exports) {
function snifferMachine(e,n){for(var i=e.length,a=0,f=!0;a<i;a++)try{if(!(e[a]in n)){f=!1;break}}catch(e){f=!1;break}return f}function whichOneRuntime(){return maybeInWebView&&maybeInWeexVueEnv?snifferMachine(snifferWeexVueMap,weex)?"Web.Vue":"Web.Unknown":!maybeInWebView&&maybeInWeexVueEnv?snifferMachine(snifferWeexVueMap,weex)?"Weex.Vue":"Weex.Unknown":maybeInWebView&&maybeInNative&&!maybeInWeexVueEnv?snifferMachine(snifferWeexRaxMap,window)?"Weex.Rax":"Weex.Unknown":maybeInWebView&&snifferMachine(snifferWebViewMap,window)?"Web.Unknown":"Unknown.Unknown"}Object.defineProperty(exports,"__esModule",{value:!0});var maybeInWebView="undefined"!=typeof window,maybeInWeexVueEnv="undefined"!=typeof weex,maybeInNative="undefined"!=typeof callNative,snifferWeexRaxMap=["__weex_config__","__weex_options__","__weex_require__"],snifferWebViewMap=["localStorage","location","navigator","XMLHttpRequest"],snifferWeexVueMap=["config","requireModule","document"];exports.default=whichOneRuntime;
});

unwrapExports(whichOneRuntime_1);

var constants = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.FRAMEWORK=exports.PLATFORM=exports.RUNTIME=void 0, exports.RUNTIME={WEB:"Web",WEEX:"Weex",UNKNOWN:"Unknown"}, exports.PLATFORM={MAC:"Mac",WINDOWS:"Windows",IOS:"iOS",ANDROID:"Android",IPAD:"iPad",BROWSER:"Browser",UNKNOWN:"Unknown"}, exports.FRAMEWORK={VUE:"Vue",RAX:"Rax",UNKNOWN:"Unknown"};
});

unwrapExports(constants);
var constants_1 = constants.FRAMEWORK;
var constants_2 = constants.PLATFORM;
var constants_3 = constants.RUNTIME;

var environment_1 = createCommonjsModule(function (module, exports) {
function environment(n,i,a){var t="Web"===a.platform,e="iOS"===a.platform,r="android"===a.platform,o=r||e,s=function(){return t?window.navigator.userAgent.toLowerCase():""}(),c=function(){var n={};if(t){var i=window.name;try{var a=JSON.parse(i);n.containerId=a.containerId, n.version=a.hostVersion, n.language=a.language||"*";}catch(n){}}return n}(),d=function(){return o?"DingTalk"===a.appName||"com.alibaba.android.rimet"===a.appName:s.indexOf("dingtalk")>-1||!!c.containerId}(),O=function(){if(t){if(c.version)return c.version;var n=s.match(/aliapp\(\w+\/([a-zA-Z0-9.-]+)\)/);null===n&&(n=s.match(/dingtalk\/([a-zA-Z0-9.-]+)/));return n&&n[1]||"Unknown"}return a.appVersion}(),u=!!c.containerId,l=/iphone|ipod|ios/.test(s),f=/ipad/.test(s),p=s.indexOf("android")>-1,m=s.indexOf("mac")>-1&&u,A=s.indexOf("win")>-1&&u,g=!m&&!A&&u,v=u,P="";return P=d?l||e?constants.PLATFORM.IOS:p||r?constants.PLATFORM.ANDROID:f?constants.PLATFORM.IPAD:m?constants.PLATFORM.MAC:A?constants.PLATFORM.WINDOWS:g?constants.PLATFORM.BROWSER:constants.PLATFORM.UNKNOWN:constants.PLATFORM.UNKNOWN, {isDingTalk:d,isWebiOS:l,isWebAndroid:p,isWeexiOS:e,isWeexAndroid:r,isDingTalkPCMac:m,isDingTalkPCWeb:g,isDingTalkPCWindows:A,isDingTalkPC:v,runtime:n,framework:i,platform:P,version:O,isWeex:o}}Object.defineProperty(exports,"__esModule",{value:!0});exports.default=environment;
});

unwrapExports(environment_1);

var dingtalkJavascriptEnv = createCommonjsModule(function (module, exports) {
function getVirtualEnv(){var n={};switch(framework){case constants.FRAMEWORK.VUE:var t=weex.config,e=t.env;n.platform=e.platform, constants.RUNTIME.WEEX===runtime&&(n.appVersion=e.appVersion, n.appName=e.appName);break;case constants.FRAMEWORK.RAX:constants.RUNTIME.WEEX===runtime&&(n.platform=navigator.platform, n.appName=navigator.appName, n.appVersion=navigator.appVersion);break;case constants.FRAMEWORK.UNKNOWN:constants.RUNTIME.WEB===runtime&&(n.platform=constants.RUNTIME.WEB), constants.RUNTIME.UNKNOWN===runtime&&(n.platform=constants.RUNTIME.UNKNOWN);}return n}Object.defineProperty(exports,"__esModule",{value:!0});var _a=whichOneRuntime_1.default().split("."),runtime=_a[0],framework=_a[1],virtualEnv=getVirtualEnv(),env=environment_1.default(runtime,framework,virtualEnv);exports.default=env;
});

unwrapExports(dingtalkJavascriptEnv);

var env = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.getENV=exports.getUA=void 0;var sdk_2=sdk;Object.defineProperty(exports,"ENV_ENUM",{enumerable:!0,get:function(){return sdk_2.ENV_ENUM}}), Object.defineProperty(exports,"APP_TYPE",{enumerable:!0,get:function(){return sdk_2.APP_TYPE}}), Object.defineProperty(exports,"ENV_ENUM_SUB",{enumerable:!0,get:function(){return sdk_2.ENV_ENUM_SUB}});var EDdWeexEnv;!function(e){e.singlePage="singlePage", e.miniApp="miniApp", e.miniWidget="miniWidget";}(EDdWeexEnv||(EDdWeexEnv={})), exports.getUA=function(){var e="";try{"undefined"!=typeof navigator&&(e=navigator&&(navigator.userAgent||navigator.swuserAgent)||"");}catch(t){e="";}return e}, exports.getENV=function(){var e=exports.getUA(),t=/iPhone|iPad|iPod|iOS/i.test(e),i=/Android/i.test(e),n=/Nebula/i.test(e),a=/DingTalk/i.test(e),r=/dd-web/i.test(e),d="object"==typeof nuva,s="object"==typeof dd&&"function"==typeof dd.dtBridge,_=s&&t||d&&t,o=a||dingtalkJavascriptEnv.default.isDingTalk,E=t&&o||dingtalkJavascriptEnv.default.isWeexiOS||_,g=i&&o||dingtalkJavascriptEnv.default.isWeexAndroid,v=n&&o||s,l=r,p=sdk.APP_TYPE.WEB;if(l)p=sdk.APP_TYPE.WEBVIEW_IN_MINIAPP;else if(v)p=sdk.APP_TYPE.MINI_APP;else if(dingtalkJavascriptEnv.default.isWeexiOS||dingtalkJavascriptEnv.default.isWeexAndroid)try{var u=weex.config.ddWeexEnv;p=u===EDdWeexEnv.miniWidget?sdk.APP_TYPE.WEEX_WIDGET:sdk.APP_TYPE.WEEX;}catch(e){p=sdk.APP_TYPE.WEEX;}var c,P="*",f=e.match(/AliApp\(\w+\/([a-zA-Z0-9.-]+)\)/);null===f&&(f=e.match(/DingTalk\/([a-zA-Z0-9.-]+)/));var k;f&&f[1]&&(k=f[1]);var N="";if("undefined"!=typeof name&&(N=name), N)try{var A=JSON.parse(N);A.hostVersion&&(k=A.hostVersion), P=A.language||navigator.language||"*", c=A.containerId;}catch(e){}var x=!!c;x&&!k&&(f=e.match(/DingTalk\(([a-zA-Z0-9\.-]+)\)/))&&f[1]&&(k=f[1]);var U,W=sdk.ENV_ENUM_SUB.noSub;if(E)U=sdk.ENV_ENUM.ios;else if(g)U=sdk.ENV_ENUM.android;else if(x){var m=e.indexOf("Macintosh; Intel Mac OS")>-1;W=m?sdk.ENV_ENUM_SUB.mac:sdk.ENV_ENUM_SUB.win, U=sdk.ENV_ENUM.pc;}else U=sdk.ENV_ENUM.notInDingTalk;return{platform:U,platformSub:W,version:k,appType:p,language:P}};
});

unwrapExports(env);
var env_1 = env.getENV;
var env_2 = env.getUA;

var log = createCommonjsModule(function (module, exports) {
function padNumber(e){return e="00"+e, e.substring(e.length-2,e.length)}var __spreadArrays=commonjsGlobal&&commonjsGlobal.__spreadArrays||function(){for(var e=0,r=0,t=arguments.length;r<t;r++)e+=arguments[r].length;for(var o=Array(e),s=0,r=0;r<t;r++)for(var n=arguments[r],a=0,u=n.length;a<u;a++, s++)o[s]=n[a];return o};Object.defineProperty(exports,"__esModule",{value:!0}), exports.log=void 0, exports.log=function(e){console.log.apply(console,__spreadArrays([padNumber(e.time.getHours())+":"+padNumber(e.time.getMinutes())+":"+padNumber(e.time.getSeconds())],e.text));};
});

unwrapExports(log);
var log_1 = log.log;

var polyfill = createCommonjsModule(function (module, exports) {
(function (global, factory) {
	factory();
}(commonjsGlobal, (function () { var setTimeoutFunc = setTimeout;

function noop() {}

// Polyfill for Function.prototype.bind
function bind(fn, thisArg) {
  return function() {
    fn.apply(thisArg, arguments);
  };
}

function Promise(fn) {
  if (!(this instanceof Promise))
    throw new TypeError('Promises must be constructed via new');
  if (typeof fn !== 'function') throw new TypeError('not a function');
  this._state = 0;
  this._handled = false;
  this._value = undefined;
  this._deferreds = [];

  doResolve(fn, this);
}

function handle(self, deferred) {
  while (self._state === 3) {
    self = self._value;
  }
  if (self._state === 0) {
    self._deferreds.push(deferred);
    return;
  }
  self._handled = true;
  Promise._immediateFn(function() {
    var cb = self._state === 1 ? deferred.onFulfilled : deferred.onRejected;
    if (cb === null) {
      (self._state === 1 ? resolve : reject)(deferred.promise, self._value);
      return;
    }
    var ret;
    try {
      ret = cb(self._value);
    } catch (e) {
      reject(deferred.promise, e);
      return;
    }
    resolve(deferred.promise, ret);
  });
}

function resolve(self, newValue) {
  try {
    // Promise Resolution Procedure: https://github.com/promises-aplus/promises-spec#the-promise-resolution-procedure
    if (newValue === self)
      throw new TypeError('A promise cannot be resolved with itself.');
    if (
      newValue &&
      (typeof newValue === 'object' || typeof newValue === 'function')
    ) {
      var then = newValue.then;
      if (newValue instanceof Promise) {
        self._state = 3;
        self._value = newValue;
        finale(self);
        return;
      } else if (typeof then === 'function') {
        doResolve(bind(then, newValue), self);
        return;
      }
    }
    self._state = 1;
    self._value = newValue;
    finale(self);
  } catch (e) {
    reject(self, e);
  }
}

function reject(self, newValue) {
  self._state = 2;
  self._value = newValue;
  finale(self);
}

function finale(self) {
  if (self._state === 2 && self._deferreds.length === 0) {
    Promise._immediateFn(function() {
      if (!self._handled) {
        Promise._unhandledRejectionFn(self._value);
      }
    });
  }

  for (var i = 0, len = self._deferreds.length; i < len; i++) {
    handle(self, self._deferreds[i]);
  }
  self._deferreds = null;
}

function Handler(onFulfilled, onRejected, promise) {
  this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
  this.onRejected = typeof onRejected === 'function' ? onRejected : null;
  this.promise = promise;
}

/**
 * Take a potentially misbehaving resolver function and make sure
 * onFulfilled and onRejected are only called once.
 *
 * Makes no guarantees about asynchrony.
 */
function doResolve(fn, self) {
  var done = false;
  try {
    fn(
      function(value) {
        if (done) return;
        done = true;
        resolve(self, value);
      },
      function(reason) {
        if (done) return;
        done = true;
        reject(self, reason);
      }
    );
  } catch (ex) {
    if (done) return;
    done = true;
    reject(self, ex);
  }
}

Promise.prototype['catch'] = function(onRejected) {
  return this.then(null, onRejected);
};

Promise.prototype.then = function(onFulfilled, onRejected) {
  var prom = new this.constructor(noop);

  handle(this, new Handler(onFulfilled, onRejected, prom));
  return prom;
};

Promise.prototype['finally'] = function(callback) {
  var constructor = this.constructor;
  return this.then(
    function(value) {
      return constructor.resolve(callback()).then(function() {
        return value;
      });
    },
    function(reason) {
      return constructor.resolve(callback()).then(function() {
        return constructor.reject(reason);
      });
    }
  );
};

Promise.all = function(arr) {
  return new Promise(function(resolve, reject) {
    if (!arr || typeof arr.length === 'undefined')
      throw new TypeError('Promise.all accepts an array');
    var args = Array.prototype.slice.call(arr);
    if (args.length === 0) return resolve([]);
    var remaining = args.length;

    function res(i, val) {
      try {
        if (val && (typeof val === 'object' || typeof val === 'function')) {
          var then = val.then;
          if (typeof then === 'function') {
            then.call(
              val,
              function(val) {
                res(i, val);
              },
              reject
            );
            return;
          }
        }
        args[i] = val;
        if (--remaining === 0) {
          resolve(args);
        }
      } catch (ex) {
        reject(ex);
      }
    }

    for (var i = 0; i < args.length; i++) {
      res(i, args[i]);
    }
  });
};

Promise.resolve = function(value) {
  if (value && typeof value === 'object' && value.constructor === Promise) {
    return value;
  }

  return new Promise(function(resolve) {
    resolve(value);
  });
};

Promise.reject = function(value) {
  return new Promise(function(resolve, reject) {
    reject(value);
  });
};

Promise.race = function(values) {
  return new Promise(function(resolve, reject) {
    for (var i = 0, len = values.length; i < len; i++) {
      values[i].then(resolve, reject);
    }
  });
};

// Use polyfill for setImmediate for performance gains
Promise._immediateFn =
  (typeof setImmediate === 'function' &&
    function(fn) {
      setImmediate(fn);
    }) ||
  function(fn) {
    setTimeoutFunc(fn, 0);
  };

Promise._unhandledRejectionFn = function _unhandledRejectionFn(err) {
  if (typeof console !== 'undefined' && console) {
    console.warn('Possible Unhandled Promise Rejection:', err); // eslint-disable-line no-console
  }
};

var globalNS = (function() {
  // the only reliable means to get the global object is
  // `Function('return this')()`
  // However, this causes CSP violations in Chrome apps.
  if (typeof self !== 'undefined') {
    return self;
  }
  if (typeof window !== 'undefined') {
    return window;
  }
  if (typeof commonjsGlobal !== 'undefined') {
    return commonjsGlobal;
  }
  throw new Error('unable to locate global object');
})();

if (!globalNS.Promise) {
  globalNS.Promise = Promise;
}

})));
});

"function"!=typeof Object.assign&&Object.defineProperty(Object,"assign",{value:function(e,t){if(null==e)throw new TypeError("Cannot convert undefined or null to object");for(var n=Object(e),r=1;r<arguments.length;r++){var o=arguments[r];if(null!=o)for(var c in o)Object.prototype.hasOwnProperty.call(o,c)&&(n[c]=o[c]);}return n},writable:!0,configurable:!0});

Object.keys||(Object.keys=function(e){if(e!==Object(e))throw new TypeError("Object.keys called on a non-object");var t,r=[];for(t in e)Object.prototype.hasOwnProperty.call(e,t)&&r.push(t);return r});

var objectKeys = Object.freeze({

});

var polyfills = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), objectKeys;
});

unwrapExports(polyfills);

var ddSdk = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.ddSdk=void 0;var env_2=env;Object.defineProperty(exports,"ENV_ENUM",{enumerable:!0,get:function(){return env_2.ENV_ENUM}}), Object.defineProperty(exports,"ENV_ENUM_SUB",{enumerable:!0,get:function(){return env_2.ENV_ENUM_SUB}});exports.ddSdk=new sdk.Sdk(env.getENV(),log.log);
});

unwrapExports(ddSdk);
var ddSdk_1 = ddSdk.ddSdk;

var otherApi = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.version=exports.language=exports.compareVersion=exports.other=exports.pc=exports.android=exports.ios=void 0;var ENV=env.getENV();exports.ios=ENV.platform===env.ENV_ENUM.ios, exports.android=ENV.platform===env.ENV_ENUM.android, exports.pc=ENV.platform===env.ENV_ENUM.pc, exports.other=ENV.platform===env.ENV_ENUM.notInDingTalk, exports.compareVersion=function(e,r,t){function o(e){return parseInt(e,10)||0}if("string"!=typeof e||"string"!=typeof r)return!1;for(var s,p,n=e.split("-")[0].split(".").map(o),i=r.split("-")[0].split(".").map(o);s===p&&i.length>0;)s=n.shift(), p=i.shift();return t?(p||0)>=(s||0):(p||0)>(s||0)}, exports.language=ENV.language, exports.version=ENV.version;
});

unwrapExports(otherApi);
var otherApi_1 = otherApi.version;
var otherApi_2 = otherApi.language;
var otherApi_3 = otherApi.compareVersion;
var otherApi_4 = otherApi.other;
var otherApi_5 = otherApi.pc;
var otherApi_6 = otherApi.android;
var otherApi_7 = otherApi.ios;

var core=Object.assign({},otherApi,ddSdk.ddSdk.getExportSdk());var core_1=core;

var frameTalkClientPc = createCommonjsModule(function (module, exports) {
!function(t,e){module.exports=e();}(commonjsGlobal,function(){return function(t){function e(r){if(n[r])return n[r].exports;var o=n[r]={i:r,l:!1,exports:{}};return t[r].call(o.exports,o,o.exports,e), o.l=!0, o.exports}var n={};return e.m=t, e.c=n, e.i=function(t){return t}, e.d=function(t,n,r){e.o(t,n)||Object.defineProperty(t,n,{configurable:!1,enumerable:!0,get:r});}, e.n=function(t){var n=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(n,"a",n), n}, e.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)}, e.p="", e(e.s=721)}({199:function(t,e,n){var r=n(201);t.exports=r;},201:function(t,e,n){var r=n(203),o=n(204),i=n(202),u=n(205),c=new i,a=!1,s="",f=null,l={},p=/{.*}/;try{var h=window.name.match(p);if(h&&h[0])var l=JSON.parse(h[0]);}catch(t){l={};}l.hostOrigin&&".dingtalk.com"===l.hostOrigin.split(":")[1].slice(0-".dingtalk.com".length)&&l.containerId&&(a=!0, s=l.hostOrigin, f=l.containerId);var d={},v=new Promise(function(t,e){d._resolve=t, d._reject=e;}),y={},_=null;window.top!==window?(_=window.top, d._resolve()):"object"==typeof dingtalk&&"object"==typeof dingtalk.platform&&"function"==typeof dingtalk.platform.invokeAPI&&(_=window, d._resolve()), y[u.SYS_INIT]=function(t){_=t.frameWindow, d._resolve(), t.respond({});}, window.addEventListener("message",function(t){var e=t.data,n=t.origin;if(n===s)if("response"===e.type&&e.msgId){var r=e.msgId,i=c.getMsyById(r);i&&i.methodName!==u.SYS_EVENT&&i.receiveResponse(e.body,!e.success);}else if("event"===e.type&&e.msgId){var r=e.msgId,i=c.getMsyById(r);i&&i.receiveEvent(e.eventName,e.body);}else if("request"===e.type&&e.msgId){var i=new o(t.source,n,e);y[i.methodName]&&y[i.methodName](i);}}), e.invokeAPI=function(t,e){var n=new r(f,t,e);return a&&v.then(function(){_&&_.postMessage(n.getPayload(),s), c.addPending(n);}), n};var b=null;e.addEventListener=function(t,n){b||(b=e.invokeAPI(u.SYS_EVENT,{})), b.addEventListener(t,n);}, e.removeEventListener=function(t,e){b&&b.removeEventListener(t,e);};},202:function(t,e,n){var r=function(){this.pendingMsgs={};};r.prototype.addPending=function(t){this.pendingMsgs[t.id]=t;var e=function(){delete this.pendingMsgs[t.id], t.removeEventListener("_finish",e);}.bind(this);t.addEventListener("_finish",e);}, r.prototype.getMsyById=function(t){return this.pendingMsgs[t]}, t.exports=r;},203:function(t,e,n){var r=n(716),o=n(715),i=0,u=Math.floor(1e3*Math.random()),c=function(){return 1e3*(1e3*u+Math.floor(1e3*Math.random()))+ ++i%1e3},a={code:408,reason:"timeout"},s={TIMEOUT:"_timeout",FINISH:"_finish"},f={timeout:-1},l=function(t,e,n,r){this.id=c(), this.methodName=e, this.containerId=t, this.option=o({},f,r);var n=n||{};this._p={}, this.result=new Promise(function(t,e){this._p._resolve=t, this._p._reject=e;}.bind(this)), this.callbacks={}, this.plainMsg=this._handleMsg(n), this._eventsHandle={}, this._timeoutTimer=null, this._initTimeout(), this.isFinish=!1;};l.prototype._initTimeout=function(){this._clearTimeout(), this.option.timeout>0&&(this._timeoutTimer=setTimeout(function(){this.receiveEvent(s.TIMEOUT), this.receiveResponse(a,!0);}.bind(this),this.option.timeout));}, l.prototype._clearTimeout=function(){clearTimeout(this._timeoutTimer);}, l.prototype._handleMsg=function(t){var e={};return Object.keys(t).forEach(function(n){var o=t[n];"function"==typeof o&&"on"===n.slice(0,2)?this.callbacks[n]=o:e[n]=r(o);}.bind(this)), e}, l.prototype.getPayload=function(){return{msgId:this.id,containerId:this.containerId,methodName:this.methodName,body:this.plainMsg,type:"request"}}, l.prototype.receiveEvent=function(t,e){if(this.isFinish&&t!==s.FINISH)return!1;t!==s.FINISH&&t!==s.TIMEOUT&&this._initTimeout(), Array.isArray(this._eventsHandle[t])&&this._eventsHandle[t].forEach(function(t){try{t(e);}catch(t){console.error(e);}});var n="on"+t.charAt(0).toUpperCase()+t.slice(1);return this.callbacks[n]&&this.callbacks[n](e), !0}, l.prototype.addEventListener=function(t,e){if(!t||"function"!=typeof e)throw"eventName is null or handle is not a function, addEventListener fail";Array.isArray(this._eventsHandle[t])||(this._eventsHandle[t]=[]), this._eventsHandle[t].push(e);}, l.prototype.removeEventListener=function(t,e){if(!t||!e)throw"eventName is null or handle is null, invoke removeEventListener fail";if(Array.isArray(this._eventsHandle[t])){var n=this._eventsHandle[t].indexOf(e);-1!==n&&this._eventsHandle[t].splice(n,1);}}, l.prototype.receiveResponse=function(t,e){if(!0===this.isFinish)return!1;this._clearTimeout();var e=!!e;return e?this._p._reject(t):this._p._resolve(t), setTimeout(function(){this.receiveEvent(s.FINISH);}.bind(this),0), this.isFinish=!0, !0}, t.exports=l;},204:function(t,e,n){var r=function(t,e,n){if(this._msgId=n.msgId, this.frameWindow=t, this.methodName=n.methodName, this.clientOrigin=e, this.containerId=n.containerId, this.params=n.body, !this._msgId)throw"msgId not exist";if(!this.frameWindow)throw"frameWindow not exist";if(!this.methodName)throw"methodName not exits";if(!this.clientOrigin)throw"clientOrigin not exist";this.hasResponded=!1;};r.prototype.respond=function(t,e){var e=!!e;if(!0!==this.hasResponded){var n={type:"response",success:!e,body:t,msgId:this._msgId};this.frameWindow.postMessage(n,this.clientOrigin), this.hasResponded=!0;}}, r.prototype.emit=function(t,e){var n={type:"event",eventName:t,body:e,msgId:this._msgId};this.frameWindow.postMessage(n,this.clientOrigin);}, t.exports=r;},205:function(t,e,n){t.exports={SYS_EVENT:"SYS_openAPIContainerInitEvent",SYS_INIT:"SYS_openAPIContainerInit"};},4:function(t,e){var n;n=function(){return this}();try{n=n||Function("return this")()||(eval)("this");}catch(t){"object"==typeof window&&(n=window);}t.exports=n;},714:function(t,e,n){(function(t,n){function r(t,e){return t.set(e[0],e[1]), t}function o(t,e){return t.add(e), t}function i(t,e){for(var n=-1,r=t.length;++n<r&&!1!==e(t[n],n,t););return t}function u(t,e){for(var n=-1,r=e.length,o=t.length;++n<r;)t[o+n]=e[n];return t}function c(t,e,n,r){var o=-1,i=t.length;for(r&&i&&(n=t[++o]);++o<i;)n=e(n,t[o],o,t);return n}function a(t,e){for(var n=-1,r=Array(t);++n<t;)r[n]=e(n);return r}function s(t){return t&&t.Object===Object?t:null}function f(t){var e=!1;if(null!=t&&"function"!=typeof t.toString)try{e=!!(t+"");}catch(t){}return e}function l(t){var e=-1,n=Array(t.size);return t.forEach(function(t,r){n[++e]=[r,t];}), n}function p(t){var e=-1,n=Array(t.size);return t.forEach(function(t){n[++e]=t;}), n}function h(t){var e=-1,n=t?t.length:0;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1]);}}function d(){this.__data__=ke?ke(null):{};}function v(t){return this.has(t)&&delete this.__data__[t]}function y(t){var e=this.__data__;if(ke){var n=e[t];return n===St?void 0:n}return ye.call(e,t)?e[t]:void 0}function _(t){var e=this.__data__;return ke?void 0!==e[t]:ye.call(e,t)}function b(t,e){return this.__data__[t]=ke&&void 0===e?St:e, this}function g(t){var e=-1,n=t?t.length:0;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1]);}}function m(){this.__data__=[];}function j(t){var e=this.__data__,n=W(e,t);return!(n<0||(n==e.length-1?e.pop():xe.call(e,n,1), 0))}function w(t){var e=this.__data__,n=W(e,t);return n<0?void 0:e[n][1]}function I(t){return W(this.__data__,t)>-1}function O(t,e){var n=this.__data__,r=W(n,t);return r<0?n.push([t,e]):n[r][1]=e, this}function x(t){var e=-1,n=t?t.length:0;for(this.clear();++e<n;){var r=t[e];this.set(r[0],r[1]);}}function A(){this.__data__={hash:new h,map:new(Me||g),string:new h};}function E(t){return rt(this,t).delete(t)}function S(t){return rt(this,t).get(t)}function M(t){return rt(this,t).has(t)}function N(t,e){return rt(this,t).set(t,e), this}function P(t){this.__data__=new g(t);}function T(){this.__data__=new g;}function k(t){return this.__data__.delete(t)}function F(t){return this.__data__.get(t)}function H(t){return this.__data__.has(t)}function L(t,e){var n=this.__data__;return n instanceof g&&n.__data__.length==Et&&(n=this.__data__=new x(n.__data__)), n.set(t,e), this}function $(t,e,n){var r=t[e];ye.call(t,e)&&yt(r,n)&&(void 0!==n||e in t)||(t[e]=n);}function W(t,e){for(var n=t.length;n--;)if(yt(t[n][0],e))return n;return-1}function U(t,e){return t&&tt(e,At(e),t)}function R(t,e,n,r,o,u,c){var a;if(r&&(a=u?r(t,o,u,c):r(t)), void 0!==a)return a;if(!wt(t))return t;var s=Ye(t);if(s){if(a=at(t), !e)return Z(t,a)}else{var l=ct(t),p=l==kt||l==Ft;if(Ce(t))return D(t,e);if(l==$t||l==Nt||p&&!u){if(f(t))return u?t:{};if(a=st(p?{}:t), !e)return et(t,U(a,t))}else{if(!re[l])return u?t:{};a=ft(t,l,R,e);}}c||(c=new P);var h=c.get(t);if(h)return h;if(c.set(t,a), !s)var d=n?nt(t):At(t);return i(d||t,function(o,i){d&&(i=o, o=t[i]), $(a,i,R(o,e,n,r,i,t,c));}), a}function B(t){return wt(t)?Ie(t):{}}function Y(t,e,n){var r=e(t);return Ye(t)?r:u(r,n(t))}function C(t,e){return ye.call(t,e)||"object"==typeof t&&e in t&&null===it(t)}function V(t){return Ee(Object(t))}function D(t,e){if(e)return t.slice();var n=new t.constructor(t.length);return t.copy(n), n}function G(t){var e=new t.constructor(t.byteLength);return new je(e).set(new je(t)), e}function q(t,e){var n=e?G(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.byteLength)}function z(t,e,n){return c(e?n(l(t),!0):l(t),r,new t.constructor)}function J(t){var e=new t.constructor(t.source,te.exec(t));return e.lastIndex=t.lastIndex, e}function K(t,e,n){return c(e?n(p(t),!0):p(t),o,new t.constructor)}function Q(t){return Re?Object(Re.call(t)):{}}function X(t,e){var n=e?G(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}function Z(t,e){var n=-1,r=t.length;for(e||(e=Array(r));++n<r;)e[n]=t[n];return e}function tt(t,e,n,r){n||(n={});for(var o=-1,i=e.length;++o<i;){var u=e[o];$(n,u,r?r(n[u],t[u],u,n,t):t[u]);}return n}function et(t,e){return tt(t,ut(t),e)}function nt(t){return Y(t,At,ut)}function rt(t,e){var n=t.__data__;return ht(e)?n["string"==typeof e?"string":"hash"]:n.map}function ot(t,e){var n=t[e];return Ot(n)?n:void 0}function it(t){return Ae(Object(t))}function ut(t){return we(Object(t))}function ct(t){return _e.call(t)}function at(t){var e=t.length,n=t.constructor(e);return e&&"string"==typeof t[0]&&ye.call(t,"index")&&(n.index=t.index, n.input=t.input), n}function st(t){return"function"!=typeof t.constructor||dt(t)?{}:B(it(t))}function ft(t,e,n,r){var o=t.constructor;switch(e){case Yt:return G(t);case Pt:case Tt:return new o(+t);case Ct:return q(t,r);case Vt:case Dt:case Gt:case qt:case zt:case Jt:case Kt:case Qt:case Xt:return X(t,r);case Ht:return z(t,r,n);case Lt:case Rt:return new o(t);case Wt:return J(t);case Ut:return K(t,r,n);case Bt:return Q(t)}}function lt(t){var e=t?t.length:void 0;return jt(e)&&(Ye(t)||xt(t)||_t(t))?a(e,String):null}function pt(t,e){return!!(e=null==e?Mt:e)&&("number"==typeof t||ne.test(t))&&t>-1&&t%1==0&&t<e}function ht(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}function dt(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||de)}function vt(t){if(null!=t){try{return ve.call(t)}catch(t){}try{return t+""}catch(t){}}return""}function yt(t,e){return t===e||t!==t&&e!==e}function _t(t){return gt(t)&&ye.call(t,"callee")&&(!Oe.call(t,"callee")||_e.call(t)==Nt)}function bt(t){return null!=t&&jt(Be(t))&&!mt(t)}function gt(t){return It(t)&&bt(t)}function mt(t){var e=wt(t)?_e.call(t):"";return e==kt||e==Ft}function jt(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=Mt}function wt(t){var e=typeof t;return!!t&&("object"==e||"function"==e)}function It(t){return!!t&&"object"==typeof t}function Ot(t){return!!wt(t)&&(mt(t)||f(t)?be:ee).test(vt(t))}function xt(t){return"string"==typeof t||!Ye(t)&&It(t)&&_e.call(t)==Rt}function At(t){var e=dt(t);if(!e&&!bt(t))return V(t);var n=lt(t),r=!!n,o=n||[],i=o.length;for(var u in t)!C(t,u)||r&&("length"==u||pt(u,i))||e&&"constructor"==u||o.push(u);return o}var Et=200,St="__lodash_hash_undefined__",Mt=9007199254740991,Nt="[object Arguments]",Pt="[object Boolean]",Tt="[object Date]",kt="[object Function]",Ft="[object GeneratorFunction]",Ht="[object Map]",Lt="[object Number]",$t="[object Object]",Wt="[object RegExp]",Ut="[object Set]",Rt="[object String]",Bt="[object Symbol]",Yt="[object ArrayBuffer]",Ct="[object DataView]",Vt="[object Float32Array]",Dt="[object Float64Array]",Gt="[object Int8Array]",qt="[object Int16Array]",zt="[object Int32Array]",Jt="[object Uint8Array]",Kt="[object Uint8ClampedArray]",Qt="[object Uint16Array]",Xt="[object Uint32Array]",Zt=/[\\^$.*+?()[\]{}|]/g,te=/\w*$/,ee=/^\[object .+?Constructor\]$/,ne=/^(?:0|[1-9]\d*)$/,re={};re[Nt]=re["[object Array]"]=re[Yt]=re[Ct]=re[Pt]=re[Tt]=re[Vt]=re[Dt]=re[Gt]=re[qt]=re[zt]=re[Ht]=re[Lt]=re[$t]=re[Wt]=re[Ut]=re[Rt]=re[Bt]=re[Jt]=re[Kt]=re[Qt]=re[Xt]=!0, re["[object Error]"]=re[kt]=re["[object WeakMap]"]=!1;var oe={function:!0,object:!0},ie=oe[typeof e]&&e&&!e.nodeType?e:void 0,ue=oe[typeof t]&&t&&!t.nodeType?t:void 0,ce=ue&&ue.exports===ie?ie:void 0,ae=s(ie&&ue&&"object"==typeof n&&n),se=s(oe[typeof self]&&self),fe=s(oe[typeof window]&&window),le=s(oe[typeof this]&&this),pe=ae||fe!==(le&&le.window)&&fe||se||le||Function("return this")(),he=Array.prototype,de=Object.prototype,ve=Function.prototype.toString,ye=de.hasOwnProperty,_e=de.toString,be=RegExp("^"+ve.call(ye).replace(Zt,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),ge=ce?pe.Buffer:void 0,me=pe.Symbol,je=pe.Uint8Array,we=Object.getOwnPropertySymbols,Ie=Object.create,Oe=de.propertyIsEnumerable,xe=he.splice,Ae=Object.getPrototypeOf,Ee=Object.keys,Se=ot(pe,"DataView"),Me=ot(pe,"Map"),Ne=ot(pe,"Promise"),Pe=ot(pe,"Set"),Te=ot(pe,"WeakMap"),ke=ot(Object,"create"),Fe=vt(Se),He=vt(Me),Le=vt(Ne),$e=vt(Pe),We=vt(Te),Ue=me?me.prototype:void 0,Re=Ue?Ue.valueOf:void 0;h.prototype.clear=d, h.prototype.delete=v, h.prototype.get=y, h.prototype.has=_, h.prototype.set=b, g.prototype.clear=m, g.prototype.delete=j, g.prototype.get=w, g.prototype.has=I, g.prototype.set=O, x.prototype.clear=A, x.prototype.delete=E, x.prototype.get=S, x.prototype.has=M, x.prototype.set=N, P.prototype.clear=T, P.prototype.delete=k, P.prototype.get=F, P.prototype.has=H, P.prototype.set=L;var Be=function(t){return function(t){return null==t?void 0:t.length}}();we||(ut=function(){return[]}), (Se&&ct(new Se(new ArrayBuffer(1)))!=Ct||Me&&ct(new Me)!=Ht||Ne&&"[object Promise]"!=ct(Ne.resolve())||Pe&&ct(new Pe)!=Ut||Te&&"[object WeakMap]"!=ct(new Te))&&(ct=function(t){var e=_e.call(t),n=e==$t?t.constructor:void 0,r=n?vt(n):void 0;if(r)switch(r){case Fe:return Ct;case He:return Ht;case Le:return"[object Promise]";case $e:return Ut;case We:return"[object WeakMap]"}return e});var Ye=Array.isArray,Ce=ge?function(t){return t instanceof ge}:function(t){return function(){return!1}}();t.exports=R;}).call(e,n(719)(t),n(4));},715:function(t,e,n){function r(t,e,n){var r=t[e];m.call(t,e)&&a(r,n)&&(void 0!==n||e in t)||(t[e]=n);}function o(t,e,n,o){n||(n={});for(var i=-1,u=e.length;++i<u;){var c=e[i];r(n,c,o?o(n[c],t[c],c,n,t):t[c]);}return n}function i(t,e){return!!(e=null==e?v:e)&&("number"==typeof t||b.test(t))&&t>-1&&t%1==0&&t<e}function u(t,e,n){if(!p(n))return!1;var r=typeof e;return!!("number"==r?s(n)&&i(e,n.length):"string"==r&&e in n)&&a(n[e],t)}function c(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||g)}function a(t,e){return t===e||t!==t&&e!==e}function s(t){return null!=t&&l(O(t))&&!f(t)}function f(t){var e=p(t)?j.call(t):"";return e==y||e==_}function l(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=v}function p(t){var e=typeof t;return!!t&&("object"==e||"function"==e)}var h=n(717),d=n(718),v=9007199254740991,y="[object Function]",_="[object GeneratorFunction]",b=/^(?:0|[1-9]\d*)$/,g=Object.prototype,m=g.hasOwnProperty,j=g.toString,w=g.propertyIsEnumerable,I=!w.call({valueOf:1},"valueOf"),O=function(t){return function(t){return null==t?void 0:t.length}}(),x=function(t){return d(function(e,n){var r=-1,o=n.length,i=o>1?n[o-1]:void 0,c=o>2?n[2]:void 0;for(i=t.length>3&&"function"==typeof i?(o--, i):void 0, c&&u(n[0],n[1],c)&&(i=o<3?void 0:i, o=1), e=Object(e);++r<o;){var a=n[r];a&&t(e,a);}return e})}(function(t,e){if(I||c(e)||s(e))return void o(e,h(e),t);for(var n in e)m.call(e,n)&&r(t,n,e[n]);});t.exports=x;},716:function(t,e,n){function r(t){return o(t,!0,!0)}var o=n(714);t.exports=r;},717:function(t,e){function n(t,e){for(var n=-1,r=Array(t);++n<t;)r[n]=e(n);return r}function r(t,e){var r=x(t)||c(t)?n(t.length,String):[],o=r.length,u=!!o;for(var a in t)!e&&!j.call(t,a)||u&&("length"==a||i(a,o))||r.push(a);return r}function o(t){if(!u(t))return O(t);var e=[];for(var n in Object(t))j.call(t,n)&&"constructor"!=n&&e.push(n);return e}function i(t,e){return!!(e=null==e?v:e)&&("number"==typeof t||g.test(t))&&t>-1&&t%1==0&&t<e}function u(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||m)}function c(t){return s(t)&&j.call(t,"callee")&&(!I.call(t,"callee")||w.call(t)==y)}function a(t){return null!=t&&l(t.length)&&!f(t)}function s(t){return h(t)&&a(t)}function f(t){var e=p(t)?w.call(t):"";return e==_||e==b}function l(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=v}function p(t){var e=typeof t;return!!t&&("object"==e||"function"==e)}function h(t){return!!t&&"object"==typeof t}function d(t){return a(t)?r(t):o(t)}var v=9007199254740991,y="[object Arguments]",_="[object Function]",b="[object GeneratorFunction]",g=/^(?:0|[1-9]\d*)$/,m=Object.prototype,j=m.hasOwnProperty,w=m.toString,I=m.propertyIsEnumerable,O=function(t,e){return function(n){return t(e(n))}}(Object.keys,Object),x=Array.isArray;t.exports=d;},718:function(t,e){function n(t,e,n){switch(n.length){case 0:return t.call(e);case 1:return t.call(e,n[0]);case 2:return t.call(e,n[0],n[1]);case 3:return t.call(e,n[0],n[1],n[2])}return t.apply(e,n)}function r(t,e){return e=I(void 0===e?t.length-1:e,0), function(){for(var r=arguments,o=-1,i=I(r.length-e,0),u=Array(i);++o<i;)u[o]=r[e+o];o=-1;for(var c=Array(e+1);++o<e;)c[o]=r[o];return c[e]=u, n(t,this,c)}}function o(t,e){if("function"!=typeof t)throw new TypeError(l);return e=void 0===e?e:s(e), r(t,e)}function i(t){var e=typeof t;return!!t&&("object"==e||"function"==e)}function u(t){return!!t&&"object"==typeof t}function c(t){return"symbol"==typeof t||u(t)&&w.call(t)==v}function a(t){return t?(t=f(t))===p||t===-p?(t<0?-1:1)*h:t===t?t:0:0===t?t:0}function s(t){var e=a(t),n=e%1;return e===e?n?e-n:e:0}function f(t){if("number"==typeof t)return t;if(c(t))return d;if(i(t)){var e="function"==typeof t.valueOf?t.valueOf():t;t=i(e)?e+"":e;}if("string"!=typeof t)return 0===t?t:+t;t=t.replace(y,"");var n=b.test(t);return n||g.test(t)?m(t.slice(2),n?2:8):_.test(t)?d:+t}var l="Expected a function",p=1/0,h=1.7976931348623157e308,d=NaN,v="[object Symbol]",y=/^\s+|\s+$/g,_=/^[-+]0x[0-9a-f]+$/i,b=/^0b[01]+$/i,g=/^0o[0-7]+$/i,m=parseInt,j=Object.prototype,w=j.toString,I=Math.max;t.exports=o;},719:function(t,e){t.exports=function(t){return t.webpackPolyfill||(t.deprecate=function(){}, t.paths=[], t.children||(t.children=[]), Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}), Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}), t.webpackPolyfill=1), t};},721:function(t,e,n){t.exports=n(199);}})});
});

unwrapExports(frameTalkClientPc);
var frameTalkClientPc_1 = frameTalkClientPc.dd;

var h5Pc = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.h5PcBridgeInit=void 0, exports.h5PcBridgeInit=function(){return Promise.resolve(frameTalkClientPc)};var h5PcBridge=function(e,n){return new Promise(function(r,t){return frameTalkClientPc.invokeAPI(e,n).result.then(function(e){return"function"==typeof n.onSuccess&&n.onSuccess.call(null,e), r(e)},function(e){return"function"==typeof n.onFail&&n.onFail.call(null,e), t(e)})})};exports.default=h5PcBridge;
});

unwrapExports(h5Pc);
var h5Pc_1 = h5Pc.h5PcBridgeInit;

var eapp = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});var eappBridge=function(e,n){return new Promise(function(o,t){dd.dtBridge({m:e,args:n,onSuccess:function(e){"function"==typeof n.onSuccess&&n.onSuccess(e), o(e);},onFail:function(e){"function"==typeof n.onFail&&n.onFail(e), t(e);}});})};exports.default=eappBridge;
});

unwrapExports(eapp);

var h5PcEvent = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.off=exports.on=void 0, exports.on=function(e,t){frameTalkClientPc.addEventListener(e,t);}, exports.off=function(e,t){frameTalkClientPc.removeEventListener(e,t);};
});

unwrapExports(h5PcEvent);
var h5PcEvent_1 = h5PcEvent.off;
var h5PcEvent_2 = h5PcEvent.on;

var pc = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});ddSdk.ddSdk.setPlatform({platform:env.ENV_ENUM.pc,bridgeInit:function(){switch(env.getENV().appType){case sdk.APP_TYPE.MINI_APP:return Promise.resolve(eapp.default);default:return h5Pc.h5PcBridgeInit().then(function(){return h5Pc.default})}},authMethod:"config",authParamsDeal:function(e){var r=Object.assign({},e);return r.url=window.location.href.split("#")[0], r},event:{on:function(e,r){if(env.getENV().appType===sdk.APP_TYPE.WEB)return h5PcEvent.on(e,r)},off:function(e,r){if(env.getENV().appType===sdk.APP_TYPE.WEB)return h5PcEvent.off(e,r)}}});
});

unwrapExports(pc);

var webviewInMiniApp = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});var noop=function(){},webviewInMiniappBridge=function(e,n){return new Promise(function(r,i){var o=n.onSuccess||noop,a=n.onFail||noop;if(delete n.onSuccess, delete n.onFail, AlipayJSBridge){var p=e.split("."),l=p.pop()||"",t=p.join(".");AlipayJSBridge.call.apply(null,["webDdExec",{serviceName:t,actionName:l,args:n},function(e){var n={},p=e.content;if(p)try{n=JSON.parse(p);}catch(e){console.error("parse dt api result error",p,e);}e.success?(o.apply(null,[n]), r(n)):(a.apply(null,[n]), i(n));}]);}else{var c=new Error("Fatal error, cannot find bridge ,current env is WebView in MiniApp");a(c), i(c);}})};exports.default=webviewInMiniappBridge;
});

unwrapExports(webviewInMiniApp);

var h5Android = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.h5AndroidbridgeInit=void 0;var h5BridgeReadyPromise;exports.h5AndroidbridgeInit=function(){return h5BridgeReadyPromise||(h5BridgeReadyPromise=new Promise(function(i,e){var n=function(){try{window.WebViewJavascriptBridgeAndroid=window.nuva&&window.nuva.require(), i();}catch(i){e(i);}};window.nuva&&(void 0===window.nuva.isReady||window.nuva.isReady)?n():document.addEventListener("runtimeready",function(){n();},!1);})), h5BridgeReadyPromise};var h5AndroidBridge=function(i,e){return h5BridgeReadyPromise||(h5BridgeReadyPromise=exports.h5AndroidbridgeInit()), h5BridgeReadyPromise.then(function(){return new Promise(function(n,r){var d=i.split("."),o=d.pop()||"",t=d.join("."),a=function(i){"function"==typeof e.onSuccess&&e.onSuccess(i), n(i);},u=function(i){"function"==typeof e.onFail&&e.onFail(i), r(i);};"function"==typeof window.WebViewJavascriptBridgeAndroid&&window.WebViewJavascriptBridgeAndroid(a,u,t,o,e);})})};exports.default=h5AndroidBridge;
});

unwrapExports(h5Android);
var h5Android_1 = h5Android.h5AndroidbridgeInit;

var weex_1 = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.androidWeexBridge=exports.iosWeexBridge=exports.requireModule=void 0;var STATUS_NO_RESULT=0,STATUS_OK=1,STATUS_ERROR=2,WEEX_IOS_BIZ_SUCCESS_CODE="0";exports.requireModule=function(e){return"undefined"!=typeof __weex_require__?__weex_require__("@weex-module/"+e):"undefined"!=typeof weex?weex.requireModule(e):void 0}, exports.iosWeexBridge=function(){return Promise.resolve(function(e,o){return new Promise(function(r,n){var s=exports.requireModule("nuvajs-exec"),t=e.split("."),i=t.pop(),_=t.join(".");s.exec({plugin:_,action:i,args:o},function(e){e&&e.errorCode===WEEX_IOS_BIZ_SUCCESS_CODE?("function"==typeof o.onSuccess&&o.onSuccess(e.result), r(e.result)):("function"==typeof o.onFail&&o.onFail(e.result), n(e.result));});})})}, exports.androidWeexBridge=function(){return Promise.resolve(function(e,o){return new Promise(function(r,n){var s=exports.requireModule("nuvajs-exec"),t=e.split("."),i=t.pop(),_=t.join(".");s.exec({plugin:_,action:i,args:o},function(e){var s={};try{if(e&&e.__message__)if("object"==typeof e.__message__)s=e.__message__;else try{s=JSON.parse(e.__message__);}catch(o){"string"==typeof e.__message__&&(s=e.__message__);}}catch(e){}e&&parseInt(e.__status__+"",10)===STATUS_OK?("function"==typeof o.onSuccess&&o.onSuccess(s), r(s)):("function"==typeof o.onFail&&o.onFail(s), n(s));});})})};
});

unwrapExports(weex_1);
var weex_2 = weex_1.androidWeexBridge;
var weex_3 = weex_1.iosWeexBridge;
var weex_4 = weex_1.requireModule;

var h5Event = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.off=exports.on=void 0, exports.on=function(e,o){document.addEventListener(e,o);}, exports.off=function(e,o){document.removeEventListener(e,o);};
});

unwrapExports(h5Event);
var h5Event_1 = h5Event.off;
var h5Event_2 = h5Event.on;

var weexEvent = createCommonjsModule(function (module, exports) {
var _this=commonjsGlobal;Object.defineProperty(exports,"__esModule",{value:!0}), exports.off=exports.on=void 0;exports.on=function(e,t){weex_1.requireModule("globalEvent").addEventListener(e,function(e){var r={preventDefault:function(){throw new Error("does not support preventDefault")},detail:e};t.call(_this,r);});}, exports.off=function(e,t){weex_1.requireModule("globalEvent").removeEventListener(e,t);};
});

unwrapExports(weexEvent);
var weexEvent_1 = weexEvent.off;
var weexEvent_2 = weexEvent.on;

var android = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});ddSdk.ddSdk.setPlatform({platform:env.ENV_ENUM.android,bridgeInit:function(){var e=env.getENV();return e.appType===sdk.APP_TYPE.MINI_APP?Promise.resolve(eapp.default):e.appType===sdk.APP_TYPE.WEBVIEW_IN_MINIAPP?Promise.resolve(webviewInMiniApp.default):e.appType===sdk.APP_TYPE.WEEX?weex_1.androidWeexBridge():h5Android.h5AndroidbridgeInit().then(function(){return h5Android.default})},authMethod:"runtime.permission.requestJsApis",event:{on:function(e,r){var i=env.getENV();switch(i.appType){case sdk.APP_TYPE.WEB:case sdk.APP_TYPE.WEBVIEW_IN_MINIAPP:h5Event.on(e,r);break;case sdk.APP_TYPE.WEEX:weexEvent.on(e,r);break;default:throw new Error("Not support global event in the platfrom: "+i.appType)}},off:function(e,r){var i=env.getENV();switch(i.appType){case sdk.APP_TYPE.WEB:case sdk.APP_TYPE.WEBVIEW_IN_MINIAPP:h5Event.off(e,r);break;case sdk.APP_TYPE.WEEX:weexEvent.off(e,r);break;default:throw new Error("Not support global event in the platfrom: "+i.appType)}}}});
});

unwrapExports(android);

var h5Ios = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.h5IosBridgeInit=void 0;var h5BridgeReadyPromise;exports.h5IosBridgeInit=function(){return h5BridgeReadyPromise||(h5BridgeReadyPromise=new Promise(function(e,r){if("undefined"!=typeof WebViewJavascriptBridge){try{WebViewJavascriptBridge.init(function(e,r){});}catch(e){return r()}return e()}document.addEventListener("WebViewJavascriptBridgeReady",function(){if("undefined"==typeof WebViewJavascriptBridge)return r();try{WebViewJavascriptBridge.init(function(e,r){});}catch(e){return r()}return e()},!1);})), h5BridgeReadyPromise};var h5IosBridge=function(e,r){return h5BridgeReadyPromise||(h5BridgeReadyPromise=exports.h5IosBridgeInit()), h5BridgeReadyPromise.then(function(){var i=Object.assign({},r);return new Promise(function(r,n){if(!0===i.watch){var t=i.onSuccess;delete i.onSuccess, "undefined"!=typeof WebViewJavascriptBridge&&WebViewJavascriptBridge.registerHandler(e,function(e,r){"function"==typeof t&&t.call(null,e), r&&r({errorCode:"0",errorMessage:"success"});});}void 0!==window.WebViewJavascriptBridge&&window.WebViewJavascriptBridge.callHandler(e,Object.assign({},i),function(e){var t=e||{};"0"===t.errorCode?("function"==typeof i.onSuccess&&i.onSuccess.call(null,t.result), r(t.result)):("-1"===t.errorCode&&"function"==typeof i.onCancel?i.onCancel.call(null,t.result,t.errorCode):"function"==typeof i.onFail&&i.onFail.call(null,t.result,t.errorCode), n(t.result));});})})};exports.default=h5IosBridge;
});

unwrapExports(h5Ios);
var h5Ios_1 = h5Ios.h5IosBridgeInit;

var ios = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});ddSdk.ddSdk.setPlatform({platform:env.ENV_ENUM.ios,bridgeInit:function(){var e=env.getENV();return e.appType===sdk.APP_TYPE.MINI_APP?Promise.resolve(eapp.default):e.appType===sdk.APP_TYPE.WEBVIEW_IN_MINIAPP?Promise.resolve(webviewInMiniApp.default):e.appType===sdk.APP_TYPE.WEEX?weex_1.iosWeexBridge():h5Ios.h5IosBridgeInit().then(function(){return h5Ios.default})},authMethod:"runtime.permission.requestJsApis",event:{on:function(e,r){var i=env.getENV();switch(i.appType){case sdk.APP_TYPE.WEB:case sdk.APP_TYPE.WEBVIEW_IN_MINIAPP:h5Event.on(e,r);break;case sdk.APP_TYPE.WEEX:weexEvent.on(e,r);break;default:throw new Error("Not support global event in the platfrom: "+i.appType)}},off:function(e,r){var i=env.getENV();switch(i.appType){case sdk.APP_TYPE.WEB:case sdk.APP_TYPE.WEBVIEW_IN_MINIAPP:h5Event.off(e,r);break;case sdk.APP_TYPE.WEEX:weexEvent.off(e,r);break;default:throw new Error("Not support global event in the platfrom: "+i.appType)}}}});
});

unwrapExports(ios);

var platform = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), ios;
});

unwrapExports(platform);

var union = createCommonjsModule(function (module) {
module.exports=core_1;
});

var beaconPicker = createCommonjsModule(function (module, exports) {
function beaconPicker$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.beaconPicker$=void 0;var apiName="biz.ATMBle.beaconPicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"5.0.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"5.0.7"}, _a)), exports.beaconPicker$=beaconPicker$, exports.default=beaconPicker$;
});

unwrapExports(beaconPicker);
var beaconPicker_1 = beaconPicker.beaconPicker$;

var faceManager = createCommonjsModule(function (module, exports) {
function faceManager$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.faceManager$=void 0;var apiName="biz.ATMBle.faceManager";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"5.0.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"5.0.7"}, _a)), exports.faceManager$=faceManager$, exports.default=faceManager$;
});

unwrapExports(faceManager);
var faceManager_1 = faceManager.faceManager$;

var punchModePicker = createCommonjsModule(function (module, exports) {
function punchModePicker$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.punchModePicker$=void 0;var apiName="biz.ATMBle.punchModePicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"5.0.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"5.0.7"}, _a)), exports.punchModePicker$=punchModePicker$, exports.default=punchModePicker$;
});

unwrapExports(punchModePicker);
var punchModePicker_1 = punchModePicker.punchModePicker$;

var pay = createCommonjsModule(function (module, exports) {
function pay$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.pay$=void 0;var apiName="biz.alipay.pay";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.pay$=pay$, exports.default=pay$;
});

unwrapExports(pay);
var pay_1 = pay.pay$;

var apiHelper = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.genBizStoreParamsDealFn=exports.genBoolResultDealFn=exports.forceChangeParamsDealFn=exports.genDefaultParamsDealFn=exports.addDefaultCorpIdParamsDeal=exports.addWatchParamsDeal=void 0, exports.addWatchParamsDeal=function(e){var a=Object.assign({},e);return a.watch=!0, a}, exports.addDefaultCorpIdParamsDeal=function(e){var a=Object.assign({},e);return a.corpId="corpId", a}, exports.genDefaultParamsDealFn=function(e){var a=Object.assign({},e);return function(e){return Object.assign({},a,e)}}, exports.forceChangeParamsDealFn=function(e){var a=Object.assign({},e);return function(e){return Object.assign(e,a)}}, exports.genBoolResultDealFn=function(e){return function(a){var r=Object.assign({},a);return e.forEach(function(e){void 0!==r[e]&&(r[e]=!!r[e]);}), r}}, exports.genBizStoreParamsDealFn=function(e){var a=Object.assign({},e);return"string"!=typeof a.params?(a.params=JSON.stringify(a), a):a};
});

unwrapExports(apiHelper);
var apiHelper_1 = apiHelper.genBizStoreParamsDealFn;
var apiHelper_2 = apiHelper.genBoolResultDealFn;
var apiHelper_3 = apiHelper.forceChangeParamsDealFn;
var apiHelper_4 = apiHelper.genDefaultParamsDealFn;
var apiHelper_5 = apiHelper.addDefaultCorpIdParamsDeal;
var apiHelper_6 = apiHelper.addWatchParamsDeal;

var chooseDateTime = createCommonjsModule(function (module, exports) {
function chooseDateTime$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseDateTime$=void 0;var apiName="biz.calendar.chooseDateTime";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a)), exports.chooseDateTime$=chooseDateTime$, exports.default=chooseDateTime$;
});

unwrapExports(chooseDateTime);
var chooseDateTime_1 = chooseDateTime.chooseDateTime$;

var chooseHalfDay = createCommonjsModule(function (module, exports) {
function chooseHalfDay$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseHalfDay$=void 0;var apiName="biz.calendar.chooseHalfDay";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a)), exports.chooseHalfDay$=chooseHalfDay$, exports.default=chooseHalfDay$;
});

unwrapExports(chooseHalfDay);
var chooseHalfDay_1 = chooseHalfDay.chooseHalfDay$;

var chooseInterval = createCommonjsModule(function (module, exports) {
function chooseInterval$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseInterval$=void 0;var apiName="biz.calendar.chooseInterval";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a)), exports.chooseInterval$=chooseInterval$, exports.default=chooseInterval$;
});

unwrapExports(chooseInterval);
var chooseInterval_1 = chooseInterval.chooseInterval$;

var chooseOneDay = createCommonjsModule(function (module, exports) {
function chooseOneDay$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseOneDay$=void 0;var apiName="biz.calendar.chooseOneDay";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.0",paramsDeal:apiHelper.addDefaultCorpIdParamsDeal}, _a)), exports.chooseOneDay$=chooseOneDay$, exports.default=chooseOneDay$;
});

unwrapExports(chooseOneDay);
var chooseOneDay_1 = chooseOneDay.chooseOneDay$;

var chooseConversationByCorpId = createCommonjsModule(function (module, exports) {
function chooseConversationByCorpId$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseConversationByCorpId$=void 0;var apiName="biz.chat.chooseConversationByCorpId",paramsDeal=apiHelper.genDefaultParamsDealFn({max:50});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.7.11",paramsDeal:paramsDeal}, _a)), exports.chooseConversationByCorpId$=chooseConversationByCorpId$, exports.default=chooseConversationByCorpId$;
});

unwrapExports(chooseConversationByCorpId);
var chooseConversationByCorpId_1 = chooseConversationByCorpId.chooseConversationByCorpId$;

var collectSticker = createCommonjsModule(function (module, exports) {
function collectSticker$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.collectSticker$=void 0;var apiName="biz.chat.collectSticker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.25"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.25"}, _a)), exports.collectSticker$=collectSticker$, exports.default=collectSticker$;
});

unwrapExports(collectSticker);
var collectSticker_1 = collectSticker.collectSticker$;

var createSceneGroup = createCommonjsModule(function (module, exports) {
function createSceneGroup$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.createSceneGroup$=void 0;var apiName="biz.chat.createSceneGroup";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.7.17"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.7.17"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.7.17"}, _a)), exports.createSceneGroup$=createSceneGroup$, exports.default=createSceneGroup$;
});

unwrapExports(createSceneGroup);
var createSceneGroup_1 = createSceneGroup.createSceneGroup$;

var getRealmCid = createCommonjsModule(function (module, exports) {
function getRealmCid$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getRealmCid$=void 0;var apiName="biz.chat.getRealmCid";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.7.12"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.7.12"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.7.12"}, _a)), exports.getRealmCid$=getRealmCid$, exports.default=getRealmCid$;
});

unwrapExports(getRealmCid);
var getRealmCid_1 = getRealmCid.getRealmCid$;

var locationChatMessage = createCommonjsModule(function (module, exports) {
function locationChatMessage$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.locationChatMessage$=void 0;var apiName="biz.chat.locationChatMessage";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.6"}, _a)), exports.locationChatMessage$=locationChatMessage$, exports.default=locationChatMessage$;
});

unwrapExports(locationChatMessage);
var locationChatMessage_1 = locationChatMessage.locationChatMessage$;

var openSingleChat = createCommonjsModule(function (module, exports) {
function openSingleChat$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openSingleChat$=void 0;var apiName="biz.chat.openSingleChat";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.4.10"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.4.10"}, _a)), exports.openSingleChat$=openSingleChat$, exports.default=openSingleChat$;
});

unwrapExports(openSingleChat);
var openSingleChat_1 = openSingleChat.openSingleChat$;

var pickConversation = createCommonjsModule(function (module, exports) {
function pickConversation$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.pickConversation$=void 0;var apiName="biz.chat.pickConversation";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.2"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.2"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.7.9"}, _a)), exports.pickConversation$=pickConversation$, exports.default=pickConversation$;
});

unwrapExports(pickConversation);
var pickConversation_1 = pickConversation.pickConversation$;

var sendEmotion = createCommonjsModule(function (module, exports) {
function sendEmotion$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.sendEmotion$=void 0;var apiName="biz.chat.sendEmotion";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.12"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.12"}, _a)), exports.sendEmotion$=sendEmotion$, exports.default=sendEmotion$;
});

unwrapExports(sendEmotion);
var sendEmotion_1 = sendEmotion.sendEmotion$;

var toConversation = createCommonjsModule(function (module, exports) {
function toConversation$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.toConversation$=void 0;var apiName="biz.chat.toConversation";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.toConversation$=toConversation$, exports.default=toConversation$;
});

unwrapExports(toConversation);
var toConversation_1 = toConversation.toConversation$;

var setData = createCommonjsModule(function (module, exports) {
function setData$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setData$=void 0;var apiName="biz.clipboardData.setData";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.1"}, _a)), exports.setData$=setData$, exports.default=setData$;
});

unwrapExports(setData);
var setData_1 = setData.setData$;

var videoConfCall = createCommonjsModule(function (module, exports) {
function videoConfCall$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.videoConfCall$=void 0;var apiName="biz.conference.videoConfCall";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"5.0.8"}, _a[ddSdk.ENV_ENUM.android]={vs:"5.0.8"}, _a)), exports.videoConfCall$=videoConfCall$, exports.default=videoConfCall$;
});

unwrapExports(videoConfCall);
var videoConfCall_1 = videoConfCall.videoConfCall$;

var choose = createCommonjsModule(function (module, exports) {
function choose$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.choose$=void 0;var apiName="biz.contact.choose",paramsDeal=apiHelper.genDefaultParamsDealFn({multiple:!0,startWithDepartmentId:0,users:[]});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.choose$=choose$, exports.default=choose$;
});

unwrapExports(choose);
var choose_1 = choose.choose$;

var chooseMobileContacts = createCommonjsModule(function (module, exports) {
function chooseMobileContacts$(o){return ddSdk.ddSdk.invokeAPI(apiName,o)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseMobileContacts$=void 0;var apiName="biz.contact.chooseMobileContacts";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.1"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.1"}, _a)), exports.chooseMobileContacts$=chooseMobileContacts$, exports.default=chooseMobileContacts$;
});

unwrapExports(chooseMobileContacts);
var chooseMobileContacts_1 = chooseMobileContacts.chooseMobileContacts$;

var complexPicker = createCommonjsModule(function (module, exports) {
function complexPicker$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.complexPicker$=void 0;var apiName="biz.contact.complexPicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.3.5"}, _a)), exports.complexPicker$=complexPicker$, exports.default=complexPicker$;
});

unwrapExports(complexPicker);
var complexPicker_1 = complexPicker.complexPicker$;

var createGroup = createCommonjsModule(function (module, exports) {
function createGroup$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.createGroup$=void 0;var apiName="biz.contact.createGroup";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.1"}, _a)), exports.createGroup$=createGroup$, exports.default=createGroup$;
});

unwrapExports(createGroup);
var createGroup_1 = createGroup.createGroup$;

var departmentsPicker = createCommonjsModule(function (module, exports) {
function departmentsPicker$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.departmentsPicker$=void 0;var apiName="biz.contact.departmentsPicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.2.5"}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.0"}, _a)), exports.departmentsPicker$=departmentsPicker$, exports.default=departmentsPicker$;
});

unwrapExports(departmentsPicker);
var departmentsPicker_1 = departmentsPicker.departmentsPicker$;

var externalComplexPicker = createCommonjsModule(function (module, exports) {
function externalComplexPicker$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.externalComplexPicker$=void 0;var apiName="biz.contact.externalComplexPicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.0"}, _a)), exports.externalComplexPicker$=externalComplexPicker$, exports.default=externalComplexPicker$;
});

unwrapExports(externalComplexPicker);
var externalComplexPicker_1 = externalComplexPicker.externalComplexPicker$;

var externalEditForm = createCommonjsModule(function (module, exports) {
function externalEditForm$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.externalEditForm$=void 0;var apiName="biz.contact.externalEditForm";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.0"}, _a)), exports.externalEditForm$=externalEditForm$, exports.default=externalEditForm$;
});

unwrapExports(externalEditForm);
var externalEditForm_1 = externalEditForm.externalEditForm$;

var setRule = createCommonjsModule(function (module, exports) {
function setRule$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setRule$=void 0;var apiName="biz.contact.setRule";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.15"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.15"}, _a)), exports.setRule$=setRule$, exports.default=setRule$;
});

unwrapExports(setRule);
var setRule_1 = setRule.setRule$;

var chooseSpaceDir = createCommonjsModule(function (module, exports) {
function chooseSpaceDir$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chooseSpaceDir$=void 0;var apiName="biz.cspace.chooseSpaceDir";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.6"}, _a)), exports.chooseSpaceDir$=chooseSpaceDir$, exports.default=chooseSpaceDir$;
});

unwrapExports(chooseSpaceDir);
var chooseSpaceDir_1 = chooseSpaceDir.chooseSpaceDir$;

var _delete = createCommonjsModule(function (module, exports) {
function delete$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.delete$=void 0;var apiName="biz.cspace.delete";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.21"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.21"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.21"}, _a)), exports.delete$=delete$, exports.default=delete$;
});

unwrapExports(_delete);
var _delete_1 = _delete.delete$;

var preview = createCommonjsModule(function (module, exports) {
function preview$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.preview$=void 0;var apiName="biz.cspace.preview";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.0"}, _a)), exports.preview$=preview$, exports.default=preview$;
});

unwrapExports(preview);
var preview_1 = preview.preview$;

var saveFile = createCommonjsModule(function (module, exports) {
function saveFile$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.saveFile$=void 0;var apiName="biz.cspace.saveFile";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.6"}, _a)), exports.saveFile$=saveFile$, exports.default=saveFile$;
});

unwrapExports(saveFile);
var saveFile_1 = saveFile.saveFile$;

var choose$2 = createCommonjsModule(function (module, exports) {
function choose$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.choose$=void 0;var apiName="biz.customContact.choose",paramsDeal=apiHelper.genDefaultParamsDealFn({isShowCompanyName:!1,max:50});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.5.2",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.5.2",paramsDeal:paramsDeal}, _a)), exports.choose$=choose$, exports.default=choose$;
});

unwrapExports(choose$2);
var choose_1$1 = choose$2.choose$;

var multipleChoose = createCommonjsModule(function (module, exports) {
function multipleChoose$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.multipleChoose$=void 0;var apiName="biz.customContact.multipleChoose",paramsDeal=apiHelper.genDefaultParamsDealFn({isShowCompanyName:!1,max:50});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.multipleChoose$=multipleChoose$, exports.default=multipleChoose$;
});

unwrapExports(multipleChoose);
var multipleChoose_1 = multipleChoose.multipleChoose$;

var create$1 = createCommonjsModule(function (module, exports) {
function create$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.create$=void 0;var apiName="biz.ding.create";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.1",resultDeal:function(e){return""===e?e={dingCreateResult:!1}:"object"==typeof e&&(e.dingCreateResult=!!e.dingCreateResult), e}}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.1"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.9"}, _a)), exports.create$=create$, exports.default=create$;
});

unwrapExports(create$1);
var create_1 = create$1.create$;

var post = createCommonjsModule(function (module, exports) {
function post$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.post$=void 0;var apiName="biz.ding.post";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.post$=post$, exports.default=post$;
});

unwrapExports(post);
var post_1 = post.post$;

var notifyWeex = createCommonjsModule(function (module, exports) {
function notifyWeex$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.notifyWeex$=void 0;var apiName="biz.event.notifyWeex";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.0"}, _a)), exports.notifyWeex$=notifyWeex$, exports.default=notifyWeex$;
});

unwrapExports(notifyWeex);
var notifyWeex_1 = notifyWeex.notifyWeex$;

var fetchData = createCommonjsModule(function (module, exports) {
function fetchData$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.fetchData$=void 0;var apiName="biz.intent.fetchData";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.6"}, _a)), exports.fetchData$=fetchData$, exports.default=fetchData$;
});

unwrapExports(fetchData);
var fetchData_1 = fetchData.fetchData$;

var bind = createCommonjsModule(function (module, exports) {
function bind$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.bind$=void 0;var apiName="biz.iot.bind";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.34"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.34"}, _a)), exports.bind$=bind$, exports.default=bind$;
});

unwrapExports(bind);
var bind_1 = bind.bind$;

var bindMeetingRoom = createCommonjsModule(function (module, exports) {
function bindMeetingRoom$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.bindMeetingRoom$=void 0;var apiName="biz.iot.bindMeetingRoom";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.34"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.34"}, _a)), exports.bindMeetingRoom$=bindMeetingRoom$, exports.default=bindMeetingRoom$;
});

unwrapExports(bindMeetingRoom);
var bindMeetingRoom_1 = bindMeetingRoom.bindMeetingRoom$;

var getDeviceProperties = createCommonjsModule(function (module, exports) {
function getDeviceProperties$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getDeviceProperties$=void 0;var apiName="biz.iot.getDeviceProperties";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.42"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.42"}, _a)), exports.getDeviceProperties$=getDeviceProperties$, exports.default=getDeviceProperties$;
});

unwrapExports(getDeviceProperties);
var getDeviceProperties_1 = getDeviceProperties.getDeviceProperties$;

var invokeThingService = createCommonjsModule(function (module, exports) {
function invokeThingService$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.invokeThingService$=void 0;var apiName="biz.iot.invokeThingService";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.42"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.42"}, _a)), exports.invokeThingService$=invokeThingService$, exports.default=invokeThingService$;
});

unwrapExports(invokeThingService);
var invokeThingService_1 = invokeThingService.invokeThingService$;

var queryMeetingRoomList = createCommonjsModule(function (module, exports) {
function queryMeetingRoomList$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.queryMeetingRoomList$=void 0;var apiName="biz.iot.queryMeetingRoomList";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.34"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.34"}, _a)), exports.queryMeetingRoomList$=queryMeetingRoomList$, exports.default=queryMeetingRoomList$;
});

unwrapExports(queryMeetingRoomList);
var queryMeetingRoomList_1 = queryMeetingRoomList.queryMeetingRoomList$;

var setDeviceProperties = createCommonjsModule(function (module, exports) {
function setDeviceProperties$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setDeviceProperties$=void 0;var apiName="biz.iot.setDeviceProperties";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.42"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.42"}, _a)), exports.setDeviceProperties$=setDeviceProperties$, exports.default=setDeviceProperties$;
});

unwrapExports(setDeviceProperties);
var setDeviceProperties_1 = setDeviceProperties.setDeviceProperties$;

var unbind = createCommonjsModule(function (module, exports) {
function unbind$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.unbind$=void 0;var apiName="biz.iot.unbind";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.34"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.34"}, _a)), exports.unbind$=unbind$, exports.default=unbind$;
});

unwrapExports(unbind);
var unbind_1 = unbind.unbind$;

var locate = createCommonjsModule(function (module, exports) {
function locate$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.locate$=void 0;var apiName="biz.map.locate";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.locate$=locate$, exports.default=locate$;
});

unwrapExports(locate);
var locate_1 = locate.locate$;

var search = createCommonjsModule(function (module, exports) {
function search$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.search$=void 0;var apiName="biz.map.search",paramsDeal=apiHelper.genDefaultParamsDealFn({scope:500});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.search$=search$, exports.default=search$;
});

unwrapExports(search);
var search_1 = search.search$;

var view = createCommonjsModule(function (module, exports) {
function view$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.view$=void 0;var apiName="biz.map.view";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.view$=view$, exports.default=view$;
});

unwrapExports(view);
var view_1 = view.view$;

var compressVideo = createCommonjsModule(function (module, exports) {
function compressVideo$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.compressVideo$=void 0;var apiName="biz.media.compressVideo";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.37"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.37"}, _a)), exports.compressVideo$=compressVideo$, exports.default=compressVideo$;
});

unwrapExports(compressVideo);
var compressVideo_1 = compressVideo.compressVideo$;

var openApp = createCommonjsModule(function (module, exports) {
function openApp$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openApp$=void 0;var apiName="biz.microApp.openApp";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.6"}, _a)), exports.openApp$=openApp$, exports.default=openApp$;
});

unwrapExports(openApp);
var openApp_1 = openApp.openApp$;

var close = createCommonjsModule(function (module, exports) {
function close$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.close$=void 0;var apiName="biz.navigation.close";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.3.5"}, _a)), exports.close$=close$, exports.default=close$;
});

unwrapExports(close);
var close_1 = close.close$;

var goBack = createCommonjsModule(function (module, exports) {
function goBack$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.goBack$=void 0;var apiName="biz.navigation.goBack";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.goBack$=goBack$, exports.default=goBack$;
});

unwrapExports(goBack);
var goBack_1 = goBack.goBack$;

var hideBar = createCommonjsModule(function (module, exports) {
function hideBar$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.hideBar$=void 0;var apiName="biz.navigation.hideBar";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.6"}, _a)), exports.hideBar$=hideBar$, exports.default=hideBar$;
});

unwrapExports(hideBar);
var hideBar_1 = hideBar.hideBar$;

var quit = createCommonjsModule(function (module, exports) {
function quit$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.quit$=void 0;var apiName="biz.navigation.quit";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.quit$=quit$, exports.default=quit$;
});

unwrapExports(quit);
var quit_1 = quit.quit$;

var replace = createCommonjsModule(function (module, exports) {
function replace$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.replace$=void 0;var apiName="biz.navigation.replace";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.4.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.4.6"}, _a)), exports.replace$=replace$, exports.default=replace$;
});

unwrapExports(replace);
var replace_1 = replace.replace$;

var setIcon = createCommonjsModule(function (module, exports) {
function setIcon$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setIcon$=void 0;var apiName="biz.navigation.setIcon",paramsDeal=apiHelper.genDefaultParamsDealFn({watch:!0,showIcon:!0,iconIndex:1});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.setIcon$=setIcon$, exports.default=setIcon$;
});

unwrapExports(setIcon);
var setIcon_1 = setIcon.setIcon$;

var setLeft = createCommonjsModule(function (module, exports) {
function setLeft$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setLeft$=void 0;var apiName="biz.navigation.setLeft",paramsDeal=apiHelper.genDefaultParamsDealFn({watch:!0,show:!0,control:!1,showIcon:!0,text:""});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.setLeft$=setLeft$, exports.default=setLeft$;
});

unwrapExports(setLeft);
var setLeft_1 = setLeft.setLeft$;

var setMenu = createCommonjsModule(function (module, exports) {
function setMenu$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setMenu$=void 0;var apiName="biz.navigation.setMenu";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0",paramsDeal:apiHelper.addWatchParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0",paramsDeal:apiHelper.addWatchParamsDeal}, _a)), exports.setMenu$=setMenu$, exports.default=setMenu$;
});

unwrapExports(setMenu);
var setMenu_1 = setMenu.setMenu$;

var setRight = createCommonjsModule(function (module, exports) {
function setRight$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setRight$=void 0;var apiName="biz.navigation.setRight",paramsDeal=apiHelper.genDefaultParamsDealFn({watch:!0,show:!0,control:!1,showIcon:!0,text:""});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.setRight$=setRight$, exports.default=setRight$;
});

unwrapExports(setRight);
var setRight_1 = setRight.setRight$;

var setTitle = createCommonjsModule(function (module, exports) {
function setTitle$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setTitle$=void 0;var apiName="biz.navigation.setTitle";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.setTitle$=setTitle$, exports.default=setTitle$;
});

unwrapExports(setTitle);
var setTitle_1 = setTitle.setTitle$;

var subscribe = createCommonjsModule(function (module, exports) {
function subscribe$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.subscribe$=void 0;var apiName="biz.realm.subscribe";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.7.18"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.7.18"}, _a)), exports.subscribe$=subscribe$, exports.default=subscribe$;
});

unwrapExports(subscribe);
var subscribe_1 = subscribe.subscribe$;

var unsubscribe = createCommonjsModule(function (module, exports) {
function unsubscribe$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.unsubscribe$=void 0;var apiName="biz.realm.unsubscribe";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.7.18"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.7.18"}, _a)), exports.unsubscribe$=unsubscribe$, exports.default=unsubscribe$;
});

unwrapExports(unsubscribe);
var unsubscribe_1 = unsubscribe.unsubscribe$;

var addShortCut = createCommonjsModule(function (module, exports) {
function addShortCut$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.addShortCut$=void 0;var apiName="biz.shortCut.addShortCut";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.7.32"}, _a)), exports.addShortCut$=addShortCut$, exports.default=addShortCut$;
});

unwrapExports(addShortCut);
var addShortCut_1 = addShortCut.addShortCut$;

var closeUnpayOrder = createCommonjsModule(function (module, exports) {
function closeUnpayOrder$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.closeUnpayOrder$=void 0;var apiName="biz.store.closeUnpayOrder";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.3",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a)), exports.closeUnpayOrder$=closeUnpayOrder$, exports.default=closeUnpayOrder$;
});

unwrapExports(closeUnpayOrder);
var closeUnpayOrder_1 = closeUnpayOrder.closeUnpayOrder$;

var createOrder = createCommonjsModule(function (module, exports) {
function createOrder$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.createOrder$=void 0;var apiName="biz.store.createOrder";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.3",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a)), exports.createOrder$=createOrder$, exports.default=createOrder$;
});

unwrapExports(createOrder);
var createOrder_1 = createOrder.createOrder$;

var getPayUrl = createCommonjsModule(function (module, exports) {
function getPayUrl$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getPayUrl$=void 0;var apiName="biz.store.getPayUrl";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.3",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a)), exports.getPayUrl$=getPayUrl$, exports.default=getPayUrl$;
});

unwrapExports(getPayUrl);
var getPayUrl_1 = getPayUrl.getPayUrl$;

var inquiry = createCommonjsModule(function (module, exports) {
function inquiry$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.inquiry$=void 0;var apiName="biz.store.inquiry";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.7",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.5.3",paramsDeal:apiHelper.genBizStoreParamsDealFn}, _a)), exports.inquiry$=inquiry$, exports.default=inquiry$;
});

unwrapExports(inquiry);
var inquiry_1 = inquiry.inquiry$;

var call$1 = createCommonjsModule(function (module, exports) {
function call$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.call$=void 0;var apiName="biz.telephone.call";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.call$=call$, exports.default=call$;
});

unwrapExports(call$1);
var call_1 = call$1.call$;

var checkBizCall = createCommonjsModule(function (module, exports) {
function checkBizCall$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.checkBizCall$=void 0;var apiName="biz.telephone.checkBizCall";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.6"}, _a)), exports.checkBizCall$=checkBizCall$, exports.default=checkBizCall$;
});

unwrapExports(checkBizCall);
var checkBizCall_1 = checkBizCall.checkBizCall$;

var quickCallList = createCommonjsModule(function (module, exports) {
function quickCallList$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.quickCallList$=void 0;var apiName="biz.telephone.quickCallList";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.5.6"}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.6"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.6"}, _a)), exports.quickCallList$=quickCallList$, exports.default=quickCallList$;
});

unwrapExports(quickCallList);
var quickCallList_1 = quickCallList.quickCallList$;

var showCallMenu = createCommonjsModule(function (module, exports) {
function showCallMenu$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.showCallMenu$=void 0;var apiName="biz.telephone.showCallMenu";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.showCallMenu$=showCallMenu$, exports.default=showCallMenu$;
});

unwrapExports(showCallMenu);
var showCallMenu_1 = showCallMenu.showCallMenu$;

var checkPassword = createCommonjsModule(function (module, exports) {
function checkPassword$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.checkPassword$=void 0;var apiName="biz.user.checkPassword";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.8"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.8"}, _a)), exports.checkPassword$=checkPassword$, exports.default=checkPassword$;
});

unwrapExports(checkPassword);
var checkPassword_1 = checkPassword.checkPassword$;

var get = createCommonjsModule(function (module, exports) {
function get$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.get$=void 0;var apiName="biz.user.get";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.get$=get$, exports.default=get$;
});

unwrapExports(get);
var get_1 = get.get$;

var chosen = createCommonjsModule(function (module, exports) {
function chosen$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.chosen$=void 0;var apiName="biz.util.chosen";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.chosen$=chosen$, exports.default=chosen$;
});

unwrapExports(chosen);
var chosen_1 = chosen.chosen$;

var datepicker = createCommonjsModule(function (module, exports) {
function datepicker$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.datepicker$=void 0;var apiName="biz.util.datepicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.datepicker$=datepicker$, exports.default=datepicker$;
});

unwrapExports(datepicker);
var datepicker_1 = datepicker.datepicker$;

var datetimepicker = createCommonjsModule(function (module, exports) {
function datetimepicker$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.datetimepicker$=void 0;var apiName="biz.util.datetimepicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.datetimepicker$=datetimepicker$, exports.default=datetimepicker$;
});

unwrapExports(datetimepicker);
var datetimepicker_1 = datetimepicker.datetimepicker$;

var decrypt = createCommonjsModule(function (module, exports) {
function decrypt$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.decrypt$=void 0;var apiName="biz.util.decrypt";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.1"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.1"}, _a)), exports.decrypt$=decrypt$, exports.default=decrypt$;
});

unwrapExports(decrypt);
var decrypt_1 = decrypt.decrypt$;

var downloadFile = createCommonjsModule(function (module, exports) {
function downloadFile$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.downloadFile$=void 0;var apiName="biz.util.downloadFile";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.downloadFile$=downloadFile$, exports.default=downloadFile$;
});

unwrapExports(downloadFile);
var downloadFile_1 = downloadFile.downloadFile$;

var encrypt = createCommonjsModule(function (module, exports) {
function encrypt$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.encrypt$=void 0;var apiName="biz.util.encrypt";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.1"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.1"}, _a)), exports.encrypt$=encrypt$, exports.default=encrypt$;
});

unwrapExports(encrypt);
var encrypt_1 = encrypt.encrypt$;

var isLocalFileExist = createCommonjsModule(function (module, exports) {
function isLocalFileExist$(i){return ddSdk.ddSdk.invokeAPI(apiName,i)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.isLocalFileExist$=void 0;var apiName="biz.util.isLocalFileExist";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.isLocalFileExist$=isLocalFileExist$, exports.default=isLocalFileExist$;
});

unwrapExports(isLocalFileExist);
var isLocalFileExist_1 = isLocalFileExist.isLocalFileExist$;

var multiSelect = createCommonjsModule(function (module, exports) {
function multiSelect$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.multiSelect$=void 0;var apiName="biz.util.multiSelect";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.0.0"}, _a)), exports.multiSelect$=multiSelect$, exports.default=multiSelect$;
});

unwrapExports(multiSelect);
var multiSelect_1 = multiSelect.multiSelect$;

var open = createCommonjsModule(function (module, exports) {
function open$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.open$=void 0;var apiName="biz.util.open";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.open$=open$, exports.default=open$;
});

unwrapExports(open);
var open_1 = open.open$;

var openLink = createCommonjsModule(function (module, exports) {
function openLink$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openLink$=void 0;var apiName="biz.util.openLink",paramsDeal=apiHelper.genDefaultParamsDealFn({credible:!0,showMenuBar:!0});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.openLink$=openLink$, exports.default=openLink$;
});

unwrapExports(openLink);
var openLink_1 = openLink.openLink$;

var openLocalFile = createCommonjsModule(function (module, exports) {
function openLocalFile$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openLocalFile$=void 0;var apiName="biz.util.openLocalFile";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.openLocalFile$=openLocalFile$, exports.default=openLocalFile$;
});

unwrapExports(openLocalFile);
var openLocalFile_1 = openLocalFile.openLocalFile$;

var openModal = createCommonjsModule(function (module, exports) {
function openModal$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openModal$=void 0;var apiName="biz.util.openModal";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.openModal$=openModal$, exports.default=openModal$;
});

unwrapExports(openModal);
var openModal_1 = openModal.openModal$;

var openSlidePanel = createCommonjsModule(function (module, exports) {
function openSlidePanel$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openSlidePanel$=void 0;var apiName="biz.util.openSlidePanel";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a)), exports.openSlidePanel$=openSlidePanel$, exports.default=openSlidePanel$;
});

unwrapExports(openSlidePanel);
var openSlidePanel_1 = openSlidePanel.openSlidePanel$;

var presentWindow = createCommonjsModule(function (module, exports) {
function presentWindow$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.presentWindow$=void 0;var apiName="biz.util.presentWindow";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.presentWindow$=presentWindow$, exports.default=presentWindow$;
});

unwrapExports(presentWindow);
var presentWindow_1 = presentWindow.presentWindow$;

var previewImage = createCommonjsModule(function (module, exports) {
function previewImage$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.previewImage$=void 0;var apiName="biz.util.previewImage";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.previewImage$=previewImage$, exports.default=previewImage$;
});

unwrapExports(previewImage);
var previewImage_1 = previewImage.previewImage$;

var previewVideo = createCommonjsModule(function (module, exports) {
function previewVideo$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.previewVideo$=void 0;var apiName="biz.util.previewVideo";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.7"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.33"}, _a)), exports.previewVideo$=previewVideo$, exports.default=previewVideo$;
});

unwrapExports(previewVideo);
var previewVideo_1 = previewVideo.previewVideo$;

var saveImage = createCommonjsModule(function (module, exports) {
function saveImage$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.saveImage$=void 0;var apiName="biz.util.saveImage";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.1"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.1"}, _a)), exports.saveImage$=saveImage$, exports.default=saveImage$;
});

unwrapExports(saveImage);
var saveImage_1 = saveImage.saveImage$;

var scan = createCommonjsModule(function (module, exports) {
function scan$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.scan$=void 0;var apiName="biz.util.scan",paramsDeal=apiHelper.genDefaultParamsDealFn({type:"qrCode"});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.scan$=scan$, exports.default=scan$;
});

unwrapExports(scan);
var scan_1 = scan.scan$;

var scanCard = createCommonjsModule(function (module, exports) {
function scanCard$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.scanCard$=void 0;var apiName="biz.util.scanCard";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.scanCard$=scanCard$, exports.default=scanCard$;
});

unwrapExports(scanCard);
var scanCard_1 = scanCard.scanCard$;

var setScreenBrightnessAndKeepOn = createCommonjsModule(function (module, exports) {
function setScreenBrightnessAndKeepOn$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setScreenBrightnessAndKeepOn$=void 0;var apiName="biz.util.setScreenBrightnessAndKeepOn";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.37"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.3"}, _a)), exports.setScreenBrightnessAndKeepOn$=setScreenBrightnessAndKeepOn$, exports.default=setScreenBrightnessAndKeepOn$;
});

unwrapExports(setScreenBrightnessAndKeepOn);
var setScreenBrightnessAndKeepOn_1 = setScreenBrightnessAndKeepOn.setScreenBrightnessAndKeepOn$;

var share = createCommonjsModule(function (module, exports) {
function share$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.share$=void 0;var apiName="biz.util.share",paramsDeal=apiHelper.genDefaultParamsDealFn({title:"",buttonName:"确定"});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.37",paramsDeal:paramsDeal}, _a)), exports.share$=share$, exports.default=share$;
});

unwrapExports(share);
var share_1 = share.share$;

var shareImage = createCommonjsModule(function (module, exports) {
function shareImage$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.shareImage$=void 0;var apiName="biz.util.shareImage";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.1"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.1"}, _a)), exports.shareImage$=shareImage$, exports.default=shareImage$;
});

unwrapExports(shareImage);
var shareImage_1 = shareImage.shareImage$;

var startDocSign = createCommonjsModule(function (module, exports) {
function startDocSign$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.startDocSign$=void 0;var apiName="biz.util.startDocSign";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.6.33"}, _a)), exports.startDocSign$=startDocSign$, exports.default=startDocSign$;
});

unwrapExports(startDocSign);
var startDocSign_1 = startDocSign.startDocSign$;

var systemShare = createCommonjsModule(function (module, exports) {
function systemShare$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.systemShare$=void 0;var apiName="biz.util.systemShare";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.11"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.11"}, _a)), exports.systemShare$=systemShare$, exports.default=systemShare$;
});

unwrapExports(systemShare);
var systemShare_1 = systemShare.systemShare$;

var timepicker = createCommonjsModule(function (module, exports) {
function timepicker$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.timepicker$=void 0;var apiName="biz.util.timepicker";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.timepicker$=timepicker$, exports.default=timepicker$;
});

unwrapExports(timepicker);
var timepicker_1 = timepicker.timepicker$;

var uploadAttachment = createCommonjsModule(function (module, exports) {
function uploadAttachment$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.uploadAttachment$=void 0;var apiName="biz.util.uploadAttachment";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.7.0"}, _a)), exports.uploadAttachment$=uploadAttachment$, exports.default=uploadAttachment$;
});

unwrapExports(uploadAttachment);
var uploadAttachment_1 = uploadAttachment.uploadAttachment$;

var uploadImage = createCommonjsModule(function (module, exports) {
function uploadImage$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.uploadImage$=void 0;var apiName="biz.util.uploadImage",paramsDeal=apiHelper.genDefaultParamsDealFn({multiple:!1});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.uploadImage$=uploadImage$, exports.default=uploadImage$;
});

unwrapExports(uploadImage);
var uploadImage_1 = uploadImage.uploadImage$;

var uploadImageFromCamera = createCommonjsModule(function (module, exports) {
function uploadImageFromCamera$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.uploadImageFromCamera$=void 0;var apiName="biz.util.uploadImageFromCamera";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.uploadImageFromCamera$=uploadImageFromCamera$, exports.default=uploadImageFromCamera$;
});

unwrapExports(uploadImageFromCamera);
var uploadImageFromCamera_1 = uploadImageFromCamera.uploadImageFromCamera$;

var ut = createCommonjsModule(function (module, exports) {
function ut$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.ut$=void 0;var apiName="biz.util.ut",utParamsObj2Str=function(a){var e=Object.assign({},a),t=e.value,d=[];if(t&&"object"==typeof t){for(var r in t)t[r]&&d.push(r+"="+t[r]);t=d.join(",");}return e.value=t||"", e};ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.5.0",paramsDeal:utParamsObj2Str}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:function(a){var e=Object.assign({},a),t=e.value;return t&&"object"==typeof t&&(t=JSON.stringify(t)), e.value=t, e}}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:utParamsObj2Str}, _a)), exports.ut$=ut$, exports.default=ut$;
});

unwrapExports(ut);
var ut_1 = ut.ut$;

var openBindIDCard = createCommonjsModule(function (module, exports) {
function openBindIDCard$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.openBindIDCard$=void 0;var apiName="biz.verify.openBindIDCard";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.21"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.21"}, _a)), exports.openBindIDCard$=openBindIDCard$, exports.default=openBindIDCard$;
});

unwrapExports(openBindIDCard);
var openBindIDCard_1 = openBindIDCard.openBindIDCard$;

var startAuth = createCommonjsModule(function (module, exports) {
function startAuth$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.startAuth$=void 0;var apiName="biz.verify.startAuth";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.5.21"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.21"}, _a)), exports.startAuth$=startAuth$, exports.default=startAuth$;
});

unwrapExports(startAuth);
var startAuth_1 = startAuth.startAuth$;

var requestAuthCode = createCommonjsModule(function (module, exports) {
function requestAuthCode$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.requestAuthCode$=void 0;var apiName="channel.permission.requestAuthCode";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.0.0"}, _a)), exports.requestAuthCode$=requestAuthCode$, exports.default=requestAuthCode$;
});

unwrapExports(requestAuthCode);
var requestAuthCode_1 = requestAuthCode.requestAuthCode$;

var clearShake = createCommonjsModule(function (module, exports) {
function clearShake$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.clearShake$=void 0;var apiName="device.accelerometer.clearShake";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.clearShake$=clearShake$, exports.default=clearShake$;
});

unwrapExports(clearShake);
var clearShake_1 = clearShake.clearShake$;

var watchShake = createCommonjsModule(function (module, exports) {
function watchShake$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.watchShake$=void 0;var apiName="device.accelerometer.watchShake";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:function(a){return apiHelper.forceChangeParamsDealFn({sensitivity:3.2})(apiHelper.addWatchParamsDeal(a))}}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:apiHelper.addWatchParamsDeal}, _a)), exports.watchShake$=watchShake$, exports.default=watchShake$;
});

unwrapExports(watchShake);
var watchShake_1 = watchShake.watchShake$;

var download = createCommonjsModule(function (module, exports) {
function download$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.download$=void 0;var apiName="device.audio.download";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.download$=download$, exports.default=download$;
});

unwrapExports(download);
var download_1 = download.download$;

var onPlayEnd = createCommonjsModule(function (module, exports) {
function onPlayEnd$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.onPlayEnd$=void 0;var apiName="device.audio.onPlayEnd";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.onPlayEnd$=onPlayEnd$, exports.default=onPlayEnd$;
});

unwrapExports(onPlayEnd);
var onPlayEnd_1 = onPlayEnd.onPlayEnd$;

var onRecordEnd = createCommonjsModule(function (module, exports) {
function onRecordEnd$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.onRecordEnd$=void 0;var apiName="device.audio.onRecordEnd";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.onRecordEnd$=onRecordEnd$, exports.default=onRecordEnd$;
});

unwrapExports(onRecordEnd);
var onRecordEnd_1 = onRecordEnd.onRecordEnd$;

var pause = createCommonjsModule(function (module, exports) {
function pause$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.pause$=void 0;var apiName="device.audio.pause";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.pause$=pause$, exports.default=pause$;
});

unwrapExports(pause);
var pause_1 = pause.pause$;

var play = createCommonjsModule(function (module, exports) {
function play$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.play$=void 0;var apiName="device.audio.play";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.play$=play$, exports.default=play$;
});

unwrapExports(play);
var play_1 = play.play$;

var resume = createCommonjsModule(function (module, exports) {
function resume$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.resume$=void 0;var apiName="device.audio.resume";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.resume$=resume$, exports.default=resume$;
});

unwrapExports(resume);
var resume_1 = resume.resume$;

var startRecord = createCommonjsModule(function (module, exports) {
function startRecord$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.startRecord$=void 0;var apiName="device.audio.startRecord";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.startRecord$=startRecord$, exports.default=startRecord$;
});

unwrapExports(startRecord);
var startRecord_1 = startRecord.startRecord$;

var stop = createCommonjsModule(function (module, exports) {
function stop$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.stop$=void 0;var apiName="device.audio.stop";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.stop$=stop$, exports.default=stop$;
});

unwrapExports(stop);
var stop_1 = stop.stop$;

var stopRecord = createCommonjsModule(function (module, exports) {
function stopRecord$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.stopRecord$=void 0;var apiName="device.audio.stopRecord";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.stopRecord$=stopRecord$, exports.default=stopRecord$;
});

unwrapExports(stopRecord);
var stopRecord_1 = stopRecord.stopRecord$;

var translateVoice = createCommonjsModule(function (module, exports) {
function translateVoice$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.translateVoice$=void 0;var apiName="device.audio.translateVoice";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.8.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.8.0"}, _a)), exports.translateVoice$=translateVoice$, exports.default=translateVoice$;
});

unwrapExports(translateVoice);
var translateVoice_1 = translateVoice.translateVoice$;

var getInterface = createCommonjsModule(function (module, exports) {
function getInterface$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getInterface$=void 0;var apiName="device.base.getInterface";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.getInterface$=getInterface$, exports.default=getInterface$;
});

unwrapExports(getInterface);
var getInterface_1 = getInterface.getInterface$;

var getPhoneInfo = createCommonjsModule(function (module, exports) {
function getPhoneInfo$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getPhoneInfo$=void 0;var apiName="device.base.getPhoneInfo";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.5.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.5.0"}, _a)), exports.getPhoneInfo$=getPhoneInfo$, exports.default=getPhoneInfo$;
});

unwrapExports(getPhoneInfo);
var getPhoneInfo_1 = getPhoneInfo.getPhoneInfo$;

var getUUID = createCommonjsModule(function (module, exports) {
function getUUID$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getUUID$=void 0;var apiName="device.base.getUUID";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.7.6"}, _a)), exports.getUUID$=getUUID$, exports.default=getUUID$;
});

unwrapExports(getUUID);
var getUUID_1 = getUUID.getUUID$;

var getWifiStatus = createCommonjsModule(function (module, exports) {
function getWifiStatus$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getWifiStatus$=void 0;var apiName="device.base.getWifiStatus";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.11.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.11.0"}, _a)), exports.getWifiStatus$=getWifiStatus$, exports.default=getWifiStatus$;
});

unwrapExports(getWifiStatus);
var getWifiStatus_1 = getWifiStatus.getWifiStatus$;

var getNetworkType = createCommonjsModule(function (module, exports) {
function getNetworkType$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getNetworkType$=void 0;var apiName="device.connection.getNetworkType";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.getNetworkType$=getNetworkType$, exports.default=getNetworkType$;
});

unwrapExports(getNetworkType);
var getNetworkType_1 = getNetworkType.getNetworkType$;

var checkPermission = createCommonjsModule(function (module, exports) {
function checkPermission$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.checkPermission$=void 0;var apiName="device.geolocation.checkPermission";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.0"}, _a)), exports.checkPermission$=checkPermission$, exports.default=checkPermission$;
});

unwrapExports(checkPermission);
var checkPermission_1 = checkPermission.checkPermission$;

var get$2 = createCommonjsModule(function (module, exports) {
function get$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.get$=void 0;var apiName="device.geolocation.get";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.get$=get$, exports.default=get$;
});

unwrapExports(get$2);
var get_1$1 = get$2.get$;

var start = createCommonjsModule(function (module, exports) {
function start$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.start$=void 0;var apiName="device.geolocation.start";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.4.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.4.7"}, _a)), exports.start$=start$, exports.default=start$;
});

unwrapExports(start);
var start_1 = start.start$;

var status = createCommonjsModule(function (module, exports) {
function status$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.status$=void 0;var apiName="device.geolocation.status";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.4.8"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.4.8"}, _a)), exports.status$=status$, exports.default=status$;
});

unwrapExports(status);
var status_1 = status.status$;

var stop$2 = createCommonjsModule(function (module, exports) {
function stop$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.stop$=void 0;var apiName="device.geolocation.stop";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.4.7"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.4.7"}, _a)), exports.stop$=stop$, exports.default=stop$;
});

unwrapExports(stop$2);
var stop_1$1 = stop$2.stop$;

var checkInstalledApps = createCommonjsModule(function (module, exports) {
function checkInstalledApps$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.checkInstalledApps$=void 0;var apiName="device.launcher.checkInstalledApps";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.checkInstalledApps$=checkInstalledApps$, exports.default=checkInstalledApps$;
});

unwrapExports(checkInstalledApps);
var checkInstalledApps_1 = checkInstalledApps.checkInstalledApps$;

var launchApp = createCommonjsModule(function (module, exports) {
function launchApp$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.launchApp$=void 0;var apiName="device.launcher.launchApp";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.launchApp$=launchApp$, exports.default=launchApp$;
});

unwrapExports(launchApp);
var launchApp_1 = launchApp.launchApp$;

var nfcRead = createCommonjsModule(function (module, exports) {
function nfcRead$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.nfcRead$=void 0;var apiName="device.nfc.nfcRead";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.11.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.11.0"}, _a)), exports.nfcRead$=nfcRead$, exports.default=nfcRead$;
});

unwrapExports(nfcRead);
var nfcRead_1 = nfcRead.nfcRead$;

var nfcStop = createCommonjsModule(function (module, exports) {
function nfcStop$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.nfcStop$=void 0;var apiName="device.nfc.nfcStop";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.3.9"}, _a[ddSdk.ENV_ENUM.android]={vs:"4.3.9"}, _a)), exports.nfcStop$=nfcStop$, exports.default=nfcStop$;
});

unwrapExports(nfcStop);
var nfcStop_1 = nfcStop.nfcStop$;

var nfcWrite = createCommonjsModule(function (module, exports) {
function nfcWrite$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.nfcWrite$=void 0;var apiName="device.nfc.nfcWrite";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.11.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.11.0"}, _a)), exports.nfcWrite$=nfcWrite$, exports.default=nfcWrite$;
});

unwrapExports(nfcWrite);
var nfcWrite_1 = nfcWrite.nfcWrite$;

var actionSheet = createCommonjsModule(function (module, exports) {
function actionSheet$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.actionSheet$=void 0;var apiName="device.notification.actionSheet";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.actionSheet$=actionSheet$, exports.default=actionSheet$;
});

unwrapExports(actionSheet);
var actionSheet_1 = actionSheet.actionSheet$;

var alert$1 = createCommonjsModule(function (module, exports) {
function alert$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.alert$=void 0;var apiName="device.notification.alert",paramsDeal=apiHelper.genDefaultParamsDealFn({title:"",buttonName:"确定"});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.alert$=alert$, exports.default=alert$;
});

unwrapExports(alert$1);
var alert_1 = alert$1.alert$;

var confirm = createCommonjsModule(function (module, exports) {
function confirm$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.confirm$=void 0;var apiName="device.notification.confirm",paramsDeal=apiHelper.genDefaultParamsDealFn({title:"",buttonLabels:["确定","取消"]});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.confirm$=confirm$, exports.default=confirm$;
});

unwrapExports(confirm);
var confirm_1 = confirm.confirm$;

var extendModal = createCommonjsModule(function (module, exports) {
function extendModal$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.extendModal$=void 0;var apiName="device.notification.extendModal";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.5.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.5.0"}, _a)), exports.extendModal$=extendModal$, exports.default=extendModal$;
});

unwrapExports(extendModal);
var extendModal_1 = extendModal.extendModal$;

var hidePreloader = createCommonjsModule(function (module, exports) {
function hidePreloader$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.hidePreloader$=void 0;var apiName="device.notification.hidePreloader";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.hidePreloader$=hidePreloader$, exports.default=hidePreloader$;
});

unwrapExports(hidePreloader);
var hidePreloader_1 = hidePreloader.hidePreloader$;

var modal = createCommonjsModule(function (module, exports) {
function modal$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.modal$=void 0;var apiName="device.notification.modal";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.2.5"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.modal$=modal$, exports.default=modal$;
});

unwrapExports(modal);
var modal_1 = modal.modal$;

var prompt = createCommonjsModule(function (module, exports) {
function prompt$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.prompt$=void 0;var apiName="device.notification.prompt",paramsDeal=apiHelper.genDefaultParamsDealFn({title:"",buttonLabels:["确定","取消"]});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.7.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.prompt$=prompt$, exports.default=prompt$;
});

unwrapExports(prompt);
var prompt_1 = prompt.prompt$;

var showPreloader = createCommonjsModule(function (module, exports) {
function showPreloader$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.showPreloader$=void 0;var apiName="device.notification.showPreloader",paramsDeal=apiHelper.genDefaultParamsDealFn({text:"加载中...",showIcon:!0});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.showPreloader$=showPreloader$, exports.default=showPreloader$;
});

unwrapExports(showPreloader);
var showPreloader_1 = showPreloader.showPreloader$;

var toast = createCommonjsModule(function (module, exports) {
function toast$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.toast$=void 0;var apiName="device.notification.toast",paramsDeal=apiHelper.genDefaultParamsDealFn({text:"toast",duration:3,delay:0});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"2.5.0",paramsDeal:function(a){return a.icon&&!a.type&&("success"===a.icon?a.type="success":"error"===a.icon&&(a.type="error")), a}}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.toast$=toast$, exports.default=toast$;
});

unwrapExports(toast);
var toast_1 = toast.toast$;

var vibrate = createCommonjsModule(function (module, exports) {
function vibrate$(a){return ddSdk.ddSdk.invokeAPI(apiName,a)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.vibrate$=void 0;var apiName="device.notification.vibrate",paramsDeal=apiHelper.genDefaultParamsDealFn({duration:300});ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:paramsDeal}, _a)), exports.vibrate$=vibrate$, exports.default=vibrate$;
});

unwrapExports(vibrate);
var vibrate_1 = vibrate.vibrate$;

var insetAdjust = createCommonjsModule(function (module, exports) {
function insetAdjust$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.insetAdjust$=void 0;var apiName="device.screen.insetAdjust";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.6.18"}, _a)), exports.insetAdjust$=insetAdjust$, exports.default=insetAdjust$;
});

unwrapExports(insetAdjust);
var insetAdjust_1 = insetAdjust.insetAdjust$;

var resetView = createCommonjsModule(function (module, exports) {
function resetView$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.resetView$=void 0;var apiName="device.screen.resetView";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.0.0"}, _a)), exports.resetView$=resetView$, exports.default=resetView$;
});

unwrapExports(resetView);
var resetView_1 = resetView.resetView$;

var rotateView = createCommonjsModule(function (module, exports) {
function rotateView$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.rotateView$=void 0;var apiName="device.screen.rotateView";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.0.0"}, _a[ddSdk.ENV_ENUM.ios]={vs:"4.0.0"}, _a)), exports.rotateView$=rotateView$, exports.default=rotateView$;
});

unwrapExports(rotateView);
var rotateView_1 = rotateView.rotateView$;

var loginGovNet = createCommonjsModule(function (module, exports) {
function loginGovNet$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.loginGovNet$=void 0;var apiName="net.bjGovApn.loginGovNet";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.android]={vs:"4.5.16"}, _a)), exports.loginGovNet$=loginGovNet$, exports.default=loginGovNet$;
});

unwrapExports(loginGovNet);
var loginGovNet_1 = loginGovNet.loginGovNet$;

var fetch = createCommonjsModule(function (module, exports) {
function fetch$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.fetch$=void 0;var apiName="runtime.message.fetch";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.fetch$=fetch$, exports.default=fetch$;
});

unwrapExports(fetch);
var fetch_1 = fetch.fetch$;

var post$2 = createCommonjsModule(function (module, exports) {
function post$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.post$=void 0;var apiName="runtime.message.post";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.post$=post$, exports.default=post$;
});

unwrapExports(post$2);
var post_1$1 = post$2.post$;

var requestAuthCode$2 = createCommonjsModule(function (module, exports) {
function requestAuthCode$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.requestAuthCode$=void 0;var apiName="runtime.permission.requestAuthCode",paramsDeal=function(e){return Object.assign(e,{url:location.href.split("#")[0]})};ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.0.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.requestAuthCode$=requestAuthCode$, exports.default=requestAuthCode$;
});

unwrapExports(requestAuthCode$2);
var requestAuthCode_1$1 = requestAuthCode$2.requestAuthCode$;

var requestOperateAuthCode = createCommonjsModule(function (module, exports) {
function requestOperateAuthCode$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.requestOperateAuthCode$=void 0;var apiName="runtime.permission.requestOperateAuthCode",paramsDeal=function(e){return Object.assign(e,{url:location.href.split("#")[0]})};ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.pc]={vs:"3.3.0",paramsDeal:paramsDeal}, _a[ddSdk.ENV_ENUM.ios]={vs:"3.3.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"3.3.0"}, _a)), exports.requestOperateAuthCode$=requestOperateAuthCode$, exports.default=requestOperateAuthCode$;
});

unwrapExports(requestOperateAuthCode);
var requestOperateAuthCode_1 = requestOperateAuthCode.requestOperateAuthCode$;

var plain = createCommonjsModule(function (module, exports) {
function plain$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.plain$=void 0;var apiName="ui.input.plain";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.plain$=plain$, exports.default=plain$;
});

unwrapExports(plain);
var plain_1 = plain.plain$;

var close$2 = createCommonjsModule(function (module, exports) {
function close$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.close$=void 0;var apiName="ui.nav.close";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.close$=close$, exports.default=close$;
});

unwrapExports(close$2);
var close_1$1 = close$2.close$;

var getCurrentId = createCommonjsModule(function (module, exports) {
function getCurrentId$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getCurrentId$=void 0;var apiName="ui.nav.getCurrentId";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.getCurrentId$=getCurrentId$, exports.default=getCurrentId$;
});

unwrapExports(getCurrentId);
var getCurrentId_1 = getCurrentId.getCurrentId$;

var go = createCommonjsModule(function (module, exports) {
function go$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.go$=void 0;var apiName="ui.nav.go";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.go$=go$, exports.default=go$;
});

unwrapExports(go);
var go_1 = go.go$;

var preload = createCommonjsModule(function (module, exports) {
function preload$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.preload$=void 0;var apiName="ui.nav.preload";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.preload$=preload$, exports.default=preload$;
});

unwrapExports(preload);
var preload_1 = preload.preload$;

var recycle = createCommonjsModule(function (module, exports) {
function recycle$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.recycle$=void 0;var apiName="ui.nav.recycle";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.6.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.6.0"}, _a)), exports.recycle$=recycle$, exports.default=recycle$;
});

unwrapExports(recycle);
var recycle_1 = recycle.recycle$;

var setColors = createCommonjsModule(function (module, exports) {
function setColors$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setColors$=void 0;var apiName="ui.progressBar.setColors";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.setColors$=setColors$, exports.default=setColors$;
});

unwrapExports(setColors);
var setColors_1 = setColors.setColors$;

var disable = createCommonjsModule(function (module, exports) {
function disable$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.disable$=void 0;var apiName="ui.pullToRefresh.disable";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.disable$=disable$, exports.default=disable$;
});

unwrapExports(disable);
var disable_1 = disable.disable$;

var enable = createCommonjsModule(function (module, exports) {
function enable$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.enable$=void 0;var apiName="ui.pullToRefresh.enable";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0",paramsDeal:apiHelper.addWatchParamsDeal}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0",paramsDeal:apiHelper.addWatchParamsDeal}, _a)), exports.enable$=enable$, exports.default=enable$;
});

unwrapExports(enable);
var enable_1 = enable.enable$;

var stop$4 = createCommonjsModule(function (module, exports) {
function stop$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.stop$=void 0;var apiName="ui.pullToRefresh.stop";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.stop$=stop$, exports.default=stop$;
});

unwrapExports(stop$4);
var stop_1$2 = stop$4.stop$;

var disable$2 = createCommonjsModule(function (module, exports) {
function disable$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.disable$=void 0;var apiName="ui.webViewBounce.disable";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.disable$=disable$, exports.default=disable$;
});

unwrapExports(disable$2);
var disable_1$1 = disable$2.disable$;

var enable$2 = createCommonjsModule(function (module, exports) {
function enable$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.enable$=void 0;var apiName="ui.webViewBounce.enable";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.4.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.4.0"}, _a)), exports.enable$=enable$, exports.default=enable$;
});

unwrapExports(enable$2);
var enable_1$1 = enable$2.enable$;

var getItem = createCommonjsModule(function (module, exports) {
function getItem$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.getItem$=void 0;var apiName="util.domainStorage.getItem";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.29"}, _a)), exports.getItem$=getItem$, exports.default=getItem$;
});

unwrapExports(getItem);
var getItem_1 = getItem.getItem$;

var removeItem = createCommonjsModule(function (module, exports) {
function removeItem$(e){return ddSdk.ddSdk.invokeAPI(apiName,e)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.removeItem$=void 0;var apiName="util.domainStorage.removeItem";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.29"}, _a)), exports.removeItem$=removeItem$, exports.default=removeItem$;
});

unwrapExports(removeItem);
var removeItem_1 = removeItem.removeItem$;

var setItem = createCommonjsModule(function (module, exports) {
function setItem$(d){return ddSdk.ddSdk.invokeAPI(apiName,d)}var _a;Object.defineProperty(exports,"__esModule",{value:!0}), exports.setItem$=void 0;var apiName="util.domainStorage.setItem";ddSdk.ddSdk.setAPI(apiName,(_a={}, _a[ddSdk.ENV_ENUM.ios]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.android]={vs:"2.9.0"}, _a[ddSdk.ENV_ENUM.pc]={vs:"4.6.9"}, _a)), exports.setItem$=setItem$, exports.default=setItem$;
});

unwrapExports(setItem);
var setItem_1 = setItem.setItem$;

var apiObj = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0}), exports.apiObj=void 0;exports.apiObj={biz:{ATMBle:{beaconPicker:beaconPicker.beaconPicker$,faceManager:faceManager.faceManager$,punchModePicker:punchModePicker.punchModePicker$},alipay:{pay:pay.pay$},calendar:{chooseDateTime:chooseDateTime.chooseDateTime$,chooseHalfDay:chooseHalfDay.chooseHalfDay$,chooseInterval:chooseInterval.chooseInterval$,chooseOneDay:chooseOneDay.chooseOneDay$},chat:{chooseConversationByCorpId:chooseConversationByCorpId.chooseConversationByCorpId$,collectSticker:collectSticker.collectSticker$,createSceneGroup:createSceneGroup.createSceneGroup$,getRealmCid:getRealmCid.getRealmCid$,locationChatMessage:locationChatMessage.locationChatMessage$,openSingleChat:openSingleChat.openSingleChat$,pickConversation:pickConversation.pickConversation$,sendEmotion:sendEmotion.sendEmotion$,toConversation:toConversation.toConversation$},clipboardData:{setData:setData.setData$},conference:{videoConfCall:videoConfCall.videoConfCall$},contact:{choose:choose.choose$,chooseMobileContacts:chooseMobileContacts.chooseMobileContacts$,complexPicker:complexPicker.complexPicker$,createGroup:createGroup.createGroup$,departmentsPicker:departmentsPicker.departmentsPicker$,externalComplexPicker:externalComplexPicker.externalComplexPicker$,externalEditForm:externalEditForm.externalEditForm$,setRule:setRule.setRule$},cspace:{chooseSpaceDir:chooseSpaceDir.chooseSpaceDir$,delete:_delete.delete$,preview:preview.preview$,saveFile:saveFile.saveFile$},customContact:{choose:choose$2.choose$,multipleChoose:multipleChoose.multipleChoose$},ding:{create:create$1.create$,post:post.post$},event:{notifyWeex:notifyWeex.notifyWeex$},intent:{fetchData:fetchData.fetchData$},iot:{bind:bind.bind$,bindMeetingRoom:bindMeetingRoom.bindMeetingRoom$,getDeviceProperties:getDeviceProperties.getDeviceProperties$,invokeThingService:invokeThingService.invokeThingService$,queryMeetingRoomList:queryMeetingRoomList.queryMeetingRoomList$,setDeviceProperties:setDeviceProperties.setDeviceProperties$,unbind:unbind.unbind$},map:{locate:locate.locate$,search:search.search$,view:view.view$},media:{compressVideo:compressVideo.compressVideo$},microApp:{openApp:openApp.openApp$},navigation:{close:close.close$,goBack:goBack.goBack$,hideBar:hideBar.hideBar$,quit:quit.quit$,replace:replace.replace$,setIcon:setIcon.setIcon$,setLeft:setLeft.setLeft$,setMenu:setMenu.setMenu$,setRight:setRight.setRight$,setTitle:setTitle.setTitle$},realm:{subscribe:subscribe.subscribe$,unsubscribe:unsubscribe.unsubscribe$},shortCut:{addShortCut:addShortCut.addShortCut$},store:{closeUnpayOrder:closeUnpayOrder.closeUnpayOrder$,createOrder:createOrder.createOrder$,getPayUrl:getPayUrl.getPayUrl$,inquiry:inquiry.inquiry$},telephone:{call:call$1.call$,checkBizCall:checkBizCall.checkBizCall$,quickCallList:quickCallList.quickCallList$,showCallMenu:showCallMenu.showCallMenu$},user:{checkPassword:checkPassword.checkPassword$,get:get.get$},util:{chosen:chosen.chosen$,datepicker:datepicker.datepicker$,datetimepicker:datetimepicker.datetimepicker$,decrypt:decrypt.decrypt$,downloadFile:downloadFile.downloadFile$,encrypt:encrypt.encrypt$,isLocalFileExist:isLocalFileExist.isLocalFileExist$,multiSelect:multiSelect.multiSelect$,open:open.open$,openLink:openLink.openLink$,openLocalFile:openLocalFile.openLocalFile$,openModal:openModal.openModal$,openSlidePanel:openSlidePanel.openSlidePanel$,presentWindow:presentWindow.presentWindow$,previewImage:previewImage.previewImage$,previewVideo:previewVideo.previewVideo$,saveImage:saveImage.saveImage$,scan:scan.scan$,scanCard:scanCard.scanCard$,setScreenBrightnessAndKeepOn:setScreenBrightnessAndKeepOn.setScreenBrightnessAndKeepOn$,share:share.share$,shareImage:shareImage.shareImage$,startDocSign:startDocSign.startDocSign$,systemShare:systemShare.systemShare$,timepicker:timepicker.timepicker$,uploadAttachment:uploadAttachment.uploadAttachment$,uploadImage:uploadImage.uploadImage$,uploadImageFromCamera:uploadImageFromCamera.uploadImageFromCamera$,ut:ut.ut$},verify:{openBindIDCard:openBindIDCard.openBindIDCard$,startAuth:startAuth.startAuth$}},channel:{permission:{requestAuthCode:requestAuthCode.requestAuthCode$}},device:{accelerometer:{clearShake:clearShake.clearShake$,watchShake:watchShake.watchShake$},audio:{download:download.download$,onPlayEnd:onPlayEnd.onPlayEnd$,onRecordEnd:onRecordEnd.onRecordEnd$,pause:pause.pause$,play:play.play$,resume:resume.resume$,startRecord:startRecord.startRecord$,stop:stop.stop$,stopRecord:stopRecord.stopRecord$,translateVoice:translateVoice.translateVoice$},base:{getInterface:getInterface.getInterface$,getPhoneInfo:getPhoneInfo.getPhoneInfo$,getUUID:getUUID.getUUID$,getWifiStatus:getWifiStatus.getWifiStatus$},connection:{getNetworkType:getNetworkType.getNetworkType$},geolocation:{checkPermission:checkPermission.checkPermission$,get:get$2.get$,start:start.start$,status:status.status$,stop:stop$2.stop$},launcher:{checkInstalledApps:checkInstalledApps.checkInstalledApps$,launchApp:launchApp.launchApp$},nfc:{nfcRead:nfcRead.nfcRead$,nfcStop:nfcStop.nfcStop$,nfcWrite:nfcWrite.nfcWrite$},notification:{actionSheet:actionSheet.actionSheet$,alert:alert$1.alert$,confirm:confirm.confirm$,extendModal:extendModal.extendModal$,hidePreloader:hidePreloader.hidePreloader$,modal:modal.modal$,prompt:prompt.prompt$,showPreloader:showPreloader.showPreloader$,toast:toast.toast$,vibrate:vibrate.vibrate$},screen:{insetAdjust:insetAdjust.insetAdjust$,resetView:resetView.resetView$,rotateView:rotateView.rotateView$}},net:{bjGovApn:{loginGovNet:loginGovNet.loginGovNet$}},runtime:{message:{fetch:fetch.fetch$,post:post$2.post$},permission:{requestAuthCode:requestAuthCode$2.requestAuthCode$,requestOperateAuthCode:requestOperateAuthCode.requestOperateAuthCode$}},ui:{input:{plain:plain.plain$},nav:{close:close$2.close$,getCurrentId:getCurrentId.getCurrentId$,go:go.go$,preload:preload.preload$,recycle:recycle.recycle$},progressBar:{setColors:setColors.setColors$},pullToRefresh:{disable:disable.disable$,enable:enable.enable$,stop:stop$4.stop$},webViewBounce:{disable:disable$2.disable$,enable:enable$2.enable$}},util:{domainStorage:{getItem:getItem.getItem$,removeItem:removeItem.removeItem$,setItem:setItem.setItem$}}};
});

unwrapExports(apiObj);
var apiObj_1 = apiObj.apiObj;

var dd$2=Object.assign(union,apiObj.apiObj);var dingtalkJsapi=dd$2;

// 公共配置 //

/** mjava path: 开发dev, 生产prod, 测试test */
var api = "";

/** 设置为不超时 */
var timeout = 0;

/** 授权 */
var token = "";

/** 宜搭分页上限*/
var pageSize = 100;

/** 宜搭明细数据上限 */
var detailCount = 500;

/** 宜搭数据查询上限 */
var upperLimit = 30000;

/** 授权企业ID */
var corpId$1 = "";

/** 授权登录加密字符 */
var nonceStr$1 = "";

/** 导出配置信息 */
var config = { api: api, timeout: timeout, token: token, pageSize: pageSize, detailCount: detailCount, upperLimit: upperLimit, corpId: corpId$1, nonceStr: nonceStr$1 };

var browser = {};

// 关闭页面
browser.closeCurrentTab = function () {
  try {
    window.opener = window;
    var win = window.open("", "_self");
    win.close();
    // frame的时候
    if (window.top) window.top.close();
  } catch (e) {
    console.log('关闭页面', e);
  }
};

// NOTE: 未默认解构 default - 不能直接解构, 不识别. 不能有效减少包体积
var dd$1 = dingtalkJsapi;

var ding = {}; // 钉钉jsapi对象
var $loading = false; // 避免多个请求闪屏

// loading 显示
ding.showLoading = function () {
  var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "拼命加载中...";

  if ($loading) return;
  $loading = true;
  dd$1.device.notification.showPreloader({
    showIcon: true,
    text: message
  });
};

// loading 关闭
ding.hideLoading = function () {
  if (!$loading) return;
  dd$1.device.notification.hidePreloader();
  $loading = false;
};

// toast 提示: info 详见 https://ding-doc.dingtalk.com/doc#/dev/oo98ye/6pwsuy
ding.showMessageToast = function () {
  var info = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  if (!info.message) return;
  dd$1.device.notification.toast(info);
};

// 获取定位
ding.getLocation = function () {
  return new _Promise(function (resolve, reject) {
    dd$1.device.geolocation.get({
      targetAccuracy: 200,
      coordinate: 1,
      withReGeocode: true,
      useCache: true,
      onSuccess: function onSuccess(result) {
        resolve(result);
      },
      onFail: function onFail(err) {
        reject(err);
      }
    });
  });
};

// 根据chatId跳转到对应会话
ding.toConversation = function (chatId) {
  return new _Promise(function (resolve, reject) {
    dd$1.biz.chat.toConversation({
      corpId: config.corpId,
      chatId: chatId,
      onSuccess: function onSuccess() {
        return resolve();
      },
      onFail: function onFail(err) {
        return reject(err);
      }
    });
  });
};

// 图片预览: 支持缩放和左右切换
ding.previewImageScale = function (urls) {
  var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (!urls) return;
  dd$1.biz.previewImage({
    urls: urls,
    current: urls[index]
  });
};

// 获取UUID
ding.getUUID = function () {
  return new _Promise(function (resolve) {
    dd$1.device.base.getUUID({
      onSuccess: function onSuccess(data) {
        resolve(data);
      }
    });
  });
};

/** @exports 钉钉新开页面方法 */
ding.openNavigation = function (url, isReplace) {
  if (!url) return;
  // 区分环境, 兼容分享
  if (dd$1.env.platform === "notInDingTalk") {
    window.open(url, isReplace ? "_self" : "");
  } else {
    if (isReplace) {
      dd$1.biz.navigation.replace({ url: url });
    } else {
      dd$1.biz.util.openLink({ url: url });
    }
  }
};

/** @exports 退出页面方法:兼容浏览器 */
ding.closeNavigationForDomEvent = function (that) {
  // 延迟: 体检 + 弹出离开确认框
  if (dd$1.env.platform === "notInDingTalk") {
    setTimeout(function () {
      return browser.closeCurrentTab();
    }, 1000);
    return false;
  }
  if (dd$1.env.platform === "ios" || dd$1.env.platform === "android") {
    setTimeout(function () {
      return mjs.com.showMessage(that, "提交成功");
    }, 350);
    setTimeout(function () {
      return dd$1.biz.navigation.close({});
    }, 750);
    return true;
  }
  if (dd$1.env.platform === "pc") {
    // 钉钉BUG: 只在SlidePanel和Modal里起作用
    setTimeout(function () {
      return biz.navigation.quit({});
    }, 750);
    return true;
  }
};

/** @exports 设置右侧导航栏: [{ id: "1", text: "附 件", url: "http://alading-20210318.oss-cn-shanghai.aliyuncs.com/assets/nav-link.png",},] */
ding.settingNavigationMenu = function () {
  var menus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var isClear = arguments[1];
  var callback = arguments[2];

  if (isClear) {
    menus = [{
      id: "999",
      text: " "
    }];
  }
  dd$1.biz.navigation.setMenu({
    items: menus,
    onSuccess: function onSuccess(result) {
      callback && callback(result);
    }
  });
};

// 注册钉钉js接口鉴权
ding.registerConfig = function (agentId, timeStamp, signature) {
  dd$1.config({
    agentId: agentId,
    corpId: corpId,
    timeStamp: timeStamp,
    nonceStr: nonceStr,
    signature: signature,
    type: 0,
    jsApiList: ["biz.chat.toConversation"] // 注意：不要带dd。
  });
};

// 注册配置异常抛出
dd$1.error(function (error) {
  window.alert(_JSON$stringify(error));
});

ding.dd = dd$1;

// 回调事件
var bus = {
  // dom监听按钮点击: 提交事件回调, 添加成功执行 [页面存在beforeSubmit下需要手动调用]
  DOM_CALLBACK_SUBMIT: null,
  // dom监听按钮点击: 审批事件回调, 入参有按钮的文本
  DOM_CALLBACK_APPROVE: null
};

// todolist  作为判断条件; 配置config, 方法名称改为register; dom操作方法名称更新

var dom = {};

// 异常打印和评论按钮: 兼容BUG, 平台设置不生效
dom.removeMobInvalid = function (that) {
  var doms = document.querySelectorAll(".flow-operation-button");
  doms.forEach(function (ele) {
    if (["评论", "打印"].includes(ele.textContent)) ele.remove();
  });
};

// 设置iframe组件, 并且加载;链接
dom.iframeLoadFullScreen = function (that, _ref) {
  var compId = _ref.compId,
      link = _ref.link,
      _ref$bottom = _ref.bottom,
      bottom = _ref$bottom === undefined ? 44 : _ref$bottom;

  document.getElementById("frame_" + compId).style.height = window.screen.height - bottom + "px";
  that.$(compId).set("src", link);
};

// 去除tab间距样式调整
dom.removeLayoutSpace = function (that) {
  var doms = document.querySelectorAll(".next-tabs-content");
  doms.forEach(function (elem) {
    return elem.remove();
  });
};

// 审批页面: button事件的3种绑定方式以及触发逻辑：https://www.cnblogs.com/ooo0/p/7742214.html
dom.registerFlowEvent = function (that) {
  if (mjs.env != 2) return;
  setTimeout(function () {
    var approveEvent = function approveEvent(title) {
      // 回调审批事件
      if (bus.DOM_CALLBACK_APPROVE) {
        bus.DOM_CALLBACK_APPROVE(that, title);
        return;
      }
    };
    // PC端
    var doms = document.querySelectorAll(".flow-button"); // 使用getElementsByClassName拿不到dom实体
    if (doms.length) {
      // 读取弹出框按钮: 延迟体验
      var _listenerDialog = function _listenerDialog(title) {
        setTimeout(function () {
          // 多个使用不需要添加空格
          document.querySelectorAll(".next-btn.next-small").forEach(function (ele) {
            // 取消刷新页面: dom二次会失效
            if ("取消" == ele.innerText) {
              ele.onclick = function () {
                window.location.reload();
              };
            }
            if ("确认" == ele.innerText) {
              ele.onclick = function () {
                approveEvent(title);
              };
            }
          });
        }, 200);
      };
      doms.forEach(function (ele) {
        // 目前退回为加签逻辑 ==> 退回页面环境为编辑态值2
        if (["同意", "拒绝", "退回", "转交", "提交"].includes(ele.innerText)) {
          ele.onclick = function () {
            _listenerDialog(ele.innerText);
          };
        }
      });
      return;
    }
    // 移动端
    var listenerDialog = function listenerDialog(title) {
      // 读取弹出框按钮: 延迟体验
      setTimeout(function () {
        var doms = document.querySelectorAll(".t-button"); // 其它
        if (!doms.length) doms = document.querySelectorAll(".mt-button"); // 退回
        // 取消刷新页面: dom二次会失效
        document.querySelectorAll(".flow-layer-header-left").forEach(function (ele) {
          ele.onclick = function () {
            window.location.reload();
          };
        });
        doms.forEach(function (ele) {
          if (["提交", "确认退回"].includes(ele.innerText)) {
            ele.onclick = function () {
              approveEvent(title);
            };
          }
        });
      }, 200);
    };
    document.querySelectorAll(".icon-box").forEach(function (ele) {
      // 目前退回为加签逻辑 ==> 退回页面环境为编辑态值2
      if (["退回", "转交", "提交"].includes(ele.innerText)) {
        ele.onclick = function () {
          listenerDialog(ele.innerText);
        };
      }
    });
    document.querySelectorAll(".mt-button").forEach(function (ele) {
      // 目前退回为加签逻辑 ==> 退回页面环境为编辑态值2
      if (["同意", "拒绝"].includes(ele.innerText)) {
        ele.onclick = function () {
          listenerDialog(ele.innerText);
        };
      }
    });
  }, 200);
};

// 提交页面: button事件的3种绑定方式以及触发逻辑：https://www.cnblogs.com/ooo0/p/7742214.html
dom.closeCurrentTabForSubmit = function (that) {
  // 退回再提交走审批事件, 目前退回为加签逻辑 ==> 退回页面环境为编辑态值2
  if (mjs.env) return;
  function closeTab() {
    // 执行顺序: onclick > addEventListener > beforeSubmit
    // 特别说明：在提交情况下，页面存在beforeSubmit，相关的逻辑在beforeSubmit下要手动调用，因为这里是直接触发若是有判断情况下决定权交给beforeSubmit处理
    if (that.beforeSubmit) return;
    // 异步不会等待
    dom.closeTabCompatibilityBeforeSubmit(that);
  }
  // PC端 & 移动端
  var doms = document.querySelectorAll(".deep-form-submit");
  if (!doms.length) return;
  doms[0].addEventListener("click", closeTab, false);
};

// 兼容 beforeSubmit 情况下, 异步且在按钮事件之后的问题 执行顺序: onclick > addEventListener > beforeSubmit
dom.closeTabCompatibilityBeforeSubmit = function (that) {
  bus.DOM_CALLBACK_SUBMIT(that);
  // 关闭页面: 延迟体验
  ding.closeNavigationForDomEvent(that);
};

// 隐藏tab空白
dom.removeTabLayoutContainer = function () {
  var elemP = document.querySelectorAll(".next-tabs-content")[0];
  if (elemP) elemP.remove();
};

// 自定义页面全屏: pc
dom.removeSpaceForCustomPage = function () {
  var page = document.getElementsByClassName("vc-rootcontent");
  if (page.length) {
    page[0].style.margin = "0px";
    page[0].className = "";
  }
};

// 隐藏默认打印模板
dom.removePrinterForDefault = function () {
  if (!mjs.env) return;
  // pc - 全屏
  var doms = document.querySelectorAll(".next-icon-printer");
  if (doms.length) {
    doms[0].onclick = function () {
      setTimeout(function () {
        document.querySelectorAll(".next-menu-item").forEach(function (elem) {
          if (elem.innerText == "默认模板") {
            elem.remove();
          }
        });
      }, 100);
    };
  }
  // pc - 侧边栏
  doms = document.querySelectorAll(".next-yida-button-iconOnly");
  if (doms.length) {
    doms[2].onclick = function () {
      setTimeout(function () {
        document.querySelectorAll(".next-menu-item").forEach(function (elem) {
          if (elem.innerText == "打印") {
            elem.onclick = function () {
              setTimeout(function () {
                document.querySelectorAll(".next-menu-item").forEach(function (elem) {
                  if (elem.innerText == "默认模板") {
                    elem.remove();
                  }
                });
              }, 100);
            };
          }
        });
      }, 100);
    };
  }
  // mobile
  setTimeout(function () {
    doms = document.querySelectorAll(".icon-box.dayin");
    if (doms.length) {
      doms[0].onclick = function () {
        setTimeout(function () {
          document.querySelectorAll(".mt-actionsheet-option").forEach(function (elem) {
            if (elem.innerText == "默认模板") {
              elem.remove();
            }
          });
        }, 100);
      };
    }
  }, 400);
};

// 隐藏撤销按钮
dom.removeTerminationButton = function () {
  if (!mjs.env) return;
  // pc
  setTimeout(function () {
    var doms = document.querySelectorAll(".deep-button-group-item");
    if (doms.length) {
      doms[0].remove();
      return;
    }
  }, 200);
  // mobile
  setTimeout(function () {
    var doms = document.querySelectorAll(".icon-box.chexiao");
    if (doms.length) {
      doms[0].remove();
    }
  }, 400);
};

var f$2 = _wks;

var _wksExt = {
	f: f$2
};

var iterator$2 = _wksExt.f('iterator');

var iterator = createCommonjsModule(function (module) {
module.exports = { "default": iterator$2, __esModule: true };
});

unwrapExports(iterator);

var _meta = createCommonjsModule(function (module) {
var META = _uid('meta');


var setDesc = _objectDp.f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !_fails(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!_isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!_has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!_has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !_has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};
});

var _meta_1 = _meta.KEY;
var _meta_2 = _meta.NEED;
var _meta_3 = _meta.fastKey;
var _meta_4 = _meta.getWeak;
var _meta_5 = _meta.onFreeze;

var defineProperty = _objectDp.f;
var _wksDefine = function (name) {
  var $Symbol = _core.Symbol || (_core.Symbol = _library ? {} : _global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: _wksExt.f(name) });
};

var f$3 = Object.getOwnPropertySymbols;

var _objectGops = {
	f: f$3
};

var f$4 = {}.propertyIsEnumerable;

var _objectPie = {
	f: f$4
};

// all enumerable object keys, includes symbols



var _enumKeys = function (it) {
  var result = _objectKeys(it);
  var getSymbols = _objectGops.f;
  if (getSymbols) {
    var symbols = getSymbols(it);
    var isEnum = _objectPie.f;
    var i = 0;
    var key;
    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
  } return result;
};

// 7.2.2 IsArray(argument)

var _isArray = Array.isArray || function isArray(arg) {
  return _cof(arg) == 'Array';
};

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)

var hiddenKeys = _enumBugKeys.concat('length', 'prototype');

var f$6 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return _objectKeysInternal(O, hiddenKeys);
};

var _objectGopn = {
	f: f$6
};

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window

var gOPN$1 = _objectGopn.f;
var toString$1 = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN$1(it);
  } catch (e) {
    return windowNames.slice();
  }
};

var f$5 = function getOwnPropertyNames(it) {
  return windowNames && toString$1.call(it) == '[object Window]' ? getWindowNames(it) : gOPN$1(_toIobject(it));
};

var _objectGopnExt = {
	f: f$5
};

var gOPD$1 = Object.getOwnPropertyDescriptor;

var f$7 = _descriptors ? gOPD$1 : function getOwnPropertyDescriptor(O, P) {
  O = _toIobject(O);
  P = _toPrimitive(P, true);
  if (_ie8DomDefine) try {
    return gOPD$1(O, P);
  } catch (e) { /* empty */ }
  if (_has(O, P)) return _propertyDesc(!_objectPie.f.call(O, P), O[P]);
};

var _objectGopd = {
	f: f$7
};

// ECMAScript 6 symbols shim





var META = _meta.KEY;





















var gOPD = _objectGopd.f;
var dP$1 = _objectDp.f;
var gOPN = _objectGopnExt.f;
var $Symbol = _global.Symbol;
var $JSON$1 = _global.JSON;
var _stringify = $JSON$1 && $JSON$1.stringify;
var PROTOTYPE$2 = 'prototype';
var HIDDEN = _wks('_hidden');
var TO_PRIMITIVE = _wks('toPrimitive');
var isEnum = {}.propertyIsEnumerable;
var SymbolRegistry = _shared('symbol-registry');
var AllSymbols = _shared('symbols');
var OPSymbols = _shared('op-symbols');
var ObjectProto$1 = Object[PROTOTYPE$2];
var USE_NATIVE$1 = typeof $Symbol == 'function' && !!_objectGops.f;
var QObject = _global.QObject;
// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var setter = !QObject || !QObject[PROTOTYPE$2] || !QObject[PROTOTYPE$2].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDesc = _descriptors && _fails(function () {
  return _objectCreate(dP$1({}, 'a', {
    get: function () { return dP$1(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (it, key, D) {
  var protoDesc = gOPD(ObjectProto$1, key);
  if (protoDesc) delete ObjectProto$1[key];
  dP$1(it, key, D);
  if (protoDesc && it !== ObjectProto$1) dP$1(ObjectProto$1, key, protoDesc);
} : dP$1;

var wrap = function (tag) {
  var sym = AllSymbols[tag] = _objectCreate($Symbol[PROTOTYPE$2]);
  sym._k = tag;
  return sym;
};

var isSymbol = USE_NATIVE$1 && typeof $Symbol.iterator == 'symbol' ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  return it instanceof $Symbol;
};

var $defineProperty = function defineProperty(it, key, D) {
  if (it === ObjectProto$1) $defineProperty(OPSymbols, key, D);
  _anObject(it);
  key = _toPrimitive(key, true);
  _anObject(D);
  if (_has(AllSymbols, key)) {
    if (!D.enumerable) {
      if (!_has(it, HIDDEN)) dP$1(it, HIDDEN, _propertyDesc(1, {}));
      it[HIDDEN][key] = true;
    } else {
      if (_has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
      D = _objectCreate(D, { enumerable: _propertyDesc(0, false) });
    } return setSymbolDesc(it, key, D);
  } return dP$1(it, key, D);
};
var $defineProperties = function defineProperties(it, P) {
  _anObject(it);
  var keys = _enumKeys(P = _toIobject(P));
  var i = 0;
  var l = keys.length;
  var key;
  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
  return it;
};
var $create = function create(it, P) {
  return P === undefined ? _objectCreate(it) : $defineProperties(_objectCreate(it), P);
};
var $propertyIsEnumerable = function propertyIsEnumerable(key) {
  var E = isEnum.call(this, key = _toPrimitive(key, true));
  if (this === ObjectProto$1 && _has(AllSymbols, key) && !_has(OPSymbols, key)) return false;
  return E || !_has(this, key) || !_has(AllSymbols, key) || _has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
  it = _toIobject(it);
  key = _toPrimitive(key, true);
  if (it === ObjectProto$1 && _has(AllSymbols, key) && !_has(OPSymbols, key)) return;
  var D = gOPD(it, key);
  if (D && _has(AllSymbols, key) && !(_has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
  return D;
};
var $getOwnPropertyNames = function getOwnPropertyNames(it) {
  var names = gOPN(_toIobject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (!_has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
  } return result;
};
var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
  var IS_OP = it === ObjectProto$1;
  var names = gOPN(IS_OP ? OPSymbols : _toIobject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (_has(AllSymbols, key = names[i++]) && (IS_OP ? _has(ObjectProto$1, key) : true)) result.push(AllSymbols[key]);
  } return result;
};

// 19.4.1.1 Symbol([description])
if (!USE_NATIVE$1) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
    var tag = _uid(arguments.length > 0 ? arguments[0] : undefined);
    var $set = function (value) {
      if (this === ObjectProto$1) $set.call(OPSymbols, value);
      if (_has(this, HIDDEN) && _has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDesc(this, tag, _propertyDesc(1, value));
    };
    if (_descriptors && setter) setSymbolDesc(ObjectProto$1, tag, { configurable: true, set: $set });
    return wrap(tag);
  };
  _redefine($Symbol[PROTOTYPE$2], 'toString', function toString() {
    return this._k;
  });

  _objectGopd.f = $getOwnPropertyDescriptor;
  _objectDp.f = $defineProperty;
  _objectGopn.f = _objectGopnExt.f = $getOwnPropertyNames;
  _objectPie.f = $propertyIsEnumerable;
  _objectGops.f = $getOwnPropertySymbols;

  if (_descriptors && !_library) {
    _redefine(ObjectProto$1, 'propertyIsEnumerable', $propertyIsEnumerable, true);
  }

  _wksExt.f = function (name) {
    return wrap(_wks(name));
  };
}

_export(_export.G + _export.W + _export.F * !USE_NATIVE$1, { Symbol: $Symbol });

for (var es6Symbols = (
  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14
  'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'
).split(','), j = 0; es6Symbols.length > j;)_wks(es6Symbols[j++]);

for (var wellKnownSymbols = _objectKeys(_wks.store), k = 0; wellKnownSymbols.length > k;) _wksDefine(wellKnownSymbols[k++]);

_export(_export.S + _export.F * !USE_NATIVE$1, 'Symbol', {
  // 19.4.2.1 Symbol.for(key)
  'for': function (key) {
    return _has(SymbolRegistry, key += '')
      ? SymbolRegistry[key]
      : SymbolRegistry[key] = $Symbol(key);
  },
  // 19.4.2.5 Symbol.keyFor(sym)
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol!');
    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;
  },
  useSetter: function () { setter = true; },
  useSimple: function () { setter = false; }
});

_export(_export.S + _export.F * !USE_NATIVE$1, 'Object', {
  // 19.1.2.2 Object.create(O [, Properties])
  create: $create,
  // 19.1.2.4 Object.defineProperty(O, P, Attributes)
  defineProperty: $defineProperty,
  // 19.1.2.3 Object.defineProperties(O, Properties)
  defineProperties: $defineProperties,
  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,
  // 19.1.2.7 Object.getOwnPropertyNames(O)
  getOwnPropertyNames: $getOwnPropertyNames,
  // 19.1.2.8 Object.getOwnPropertySymbols(O)
  getOwnPropertySymbols: $getOwnPropertySymbols
});

// Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
// https://bugs.chromium.org/p/v8/issues/detail?id=3443
var FAILS_ON_PRIMITIVES = _fails(function () { _objectGops.f(1); });

_export(_export.S + _export.F * FAILS_ON_PRIMITIVES, 'Object', {
  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
    return _objectGops.f(_toObject(it));
  }
});

// 24.3.2 JSON.stringify(value [, replacer [, space]])
$JSON$1 && _export(_export.S + _export.F * (!USE_NATIVE$1 || _fails(function () {
  var S = $Symbol();
  // MS Edge converts symbol values to JSON as {}
  // WebKit converts symbol values to JSON as null
  // V8 throws on boxed symbols
  return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';
})), 'JSON', {
  stringify: function stringify(it) {
    var args = [it];
    var i = 1;
    var replacer, $replacer;
    while (arguments.length > i) args.push(arguments[i++]);
    $replacer = replacer = args[1];
    if (!_isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined
    if (!_isArray(replacer)) replacer = function (key, value) {
      if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
      if (!isSymbol(value)) return value;
    };
    args[1] = replacer;
    return _stringify.apply($JSON$1, args);
  }
});

// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)
$Symbol[PROTOTYPE$2][TO_PRIMITIVE] || _hide($Symbol[PROTOTYPE$2], TO_PRIMITIVE, $Symbol[PROTOTYPE$2].valueOf);
// 19.4.3.5 Symbol.prototype[@@toStringTag]
_setToStringTag($Symbol, 'Symbol');
// 20.2.1.9 Math[@@toStringTag]
_setToStringTag(Math, 'Math', true);
// 24.3.3 JSON[@@toStringTag]
_setToStringTag(_global.JSON, 'JSON', true);

_wksDefine('asyncIterator');

_wksDefine('observable');

var symbol$2 = _core.Symbol;

var symbol = createCommonjsModule(function (module) {
module.exports = { "default": symbol$2, __esModule: true };
});

unwrapExports(symbol);

var _typeof_1 = createCommonjsModule(function (module, exports) {
exports.__esModule = true;



var _iterator2 = _interopRequireDefault(iterator);



var _symbol2 = _interopRequireDefault(symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};
});

var _typeof = unwrapExports(_typeof_1);

/**
 * @export 函数节流:设置一个可执行状态,interval时间内不再调用就触发fn
 */
function throttle(fn) {
  var interval = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 300;
  var scope = arguments[2];

  var status = false;
  return function () {
    if (status) return;
    status = true;
    fn.apply(scope || this, arguments);
    setTimeout(function () {
      status = false;
    }, interval);
  };
}

/**
 * @export 函数防抖:每次调用重置计时器,delay时间内不再调用就触发fn
 * @function 页面内防抖 clearTimeout(this.timer); this.timer = null; this.timer = setTimeout(() => { if (_this.timer) _query(); }, 300);
 * @function 页面内防抖, 在methods内直接引用debounce, querySearch: debounce(async function(done) { ... })
 */
function debounce(fn) {
  var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 300;

  var timer;
  return function () {
    var _this = this;

    var args = arguments;
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
    timer = setTimeout(function () {
      fn.apply(_this, args);
    }, delay);
  };
}

/**
 * @export 对象深度拷贝
 */


/**
 * @export 图片地址转base64:异步
 */


var optimize = {
  throttle: throttle, debounce: debounce
};

var SS = {};
var LS = {};
var CK = {};

// -------------------------------- //
//    sessionStorage - str\obj      //
// -------------------------------- //

SS.SET = function (key, data) {
  if ((typeof data === "undefined" ? "undefined" : _typeof(data)) == "object") data = _JSON$stringify(data);
  sessionStorage.setItem(key, data);
};

SS.GET = function (key) {
  var data = sessionStorage.getItem(key);
  if (/"/.test(data)) data = JSON.parse(data);
  return data;
};

SS.REMOVE = function (key) {
  sessionStorage.removeItem(key);
};

SS.CLEAR = function () {
  sessionStorage.clear();
};

// -------------------------------- //
//     localStorage - str\obj       //
// -------------------------------- //

LS.SET = function (key, data) {
  if ((typeof data === "undefined" ? "undefined" : _typeof(data)) == "object") data = _JSON$stringify(data);
  localStorage.setItem(key, data);
};

LS.GET = function (key) {
  var data = localStorage.getItem(key);
  if (/"/.test(data)) data = JSON.parse(data);
  return data;
};

LS.REMOVE = function (key) {
  localStorage.removeItem(key);
};

LS.CLEAR = function () {
  localStorage.clear();
};

// cookie 设置过多可能会导致浏览器异常
LS.SET_EXPIRE = function (key, data, expire) {
  data = {
    expire: Date.now() + expire * 1000,
    data: data
  };
  this.SET(key, data);
};

LS.GET_EXPIRE = function (key) {
  var data = this.GET(key);
  if (data && data.expire >= Date.now()) {
    data = data.data;
  } else {
    this.REMOVE(key);
    data = null;
  }
  return data;
};

// -------------------------------- //
//         cookies - expires        //
// -------------------------------- //

CK.SET = function (name, value, seconds) {
  if ((typeof value === "undefined" ? "undefined" : _typeof(value)) == "object") value = _JSON$stringify(value);
  var expires = "";
  if (seconds != 0) {
    //设置cookie生存时间
    var date = new Date();
    date.setTime(date.getTime() + seconds * 1000);
    expires = "; expires=" + date.toGMTString();
  }
  document.cookie = name + "=" + escape(value) + expires + "; path=/"; //转码并赋值
};

CK.GET = function (name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(";"); // 把cookie分割成组
  for (var i = 0; i < ca.length; i++) {
    var c = ca[i]; // 取得字符串
    while (c.charAt(0) == " ") {
      // 判断一下字符串有没有前导空格
      c = c.substring(1, c.length); // 有的话，从第二位开始取
    }
    if (c.indexOf(nameEQ) == 0) {
      // 如果含有需要的name
      var value = unescape(c.substring(nameEQ.length, c.length));
      if (/"/.test(value)) value = JSON.parse(value);
      return value; // 解码并截取我们要值
    }
  }
  return false;
};

CK.REMOVE = function (name) {
  this.SET(name, "", -1);
};

/* export default 导出会加一层 default 包裹:  import 导入时默认已解构
import { SS as storage } from "storage"; // import { SS } from "storage"; */
var storage = { SS: SS, LS: LS, CK: CK };

var token$1 = /d{1,4}|M{1,4}|YY(?:YY)?|S{1,3}|Do|ZZ|Z|([HhMsDm])\1?|[aA]|"[^"]*"|'[^']*'/g;
var twoDigitsOptional = "[1-9]\\d?";
var twoDigits = "\\d\\d";
var threeDigits = "\\d{3}";
var fourDigits = "\\d{4}";
var word = "[^\\s]+";
var literal = /\[([^]*?)\]/gm;
function shorten(arr, sLen) {
    var newArr = [];
    for (var i = 0, len = arr.length; i < len; i++) {
        newArr.push(arr[i].substr(0, sLen));
    }
    return newArr;
}
var monthUpdate = function (arrName) { return function (v, i18n) {
    var lowerCaseArr = i18n[arrName].map(function (v) { return v.toLowerCase(); });
    var index = lowerCaseArr.indexOf(v.toLowerCase());
    if (index > -1) {
        return index;
    }
    return null;
}; };
function assign(origObj) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
        var obj = args_1[_a];
        for (var key in obj) {
            // @ts-ignore ex
            origObj[key] = obj[key];
        }
    }
    return origObj;
}
var dayNames = [
    "Sunday",
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday"
];
var monthNames = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
];
var monthNamesShort = shorten(monthNames, 3);
var dayNamesShort = shorten(dayNames, 3);
var defaultI18n = {
    dayNamesShort: dayNamesShort,
    dayNames: dayNames,
    monthNamesShort: monthNamesShort,
    monthNames: monthNames,
    amPm: ["am", "pm"],
    DoFn: function (dayOfMonth) {
        return (dayOfMonth +
            ["th", "st", "nd", "rd"][dayOfMonth % 10 > 3
                ? 0
                : ((dayOfMonth - (dayOfMonth % 10) !== 10 ? 1 : 0) * dayOfMonth) % 10]);
    }
};
var globalI18n = assign({}, defaultI18n);
var regexEscape = function (str) {
    return str.replace(/[|\\{()[^$+*?.-]/g, "\\$&");
};
var pad = function (val, len) {
    if (len === void 0) { len = 2; }
    val = String(val);
    while (val.length < len) {
        val = "0" + val;
    }
    return val;
};
var formatFlags = {
    D: function (dateObj) { return String(dateObj.getDate()); },
    DD: function (dateObj) { return pad(dateObj.getDate()); },
    Do: function (dateObj, i18n) {
        return i18n.DoFn(dateObj.getDate());
    },
    d: function (dateObj) { return String(dateObj.getDay()); },
    dd: function (dateObj) { return pad(dateObj.getDay()); },
    ddd: function (dateObj, i18n) {
        return i18n.dayNamesShort[dateObj.getDay()];
    },
    dddd: function (dateObj, i18n) {
        return i18n.dayNames[dateObj.getDay()];
    },
    M: function (dateObj) { return String(dateObj.getMonth() + 1); },
    MM: function (dateObj) { return pad(dateObj.getMonth() + 1); },
    MMM: function (dateObj, i18n) {
        return i18n.monthNamesShort[dateObj.getMonth()];
    },
    MMMM: function (dateObj, i18n) {
        return i18n.monthNames[dateObj.getMonth()];
    },
    YY: function (dateObj) {
        return pad(String(dateObj.getFullYear()), 4).substr(2);
    },
    YYYY: function (dateObj) { return pad(dateObj.getFullYear(), 4); },
    h: function (dateObj) { return String(dateObj.getHours() % 12 || 12); },
    hh: function (dateObj) { return pad(dateObj.getHours() % 12 || 12); },
    H: function (dateObj) { return String(dateObj.getHours()); },
    HH: function (dateObj) { return pad(dateObj.getHours()); },
    m: function (dateObj) { return String(dateObj.getMinutes()); },
    mm: function (dateObj) { return pad(dateObj.getMinutes()); },
    s: function (dateObj) { return String(dateObj.getSeconds()); },
    ss: function (dateObj) { return pad(dateObj.getSeconds()); },
    S: function (dateObj) {
        return String(Math.round(dateObj.getMilliseconds() / 100));
    },
    SS: function (dateObj) {
        return pad(Math.round(dateObj.getMilliseconds() / 10), 2);
    },
    SSS: function (dateObj) { return pad(dateObj.getMilliseconds(), 3); },
    a: function (dateObj, i18n) {
        return dateObj.getHours() < 12 ? i18n.amPm[0] : i18n.amPm[1];
    },
    A: function (dateObj, i18n) {
        return dateObj.getHours() < 12
            ? i18n.amPm[0].toUpperCase()
            : i18n.amPm[1].toUpperCase();
    },
    ZZ: function (dateObj) {
        var offset = dateObj.getTimezoneOffset();
        return ((offset > 0 ? "-" : "+") +
            pad(Math.floor(Math.abs(offset) / 60) * 100 + (Math.abs(offset) % 60), 4));
    },
    Z: function (dateObj) {
        var offset = dateObj.getTimezoneOffset();
        return ((offset > 0 ? "-" : "+") +
            pad(Math.floor(Math.abs(offset) / 60), 2) +
            ":" +
            pad(Math.abs(offset) % 60, 2));
    }
};
var monthParse = function (v) { return +v - 1; };
var emptyDigits = [null, twoDigitsOptional];
var emptyWord = [null, word];
var amPm = [
    "isPm",
    word,
    function (v, i18n) {
        var val = v.toLowerCase();
        if (val === i18n.amPm[0]) {
            return 0;
        }
        else if (val === i18n.amPm[1]) {
            return 1;
        }
        return null;
    }
];
var timezoneOffset = [
    "timezoneOffset",
    "[^\\s]*?[\\+\\-]\\d\\d:?\\d\\d|[^\\s]*?Z?",
    function (v) {
        var parts = (v + "").match(/([+-]|\d\d)/gi);
        if (parts) {
            var minutes = +parts[1] * 60 + parseInt(parts[2], 10);
            return parts[0] === "+" ? minutes : -minutes;
        }
        return 0;
    }
];
var parseFlags = {
    D: ["day", twoDigitsOptional],
    DD: ["day", twoDigits],
    Do: ["day", twoDigitsOptional + word, function (v) { return parseInt(v, 10); }],
    M: ["month", twoDigitsOptional, monthParse],
    MM: ["month", twoDigits, monthParse],
    YY: [
        "year",
        twoDigits,
        function (v) {
            var now = new Date();
            var cent = +("" + now.getFullYear()).substr(0, 2);
            return +("" + (+v > 68 ? cent - 1 : cent) + v);
        }
    ],
    h: ["hour", twoDigitsOptional, undefined, "isPm"],
    hh: ["hour", twoDigits, undefined, "isPm"],
    H: ["hour", twoDigitsOptional],
    HH: ["hour", twoDigits],
    m: ["minute", twoDigitsOptional],
    mm: ["minute", twoDigits],
    s: ["second", twoDigitsOptional],
    ss: ["second", twoDigits],
    YYYY: ["year", fourDigits],
    S: ["millisecond", "\\d", function (v) { return +v * 100; }],
    SS: ["millisecond", twoDigits, function (v) { return +v * 10; }],
    SSS: ["millisecond", threeDigits],
    d: emptyDigits,
    dd: emptyDigits,
    ddd: emptyWord,
    dddd: emptyWord,
    MMM: ["month", word, monthUpdate("monthNamesShort")],
    MMMM: ["month", word, monthUpdate("monthNames")],
    a: amPm,
    A: amPm,
    ZZ: timezoneOffset,
    Z: timezoneOffset
};
// Some common format strings
var globalMasks = {
    default: "ddd MMM DD YYYY HH:mm:ss",
    shortDate: "M/D/YY",
    mediumDate: "MMM D, YYYY",
    longDate: "MMMM D, YYYY",
    fullDate: "dddd, MMMM D, YYYY",
    isoDate: "YYYY-MM-DD",
    isoDateTime: "YYYY-MM-DDTHH:mm:ssZ",
    shortTime: "HH:mm",
    mediumTime: "HH:mm:ss",
    longTime: "HH:mm:ss.SSS"
};
/***
 * Format a date
 * @method format
 * @param {Date|number} dateObj
 * @param {string} mask Format of the date, i.e. 'mm-dd-yy' or 'shortDate'
 * @returns {string} Formatted date string
 */
var format = function (dateObj, mask, i18n) {
    if (mask === void 0) { mask = globalMasks["default"]; }
    if (i18n === void 0) { i18n = {}; }
    if (typeof dateObj === "number") {
        dateObj = new Date(dateObj);
    }
    if (Object.prototype.toString.call(dateObj) !== "[object Date]" ||
        isNaN(dateObj.getTime())) {
        throw new Error("Invalid Date pass to format");
    }
    mask = globalMasks[mask] || mask;
    var literals = [];
    // Make literals inactive by replacing them with @@@
    mask = mask.replace(literal, function ($0, $1) {
        literals.push($1);
        return "@@@";
    });
    var combinedI18nSettings = assign(assign({}, globalI18n), i18n);
    // Apply formatting rules
    mask = mask.replace(token$1, function ($0) {
        return formatFlags[$0](dateObj, combinedI18nSettings);
    });
    // Inline literal values back into the formatted value
    return mask.replace(/@@@/g, function () { return literals.shift(); });
};
/**
 * Parse a date string into a Javascript Date object /
 * @method parse
 * @param {string} dateStr Date string
 * @param {string} format Date parse format
 * @param {i18n} I18nSettingsOptional Full or subset of I18N settings
 * @returns {Date|null} Returns Date object. Returns null what date string is invalid or doesn't match format
 */
function parse(dateStr, format, i18n) {
    if (i18n === void 0) { i18n = {}; }
    if (typeof format !== "string") {
        throw new Error("Invalid format in fecha parse");
    }
    // Check to see if the format is actually a mask
    format = globalMasks[format] || format;
    // Avoid regular expression denial of service, fail early for really long strings
    // https://www.owasp.org/index.php/Regular_expression_Denial_of_Service_-_ReDoS
    if (dateStr.length > 1000) {
        return null;
    }
    // Default to the beginning of the year.
    var today = new Date();
    var dateInfo = {
        year: today.getFullYear(),
        month: 0,
        day: 1,
        hour: 0,
        minute: 0,
        second: 0,
        millisecond: 0,
        isPm: null,
        timezoneOffset: null
    };
    var parseInfo = [];
    var literals = [];
    // Replace all the literals with @@@. Hopefully a string that won't exist in the format
    var newFormat = format.replace(literal, function ($0, $1) {
        literals.push(regexEscape($1));
        return "@@@";
    });
    var specifiedFields = {};
    var requiredFields = {};
    // Change every token that we find into the correct regex
    newFormat = regexEscape(newFormat).replace(token$1, function ($0) {
        var info = parseFlags[$0];
        var field = info[0], regex = info[1], requiredField = info[3];
        // Check if the person has specified the same field twice. This will lead to confusing results.
        if (specifiedFields[field]) {
            throw new Error("Invalid format. " + field + " specified twice in format");
        }
        specifiedFields[field] = true;
        // Check if there are any required fields. For instance, 12 hour time requires AM/PM specified
        if (requiredField) {
            requiredFields[requiredField] = true;
        }
        parseInfo.push(info);
        return "(" + regex + ")";
    });
    // Check all the required fields are present
    Object.keys(requiredFields).forEach(function (field) {
        if (!specifiedFields[field]) {
            throw new Error("Invalid format. " + field + " is required in specified format");
        }
    });
    // Add back all the literals after
    newFormat = newFormat.replace(/@@@/g, function () { return literals.shift(); });
    // Check if the date string matches the format. If it doesn't return null
    var matches = dateStr.match(new RegExp(newFormat, "i"));
    if (!matches) {
        return null;
    }
    var combinedI18nSettings = assign(assign({}, globalI18n), i18n);
    // For each match, call the parser function for that date part
    for (var i = 1; i < matches.length; i++) {
        var _a = parseInfo[i - 1], field = _a[0], parser = _a[2];
        var value = parser
            ? parser(matches[i], combinedI18nSettings)
            : +matches[i];
        // If the parser can't make sense of the value, return null
        if (value == null) {
            return null;
        }
        dateInfo[field] = value;
    }
    if (dateInfo.isPm === 1 && dateInfo.hour != null && +dateInfo.hour !== 12) {
        dateInfo.hour = +dateInfo.hour + 12;
    }
    else if (dateInfo.isPm === 0 && +dateInfo.hour === 12) {
        dateInfo.hour = 0;
    }
    var dateWithoutTZ = new Date(dateInfo.year, dateInfo.month, dateInfo.day, dateInfo.hour, dateInfo.minute, dateInfo.second, dateInfo.millisecond);
    var validateFields = [
        ["month", "getMonth"],
        ["day", "getDate"],
        ["hour", "getHours"],
        ["minute", "getMinutes"],
        ["second", "getSeconds"]
    ];
    for (var i = 0, len = validateFields.length; i < len; i++) {
        // Check to make sure the date field is within the allowed range. Javascript dates allows values
        // outside the allowed range. If the values don't match the value was invalid
        if (specifiedFields[validateFields[i][0]] &&
            dateInfo[validateFields[i][0]] !== dateWithoutTZ[validateFields[i][1]]()) {
            return null;
        }
    }
    if (dateInfo.timezoneOffset == null) {
        return dateWithoutTZ;
    }
    return new Date(Date.UTC(dateInfo.year, dateInfo.month, dateInfo.day, dateInfo.hour, dateInfo.minute - dateInfo.timezoneOffset, dateInfo.second, dateInfo.millisecond));
}

function dateFmt() {
  return format;
}

function dateParse() {
  return parse;
}

/** 计算时间差: day */


/** @exports 获取指定年月的最后一天 */


/** @exports 获取自指定日期或者今天是周几 */


/** @exports 获取当前日期本周的周日-周六,返回-Date */


var date = {
  dateFmt: dateFmt, dateParse: dateParse

  /**
   *  今天最早于最晚
   const sToday = mjs.date.dateParse()(mjs.date.dateFmt()(new Date(), "YYYY-MM-DD") + " 00:00:00", "YYYY-MM-DD HH:mm:ss").getTime();
      const eToday = mjs.date.dateParse()(mjs.date.dateFmt()(new Date(), "YYYY-MM-DD") + " 23:59:59", "YYYY-MM-DD HH:mm:ss").getTime(); */

  /**
   *  延迟赋值
   * const sToday = mjs.date.dateParse()(mjs.date.dateFmt()(new Date(), "YYYY-MM-DD") + " 00:00:00", "YYYY-MM-DD HH:mm:ss").getTime();
  const eToday = mjs.date.dateParse()(mjs.date.dateFmt()(new Date(), "YYYY-MM-DD") + " 23:59:59", "YYYY-MM-DD HH:mm:ss").getTime();
  setTimeout(() => {
    this.$('dateField_likcqjcr').setValue(sToday)
    this.$('dateField_likcqjcs').setValue(eToday)
  }, 400) */

};

// 19.1.2.1 Object.assign(target, source, ...)






var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
var _objectAssign = !$assign || _fails(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = _toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = _objectGops.f;
  var isEnum = _objectPie.f;
  while (aLen > index) {
    var S = _iobject(arguments[index++]);
    var keys = getSymbols ? _objectKeys(S).concat(getSymbols(S)) : _objectKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!_descriptors || isEnum.call(S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

// 19.1.3.1 Object.assign(target, source)


_export(_export.S + _export.F, 'Object', { assign: _objectAssign });

var assign$3 = _core.Object.assign;

var assign$1 = createCommonjsModule(function (module) {
module.exports = { "default": assign$3, __esModule: true };
});

unwrapExports(assign$1);

var _extends = createCommonjsModule(function (module, exports) {
exports.__esModule = true;



var _assign2 = _interopRequireDefault(assign$1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = _assign2.default || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};
});

var _extends$1 = unwrapExports(_extends);

// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
_export(_export.S + _export.F * !_descriptors, 'Object', { defineProperty: _objectDp.f });

var $Object = _core.Object;
var defineProperty$4 = function defineProperty(it, key, desc) {
  return $Object.defineProperty(it, key, desc);
};

var defineProperty$2 = createCommonjsModule(function (module) {
module.exports = { "default": defineProperty$4, __esModule: true };
});

unwrapExports(defineProperty$2);

var defineProperty$1 = createCommonjsModule(function (module, exports) {
exports.__esModule = true;



var _defineProperty2 = _interopRequireDefault(defineProperty$2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (obj, key, value) {
  if (key in obj) {
    (0, _defineProperty2.default)(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
};
});

var _defineProperty = unwrapExports(defineProperty$1);

// most Object methods by ES6 should accept primitives



var _objectSap = function (KEY, exec) {
  var fn = (_core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  _export(_export.S + _export.F * _fails(function () { fn(1); }), 'Object', exp);
};

// 19.1.2.14 Object.keys(O)



_objectSap('keys', function () {
  return function keys(it) {
    return _objectKeys(_toObject(it));
  };
});

var keys$1 = _core.Object.keys;

var keys = createCommonjsModule(function (module) {
module.exports = { "default": keys$1, __esModule: true };
});

var _Object$keys = unwrapExports(keys);

var bind$2 = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};

/*global toString:true*/

// utils is a library of generic helper functions non-specific to axios

var toString$2 = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray$1(val) {
  return toString$2.call(val) === '[object Array]';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)
    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString$2.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject$1(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString$2.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString$2.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString$2.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString$2.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject$1(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.replace(/^\s*/, '').replace(/\s*$/, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||
                                           navigator.product === 'NativeScript' ||
                                           navigator.product === 'NS')) {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray$1(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = merge(result[key], val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Function equal to merge with the difference being that no reference
 * to original objects is kept.
 *
 * @see merge
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function deepMerge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (typeof result[key] === 'object' && typeof val === 'object') {
      result[key] = deepMerge(result[key], val);
    } else if (typeof val === 'object') {
      result[key] = deepMerge({}, val);
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind$2(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

var utils = {
  isArray: isArray$1,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject$1,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  deepMerge: deepMerge,
  extend: extend,
  trim: trim
};

function encode(val) {
  return encodeURIComponent(val).
    replace(/%40/gi, '@').
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
var buildURL = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }

    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

var InterceptorManager_1 = InterceptorManager;

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
var transformData = function transformData(data, headers, fns) {
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn(data, headers);
  });

  return data;
};

var isCancel = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};

var normalizeHeaderName = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};

/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The error.
 */
var enhanceError = function enhanceError(error, config, code, request, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }

  error.request = request;
  error.response = response;
  error.isAxiosError = true;

  error.toJSON = function() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code
    };
  };
  return error;
};

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
var createError = function createError(message, config, code, request, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, request, response);
};

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
var settle = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response.request,
      response
    ));
  }
};

/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
var isAbsoluteURL = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};

/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
var combineURLs = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
var buildFullPath = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = [
  'age', 'authorization', 'content-length', 'content-type', 'etag',
  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',
  'last-modified', 'location', 'max-forwards', 'proxy-authorization',
  'referer', 'retry-after', 'user-agent'
];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
var parseHeaders = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });

  return parsed;
};

var isURLSameOrigin = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
    (function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement('a');
      var originURL;

      /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
      function resolveURL(url) {
        var href = url;

        if (msie) {
        // IE needs attribute set twice to normalize properties
          urlParsingNode.setAttribute('href', href);
          href = urlParsingNode.href;
        }

        urlParsingNode.setAttribute('href', href);

        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
            urlParsingNode.pathname :
            '/' + urlParsingNode.pathname
        };
      }

      originURL = resolveURL(window.location.href);

      /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
      return function isURLSameOrigin(requestURL) {
        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
        return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
      };
    })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    })()
);

var cookies = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
    (function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path, domain, secure) {
          var cookie = [];
          cookie.push(name + '=' + encodeURIComponent(value));

          if (utils.isNumber(expires)) {
            cookie.push('expires=' + new Date(expires).toGMTString());
          }

          if (utils.isString(path)) {
            cookie.push('path=' + path);
          }

          if (utils.isString(domain)) {
            cookie.push('domain=' + domain);
          }

          if (secure === true) {
            cookie.push('secure');
          }

          document.cookie = cookie.join('; ');
        },

        read: function read(name) {
          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
          return (match ? decodeURIComponent(match[3]) : null);
        },

        remove: function remove(name) {
          this.write(name, '', Date.now() - 86400000);
        }
      };
    })() :

  // Non standard browser env (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return {
        write: function write() {},
        read: function read() { return null; },
        remove: function remove() {}
      };
    })()
);

var xhr$1 = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password || '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    // Listen for ready state
    request.onreadystatechange = function handleLoad() {
      if (!request || request.readyState !== 4) {
        return;
      }

      // The request errored out and we didn't get a response, this will be
      // handled by onerror instead
      // With one exception: request that using file: protocol, most browsers
      // will return status as 0 even though it's a successful request
      if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
        return;
      }

      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !config.responseType || config.responseType === 'text' ? request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    };

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }

      reject(createError('Request aborted', config, 'ECONNABORTED', request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config, null, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError(timeoutErrorMessage, config, 'ECONNABORTED',
        request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      var cookies$$1 = cookies;

      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?
        cookies$$1.read(config.xsrfCookieName) :
        undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (config.responseType) {
      try {
        request.responseType = config.responseType;
      } catch (e) {
        // Expected DOMException thrown by browsers not compatible XMLHttpRequest Level 2.
        // But, this can be suppressed for 'json' type as it can be parsed by default 'transformResponse' function.
        if (config.responseType !== 'json') {
          throw e;
        }
      }
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (requestData === undefined) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = xhr$1;
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = xhr$1;
  }
  return adapter;
}

var defaults = {
  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');
    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data)) {
      setContentTypeIfUnset(headers, 'application/json;charset=utf-8');
      return JSON.stringify(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    /*eslint no-param-reassign:0*/
    if (typeof data === 'string') {
      try {
        data = JSON.parse(data);
      } catch (e) { /* Ignore */ }
    }
    return data;
  }],

  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

var defaults_1 = defaults;

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
var dispatchRequest = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData(
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults_1.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData(
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData(
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
var mergeConfig = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};

  var valueFromConfig2Keys = ['url', 'method', 'params', 'data'];
  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy'];
  var defaultToConfig2Keys = [
    'baseURL', 'url', 'transformRequest', 'transformResponse', 'paramsSerializer',
    'timeout', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',
    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress',
    'maxContentLength', 'validateStatus', 'maxRedirects', 'httpAgent',
    'httpsAgent', 'cancelToken', 'socketPath'
  ];

  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    }
  });

  utils.forEach(mergeDeepPropertiesKeys, function mergeDeepProperties(prop) {
    if (utils.isObject(config2[prop])) {
      config[prop] = utils.deepMerge(config1[prop], config2[prop]);
    } else if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (utils.isObject(config1[prop])) {
      config[prop] = utils.deepMerge(config1[prop]);
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  var axiosKeys = valueFromConfig2Keys
    .concat(mergeDeepPropertiesKeys)
    .concat(defaultToConfig2Keys);

  var otherKeys = Object
    .keys(config2)
    .filter(function filterAxiosKeys(key) {
      return axiosKeys.indexOf(key) === -1;
    });

  utils.forEach(otherKeys, function otherKeysDefaultToConfig2(prop) {
    if (typeof config2[prop] !== 'undefined') {
      config[prop] = config2[prop];
    } else if (typeof config1[prop] !== 'undefined') {
      config[prop] = config1[prop];
    }
  });

  return config;
};

/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager_1(),
    response: new InterceptorManager_1()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }

  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }

  // Hook up interceptors middleware
  var chain = [dispatchRequest, undefined];
  var promise = Promise.resolve(config);

  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    chain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    chain.push(interceptor.fulfilled, interceptor.rejected);
  });

  while (chain.length) {
    promise = promise.then(chain.shift(), chain.shift());
  }

  return promise;
};

Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(utils.merge(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

var Axios_1 = Axios;

/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

var Cancel_1 = Cancel;

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel_1(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

var CancelToken_1 = CancelToken;

/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
var spread = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios_1(defaultConfig);
  var instance = bind$2(Axios_1.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios_1.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios$2 = createInstance(defaults_1);

// Expose Axios class to allow class inheritance
axios$2.Axios = Axios_1;

// Factory for creating new instances
axios$2.create = function create(instanceConfig) {
  return createInstance(mergeConfig(axios$2.defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios$2.Cancel = Cancel_1;
axios$2.CancelToken = CancelToken_1;
axios$2.isCancel = isCancel;

// Expose all/spread
axios$2.all = function all(promises) {
  return Promise.all(promises);
};
axios$2.spread = spread;

var axios_1 = axios$2;

// Allow use of default import syntax in TypeScript
var default_1 = axios$2;

axios_1.default = default_1;

var axios = axios_1;

var has$2 = Object.prototype.hasOwnProperty;
var isArray$3 = Array.isArray;

var hexTable = (function () {
    var array = [];
    for (var i = 0; i < 256; ++i) {
        array.push('%' + ((i < 16 ? '0' : '') + i.toString(16)).toUpperCase());
    }

    return array;
}());

var compactQueue = function compactQueue(queue) {
    while (queue.length > 1) {
        var item = queue.pop();
        var obj = item.obj[item.prop];

        if (isArray$3(obj)) {
            var compacted = [];

            for (var j = 0; j < obj.length; ++j) {
                if (typeof obj[j] !== 'undefined') {
                    compacted.push(obj[j]);
                }
            }

            item.obj[item.prop] = compacted;
        }
    }
};

var arrayToObject = function arrayToObject(source, options) {
    var obj = options && options.plainObjects ? Object.create(null) : {};
    for (var i = 0; i < source.length; ++i) {
        if (typeof source[i] !== 'undefined') {
            obj[i] = source[i];
        }
    }

    return obj;
};

var merge$1 = function merge(target, source, options) {
    /* eslint no-param-reassign: 0 */
    if (!source) {
        return target;
    }

    if (typeof source !== 'object') {
        if (isArray$3(target)) {
            target.push(source);
        } else if (target && typeof target === 'object') {
            if ((options && (options.plainObjects || options.allowPrototypes)) || !has$2.call(Object.prototype, source)) {
                target[source] = true;
            }
        } else {
            return [target, source];
        }

        return target;
    }

    if (!target || typeof target !== 'object') {
        return [target].concat(source);
    }

    var mergeTarget = target;
    if (isArray$3(target) && !isArray$3(source)) {
        mergeTarget = arrayToObject(target, options);
    }

    if (isArray$3(target) && isArray$3(source)) {
        source.forEach(function (item, i) {
            if (has$2.call(target, i)) {
                var targetItem = target[i];
                if (targetItem && typeof targetItem === 'object' && item && typeof item === 'object') {
                    target[i] = merge(targetItem, item, options);
                } else {
                    target.push(item);
                }
            } else {
                target[i] = item;
            }
        });
        return target;
    }

    return Object.keys(source).reduce(function (acc, key) {
        var value = source[key];

        if (has$2.call(acc, key)) {
            acc[key] = merge(acc[key], value, options);
        } else {
            acc[key] = value;
        }
        return acc;
    }, mergeTarget);
};

var assign$5 = function assignSingleSource(target, source) {
    return Object.keys(source).reduce(function (acc, key) {
        acc[key] = source[key];
        return acc;
    }, target);
};

var decode = function (str, decoder, charset) {
    var strWithoutPlus = str.replace(/\+/g, ' ');
    if (charset === 'iso-8859-1') {
        // unescape never throws, no try...catch needed:
        return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
    }
    // utf-8
    try {
        return decodeURIComponent(strWithoutPlus);
    } catch (e) {
        return strWithoutPlus;
    }
};

var encode$1 = function encode(str, defaultEncoder, charset) {
    // This code was originally written by Brian White (mscdex) for the io.js core querystring library.
    // It has been adapted here for stricter adherence to RFC 3986
    if (str.length === 0) {
        return str;
    }

    var string = str;
    if (typeof str === 'symbol') {
        string = Symbol.prototype.toString.call(str);
    } else if (typeof str !== 'string') {
        string = String(str);
    }

    if (charset === 'iso-8859-1') {
        return escape(string).replace(/%u[0-9a-f]{4}/gi, function ($0) {
            return '%26%23' + parseInt($0.slice(2), 16) + '%3B';
        });
    }

    var out = '';
    for (var i = 0; i < string.length; ++i) {
        var c = string.charCodeAt(i);

        if (
            c === 0x2D // -
            || c === 0x2E // .
            || c === 0x5F // _
            || c === 0x7E // ~
            || (c >= 0x30 && c <= 0x39) // 0-9
            || (c >= 0x41 && c <= 0x5A) // a-z
            || (c >= 0x61 && c <= 0x7A) // A-Z
        ) {
            out += string.charAt(i);
            continue;
        }

        if (c < 0x80) {
            out = out + hexTable[c];
            continue;
        }

        if (c < 0x800) {
            out = out + (hexTable[0xC0 | (c >> 6)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        if (c < 0xD800 || c >= 0xE000) {
            out = out + (hexTable[0xE0 | (c >> 12)] + hexTable[0x80 | ((c >> 6) & 0x3F)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        i += 1;
        c = 0x10000 + (((c & 0x3FF) << 10) | (string.charCodeAt(i) & 0x3FF));
        out += hexTable[0xF0 | (c >> 18)]
            + hexTable[0x80 | ((c >> 12) & 0x3F)]
            + hexTable[0x80 | ((c >> 6) & 0x3F)]
            + hexTable[0x80 | (c & 0x3F)];
    }

    return out;
};

var compact = function compact(value) {
    var queue = [{ obj: { o: value }, prop: 'o' }];
    var refs = [];

    for (var i = 0; i < queue.length; ++i) {
        var item = queue[i];
        var obj = item.obj[item.prop];

        var keys = Object.keys(obj);
        for (var j = 0; j < keys.length; ++j) {
            var key = keys[j];
            var val = obj[key];
            if (typeof val === 'object' && val !== null && refs.indexOf(val) === -1) {
                queue.push({ obj: obj, prop: key });
                refs.push(val);
            }
        }
    }

    compactQueue(queue);

    return value;
};

var isRegExp = function isRegExp(obj) {
    return Object.prototype.toString.call(obj) === '[object RegExp]';
};

var isBuffer$1 = function isBuffer(obj) {
    if (!obj || typeof obj !== 'object') {
        return false;
    }

    return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
};

var combine = function combine(a, b) {
    return [].concat(a, b);
};

var maybeMap = function maybeMap(val, fn) {
    if (isArray$3(val)) {
        var mapped = [];
        for (var i = 0; i < val.length; i += 1) {
            mapped.push(fn(val[i]));
        }
        return mapped;
    }
    return fn(val);
};

var utils$3 = {
    arrayToObject: arrayToObject,
    assign: assign$5,
    combine: combine,
    compact: compact,
    decode: decode,
    encode: encode$1,
    isBuffer: isBuffer$1,
    isRegExp: isRegExp,
    maybeMap: maybeMap,
    merge: merge$1
};

var replace$2 = String.prototype.replace;
var percentTwenties = /%20/g;



var Format = {
    RFC1738: 'RFC1738',
    RFC3986: 'RFC3986'
};

var formats = utils$3.assign(
    {
        'default': Format.RFC3986,
        formatters: {
            RFC1738: function (value) {
                return replace$2.call(value, percentTwenties, '+');
            },
            RFC3986: function (value) {
                return String(value);
            }
        }
    },
    Format
);

var has$1 = Object.prototype.hasOwnProperty;

var arrayPrefixGenerators = {
    brackets: function brackets(prefix) {
        return prefix + '[]';
    },
    comma: 'comma',
    indices: function indices(prefix, key) {
        return prefix + '[' + key + ']';
    },
    repeat: function repeat(prefix) {
        return prefix;
    }
};

var isArray$2 = Array.isArray;
var push = Array.prototype.push;
var pushToArray = function (arr, valueOrArray) {
    push.apply(arr, isArray$2(valueOrArray) ? valueOrArray : [valueOrArray]);
};

var toISO = Date.prototype.toISOString;

var defaultFormat = formats['default'];
var defaults$2 = {
    addQueryPrefix: false,
    allowDots: false,
    charset: 'utf-8',
    charsetSentinel: false,
    delimiter: '&',
    encode: true,
    encoder: utils$3.encode,
    encodeValuesOnly: false,
    format: defaultFormat,
    formatter: formats.formatters[defaultFormat],
    // deprecated
    indices: false,
    serializeDate: function serializeDate(date) {
        return toISO.call(date);
    },
    skipNulls: false,
    strictNullHandling: false
};

var isNonNullishPrimitive = function isNonNullishPrimitive(v) {
    return typeof v === 'string'
        || typeof v === 'number'
        || typeof v === 'boolean'
        || typeof v === 'symbol'
        || typeof v === 'bigint';
};

var stringify$3 = function stringify(
    object,
    prefix,
    generateArrayPrefix,
    strictNullHandling,
    skipNulls,
    encoder,
    filter,
    sort,
    allowDots,
    serializeDate,
    formatter,
    encodeValuesOnly,
    charset
) {
    var obj = object;
    if (typeof filter === 'function') {
        obj = filter(prefix, obj);
    } else if (obj instanceof Date) {
        obj = serializeDate(obj);
    } else if (generateArrayPrefix === 'comma' && isArray$2(obj)) {
        obj = utils$3.maybeMap(obj, function (value) {
            if (value instanceof Date) {
                return serializeDate(value);
            }
            return value;
        }).join(',');
    }

    if (obj === null) {
        if (strictNullHandling) {
            return encoder && !encodeValuesOnly ? encoder(prefix, defaults$2.encoder, charset, 'key') : prefix;
        }

        obj = '';
    }

    if (isNonNullishPrimitive(obj) || utils$3.isBuffer(obj)) {
        if (encoder) {
            var keyValue = encodeValuesOnly ? prefix : encoder(prefix, defaults$2.encoder, charset, 'key');
            return [formatter(keyValue) + '=' + formatter(encoder(obj, defaults$2.encoder, charset, 'value'))];
        }
        return [formatter(prefix) + '=' + formatter(String(obj))];
    }

    var values = [];

    if (typeof obj === 'undefined') {
        return values;
    }

    var objKeys;
    if (isArray$2(filter)) {
        objKeys = filter;
    } else {
        var keys = Object.keys(obj);
        objKeys = sort ? keys.sort(sort) : keys;
    }

    for (var i = 0; i < objKeys.length; ++i) {
        var key = objKeys[i];
        var value = obj[key];

        if (skipNulls && value === null) {
            continue;
        }

        var keyPrefix = isArray$2(obj)
            ? typeof generateArrayPrefix === 'function' ? generateArrayPrefix(prefix, key) : prefix
            : prefix + (allowDots ? '.' + key : '[' + key + ']');

        pushToArray(values, stringify(
            value,
            keyPrefix,
            generateArrayPrefix,
            strictNullHandling,
            skipNulls,
            encoder,
            filter,
            sort,
            allowDots,
            serializeDate,
            formatter,
            encodeValuesOnly,
            charset
        ));
    }

    return values;
};

var normalizeStringifyOptions = function normalizeStringifyOptions(opts) {
    if (!opts) {
        return defaults$2;
    }

    if (opts.encoder !== null && opts.encoder !== undefined && typeof opts.encoder !== 'function') {
        throw new TypeError('Encoder has to be a function.');
    }

    var charset = opts.charset || defaults$2.charset;
    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
    }

    var format = formats['default'];
    if (typeof opts.format !== 'undefined') {
        if (!has$1.call(formats.formatters, opts.format)) {
            throw new TypeError('Unknown format option provided.');
        }
        format = opts.format;
    }
    var formatter = formats.formatters[format];

    var filter = defaults$2.filter;
    if (typeof opts.filter === 'function' || isArray$2(opts.filter)) {
        filter = opts.filter;
    }

    return {
        addQueryPrefix: typeof opts.addQueryPrefix === 'boolean' ? opts.addQueryPrefix : defaults$2.addQueryPrefix,
        allowDots: typeof opts.allowDots === 'undefined' ? defaults$2.allowDots : !!opts.allowDots,
        charset: charset,
        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults$2.charsetSentinel,
        delimiter: typeof opts.delimiter === 'undefined' ? defaults$2.delimiter : opts.delimiter,
        encode: typeof opts.encode === 'boolean' ? opts.encode : defaults$2.encode,
        encoder: typeof opts.encoder === 'function' ? opts.encoder : defaults$2.encoder,
        encodeValuesOnly: typeof opts.encodeValuesOnly === 'boolean' ? opts.encodeValuesOnly : defaults$2.encodeValuesOnly,
        filter: filter,
        formatter: formatter,
        serializeDate: typeof opts.serializeDate === 'function' ? opts.serializeDate : defaults$2.serializeDate,
        skipNulls: typeof opts.skipNulls === 'boolean' ? opts.skipNulls : defaults$2.skipNulls,
        sort: typeof opts.sort === 'function' ? opts.sort : null,
        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults$2.strictNullHandling
    };
};

var stringify_1 = function (object, opts) {
    var obj = object;
    var options = normalizeStringifyOptions(opts);

    var objKeys;
    var filter;

    if (typeof options.filter === 'function') {
        filter = options.filter;
        obj = filter('', obj);
    } else if (isArray$2(options.filter)) {
        filter = options.filter;
        objKeys = filter;
    }

    var keys = [];

    if (typeof obj !== 'object' || obj === null) {
        return '';
    }

    var arrayFormat;
    if (opts && opts.arrayFormat in arrayPrefixGenerators) {
        arrayFormat = opts.arrayFormat;
    } else if (opts && 'indices' in opts) {
        arrayFormat = opts.indices ? 'indices' : 'repeat';
    } else {
        arrayFormat = 'indices';
    }

    var generateArrayPrefix = arrayPrefixGenerators[arrayFormat];

    if (!objKeys) {
        objKeys = Object.keys(obj);
    }

    if (options.sort) {
        objKeys.sort(options.sort);
    }

    for (var i = 0; i < objKeys.length; ++i) {
        var key = objKeys[i];

        if (options.skipNulls && obj[key] === null) {
            continue;
        }
        pushToArray(keys, stringify$3(
            obj[key],
            key,
            generateArrayPrefix,
            options.strictNullHandling,
            options.skipNulls,
            options.encode ? options.encoder : null,
            options.filter,
            options.sort,
            options.allowDots,
            options.serializeDate,
            options.formatter,
            options.encodeValuesOnly,
            options.charset
        ));
    }

    var joined = keys.join(options.delimiter);
    var prefix = options.addQueryPrefix === true ? '?' : '';

    if (options.charsetSentinel) {
        if (options.charset === 'iso-8859-1') {
            // encodeURIComponent('&#10003;'), the "numeric entity" representation of a checkmark
            prefix += 'utf8=%26%2310003%3B&';
        } else {
            // encodeURIComponent('✓')
            prefix += 'utf8=%E2%9C%93&';
        }
    }

    return joined.length > 0 ? prefix + joined : '';
};

var has$3 = Object.prototype.hasOwnProperty;
var isArray$4 = Array.isArray;

var defaults$3 = {
    allowDots: false,
    allowPrototypes: false,
    arrayLimit: 20,
    charset: 'utf-8',
    charsetSentinel: false,
    comma: false,
    decoder: utils$3.decode,
    delimiter: '&',
    depth: 5,
    ignoreQueryPrefix: false,
    interpretNumericEntities: false,
    parameterLimit: 1000,
    parseArrays: true,
    plainObjects: false,
    strictNullHandling: false
};

var interpretNumericEntities = function (str) {
    return str.replace(/&#(\d+);/g, function ($0, numberStr) {
        return String.fromCharCode(parseInt(numberStr, 10));
    });
};

var parseArrayValue = function (val, options) {
    if (val && typeof val === 'string' && options.comma && val.indexOf(',') > -1) {
        return val.split(',');
    }

    return val;
};

// This is what browsers will submit when the ✓ character occurs in an
// application/x-www-form-urlencoded body and the encoding of the page containing
// the form is iso-8859-1, or when the submitted form has an accept-charset
// attribute of iso-8859-1. Presumably also with other charsets that do not contain
// the ✓ character, such as us-ascii.
var isoSentinel = 'utf8=%26%2310003%3B'; // encodeURIComponent('&#10003;')

// These are the percent-encoded utf-8 octets representing a checkmark, indicating that the request actually is utf-8 encoded.
var charsetSentinel = 'utf8=%E2%9C%93'; // encodeURIComponent('✓')

var parseValues = function parseQueryStringValues(str, options) {
    var obj = {};
    var cleanStr = options.ignoreQueryPrefix ? str.replace(/^\?/, '') : str;
    var limit = options.parameterLimit === Infinity ? undefined : options.parameterLimit;
    var parts = cleanStr.split(options.delimiter, limit);
    var skipIndex = -1; // Keep track of where the utf8 sentinel was found
    var i;

    var charset = options.charset;
    if (options.charsetSentinel) {
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].indexOf('utf8=') === 0) {
                if (parts[i] === charsetSentinel) {
                    charset = 'utf-8';
                } else if (parts[i] === isoSentinel) {
                    charset = 'iso-8859-1';
                }
                skipIndex = i;
                i = parts.length; // The eslint settings do not allow break;
            }
        }
    }

    for (i = 0; i < parts.length; ++i) {
        if (i === skipIndex) {
            continue;
        }
        var part = parts[i];

        var bracketEqualsPos = part.indexOf(']=');
        var pos = bracketEqualsPos === -1 ? part.indexOf('=') : bracketEqualsPos + 1;

        var key, val;
        if (pos === -1) {
            key = options.decoder(part, defaults$3.decoder, charset, 'key');
            val = options.strictNullHandling ? null : '';
        } else {
            key = options.decoder(part.slice(0, pos), defaults$3.decoder, charset, 'key');
            val = utils$3.maybeMap(
                parseArrayValue(part.slice(pos + 1), options),
                function (encodedVal) {
                    return options.decoder(encodedVal, defaults$3.decoder, charset, 'value');
                }
            );
        }

        if (val && options.interpretNumericEntities && charset === 'iso-8859-1') {
            val = interpretNumericEntities(val);
        }

        if (part.indexOf('[]=') > -1) {
            val = isArray$4(val) ? [val] : val;
        }

        if (has$3.call(obj, key)) {
            obj[key] = utils$3.combine(obj[key], val);
        } else {
            obj[key] = val;
        }
    }

    return obj;
};

var parseObject = function (chain, val, options, valuesParsed) {
    var leaf = valuesParsed ? val : parseArrayValue(val, options);

    for (var i = chain.length - 1; i >= 0; --i) {
        var obj;
        var root = chain[i];

        if (root === '[]' && options.parseArrays) {
            obj = [].concat(leaf);
        } else {
            obj = options.plainObjects ? Object.create(null) : {};
            var cleanRoot = root.charAt(0) === '[' && root.charAt(root.length - 1) === ']' ? root.slice(1, -1) : root;
            var index = parseInt(cleanRoot, 10);
            if (!options.parseArrays && cleanRoot === '') {
                obj = { 0: leaf };
            } else if (
                !isNaN(index)
                && root !== cleanRoot
                && String(index) === cleanRoot
                && index >= 0
                && (options.parseArrays && index <= options.arrayLimit)
            ) {
                obj = [];
                obj[index] = leaf;
            } else {
                obj[cleanRoot] = leaf;
            }
        }

        leaf = obj; // eslint-disable-line no-param-reassign
    }

    return leaf;
};

var parseKeys = function parseQueryStringKeys(givenKey, val, options, valuesParsed) {
    if (!givenKey) {
        return;
    }

    // Transform dot notation to bracket notation
    var key = options.allowDots ? givenKey.replace(/\.([^.[]+)/g, '[$1]') : givenKey;

    // The regex chunks

    var brackets = /(\[[^[\]]*])/;
    var child = /(\[[^[\]]*])/g;

    // Get the parent

    var segment = options.depth > 0 && brackets.exec(key);
    var parent = segment ? key.slice(0, segment.index) : key;

    // Stash the parent if it exists

    var keys = [];
    if (parent) {
        // If we aren't using plain objects, optionally prefix keys that would overwrite object prototype properties
        if (!options.plainObjects && has$3.call(Object.prototype, parent)) {
            if (!options.allowPrototypes) {
                return;
            }
        }

        keys.push(parent);
    }

    // Loop through children appending to the array until we hit depth

    var i = 0;
    while (options.depth > 0 && (segment = child.exec(key)) !== null && i < options.depth) {
        i += 1;
        if (!options.plainObjects && has$3.call(Object.prototype, segment[1].slice(1, -1))) {
            if (!options.allowPrototypes) {
                return;
            }
        }
        keys.push(segment[1]);
    }

    // If there's a remainder, just add whatever is left

    if (segment) {
        keys.push('[' + key.slice(segment.index) + ']');
    }

    return parseObject(keys, val, options, valuesParsed);
};

var normalizeParseOptions = function normalizeParseOptions(opts) {
    if (!opts) {
        return defaults$3;
    }

    if (opts.decoder !== null && opts.decoder !== undefined && typeof opts.decoder !== 'function') {
        throw new TypeError('Decoder has to be a function.');
    }

    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
    }
    var charset = typeof opts.charset === 'undefined' ? defaults$3.charset : opts.charset;

    return {
        allowDots: typeof opts.allowDots === 'undefined' ? defaults$3.allowDots : !!opts.allowDots,
        allowPrototypes: typeof opts.allowPrototypes === 'boolean' ? opts.allowPrototypes : defaults$3.allowPrototypes,
        arrayLimit: typeof opts.arrayLimit === 'number' ? opts.arrayLimit : defaults$3.arrayLimit,
        charset: charset,
        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults$3.charsetSentinel,
        comma: typeof opts.comma === 'boolean' ? opts.comma : defaults$3.comma,
        decoder: typeof opts.decoder === 'function' ? opts.decoder : defaults$3.decoder,
        delimiter: typeof opts.delimiter === 'string' || utils$3.isRegExp(opts.delimiter) ? opts.delimiter : defaults$3.delimiter,
        // eslint-disable-next-line no-implicit-coercion, no-extra-parens
        depth: (typeof opts.depth === 'number' || opts.depth === false) ? +opts.depth : defaults$3.depth,
        ignoreQueryPrefix: opts.ignoreQueryPrefix === true,
        interpretNumericEntities: typeof opts.interpretNumericEntities === 'boolean' ? opts.interpretNumericEntities : defaults$3.interpretNumericEntities,
        parameterLimit: typeof opts.parameterLimit === 'number' ? opts.parameterLimit : defaults$3.parameterLimit,
        parseArrays: opts.parseArrays !== false,
        plainObjects: typeof opts.plainObjects === 'boolean' ? opts.plainObjects : defaults$3.plainObjects,
        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults$3.strictNullHandling
    };
};

var parse$1 = function (str, opts) {
    var options = normalizeParseOptions(opts);

    if (str === '' || str === null || typeof str === 'undefined') {
        return options.plainObjects ? Object.create(null) : {};
    }

    var tempObj = typeof str === 'string' ? parseValues(str, options) : str;
    var obj = options.plainObjects ? Object.create(null) : {};

    // Iterate over the keys and setup the new object

    var keys = Object.keys(tempObj);
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        var newObj = parseKeys(key, tempObj[key], options, typeof str === 'string');
        obj = utils$3.merge(obj, newObj, options);
    }

    return utils$3.compact(obj);
};

var lib = {
    formats: formats,
    parse: parse$1,
    stringify: stringify_1
};

var _this = undefined;

var CODE_SUCCESS = 200; // 状态正常
var CODE_TOKEN_INVALID = 4002; // 登录失效
 // 没有权限

/////////////////////////////////////////////////  基础参数   /////////////////////////////////////////////////

var request = {};

// 默认配置: 内部变量, 兼容reject不能获取到请求conf配置, 设置全局变量记录
var _conf = {
  mContentType: false, // 记录默认请求头格式
  countLoading: 0 // 使用计数 [拦截器失败重置]
};

// 网络请求
var ContentType = ["application/json;charset=UTF-8", "application/x-www-form-urlencoded"];

var http = axios.create({
  timeout: config.timeout,
  baseURL: ""
});
http.defaults.headers["Content-Type"] = ContentType[Number(_conf.mContentType)]; // 默认 Content-Type

// 拦截器专用: 处理loading状态, 避免出现闪屏; 处理是否显示错误提示
function _interceptorsError(error) {
  _conf.countLoading = 0;
  com.hideLoading();
  var errMsg = error ? error.message || "系统错误" : null;
  com.showErrorMessage(errMsg);
  return error;
}

// 请求拦截器
http.interceptors.request.use(function (config$$1) {
  if (!config$$1.url.includes("http")) {
    config$$1.url = mjs.conf.api + config$$1.url;
  }
  // 无需删除conf属性: 不会提交到请求
  var conf = config$$1.conf;

  if (!conf[KEY_NO_LOADING]) {
    _conf.countLoading += 1;
    com.showLoading();
  }
  if (conf[KEY_M_CONTENT_TYPE]) {
    config$$1.headers["Content-Type"] = ContentType[Number(!_conf.mContentType)]; // // 修改 Content-Type: 取反
  }
  config$$1.headers["Authorization"] = mjs.conf.token;
  console.log('请求入参', config$$1);
  return config$$1;
}, function (error) {
  return _Promise.reject(_interceptorsError(error));
});

// 将blob对象转化为json（文件类型调用ajax 取后端的返回值做特殊处理）
function _fileToJson(file) {
  var data = {},
      message = "";
  function formatReturn() {
    return { data: data, message: message };
  }
  return new _Promise(function (resolve) {
    var reader = new FileReader();
    reader.onload = function (res) {
      var result = res.target.result; // 得到字符串

      try {
        // 解析成json对象
        data = JSON.parse(result);
      } catch (err) {
        message = err.message || err;
      }
      resolve(formatReturn());
    }; // 成功回调
    reader.onerror = function (err) {
      message = err.message || err;
      resolve(formatReturn());
    }; // 失败回调
    reader.readAsText(new Blob([file]), "utf-8"); // 按照utf-8编码解析
  });
}

// 响应拦截器
http.interceptors.response.use(function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(response) {
    var conf, rsp, fileName, disposition, msg, code, tip;
    return regenerator.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            console.log('请求响应', response);
            conf = response.config.conf;
            // loading处理

            if (!conf[KEY_NO_LOADING]) {
              _conf.countLoading -= 1;
            }
            if (!_conf.countLoading) {
              com.hideLoading();
            }

            if (!conf[KEY_IGNORE_RESPONSE]) {
              _context.next = 6;
              break;
            }

            return _context.abrupt("return", response);

          case 6:
            if (!response.config.conf[KEY_EXPORT_TYPE]) {
              _context.next = 16;
              break;
            }

            _context.next = 9;
            return _fileToJson(response.data);

          case 9:
            rsp = _context.sent;

            if (rsp.data.code) {
              _context.next = 15;
              break;
            }

            // 文件名称: 需要后端设置为可见, 否则 header 有, 但 js 取不到值
            fileName = void 0;
            disposition = response.headers["content-disposition"];

            if (disposition) {
              disposition = disposition.toLowerCase();
              fileName = decodeURIComponent(disposition.replace("attachment;filename=", "").replace("attachment;filename*=utf-8", ""));
            }
            return _context.abrupt("return", { data: response.data, fileName: fileName });

          case 15:
            // 赋值, 触发失败弹出框
            response.data = rsp.data;

          case 16:
            msg = response.data.msg || response.data.message;
            code = Number(response.data.code);

            if (!(code === CODE_SUCCESS || response.data.success)) {
              _context.next = 22;
              break;
            }

            tip = conf[KEY_SHOW_MESSAGE];

            if (tip) {
              // 需要show成功Message信息
              com.showSuccessMessage(typeof tip == "boolean" ? msg || "请求成功" : tip);
            }
            return _context.abrupt("return", response.data);

          case 22:
            // 登录失效跳转登录页面. NOTE: 注意可能导致循环调用
            if (code === CODE_TOKEN_INVALID) {
              com.showErrorMessage(msg);
              setTimeout(function () {
                com.invalidToken(msg);
              }, 350);
            }
            // 请求结束忽略error
            if (!conf[KEY_NO_ERROR_TIP]) {
              com.showErrorMessage(msg || '未知异常');
            }
            return _context.abrupt("return", _Promise.reject(msg));

          case 25:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, _this);
  }));

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}(), function (error) {
  return _Promise.reject(_interceptorsError(error));
});

/////////////////////////////////////////////////  请求配置   /////////////////////////////////////////////////

/** @param Boolean: noLoading => 是否显示loading */
var KEY_NO_LOADING = "noLoading";
/** @param Boolean: noErrorTip => 是否显示错误提示框; */
var KEY_NO_ERROR_TIP = "noErrorTip";
/** @param Boolean: mContentType => 是否修改请求头类型 */
var KEY_M_CONTENT_TYPE = "mContentType";
/** @param Boolean: showMessage => 是否显示提示 */
var KEY_SHOW_MESSAGE = "showMessage";
/** @param Boolean: responseType => 导出文件流类型 */
var KEY_EXPORT_TYPE = "responseType";
/** @param Boolean: ignoreResponse => 返回数据不校验 */
var KEY_IGNORE_RESPONSE = "ignoreResponse";
/** @param Boolean: noLoadToken => 不传递token */


/** 0.通用请求 */
request.do = function (url) {
  var param = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var conf = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var method = arguments[4];

  var params = lib.stringify(param);
  if (params) {
    var joint = url.includes("?") ? "&" : "?";
    url += joint + params;
  }
  return http({
    url: url,
    method: method,
    data: data,
    conf: conf,
    responseType: conf[KEY_EXPORT_TYPE]
  });
};

/** 1.get: url上param, 后端取值@requestParam，也可用request.getParameterMap().get(“key”), 参数会被放入一个集合 */
request.doGet = function (url) {
  var param = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var conf = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  return this.do(url, param, null, conf, "GET");
};

/** 2.post: body内json, 后端取值@requestBody, Map 或转为实体 */
request.doPost = function (url) {
  var param = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var conf = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  return this.do(url, param, data, conf, "POST");
};

/** 3.form: body内格式为form, 和content-type有关系, 需要为form格式后端才能读取: 不能使用@RequestBody，参数会自动解析到实体; 若不是实体通过方法转Map */
request.doForm = function (url, param) {
  var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var conf = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  // 变更请求头类型, 传递form
  conf[KEY_M_CONTENT_TYPE] = true;
  return this.doPost(url, param, data, conf);
};

/** 4.upload: body-formData, 一般用于文件上传, 追加数据流 */
request.doUpload = function (url, param) {
  var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var conf = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  var formData = new FormData();
  _Object$keys(data).forEach(function (prop) {
    formData.append(prop, data[prop]);
  });
  return this.doPost(url, param, formData, conf);
};

/** 5.并发多个请求优先(类方法) */
request.doSpread = function (arrReq) {
  return axios.spread(arrReq);
};

/** 6.并发多个请求全部(类方法) */
request.doAll = function (arrReq) {
  return axios.all(arrReq);
};

/////////////////////////////////////////////////  服务配置   /////////////////////////////////////////////////

/** 1.excel: 下载blob数据 */
request.doDownload = function (blobData, fileName, type) {
  fileName = fileName || "导出文件_" + Date.now();
  var blob = new Blob([blobData], {
    type: type || "application/vnd.ms-pdf;charset=UTF-8"
  });
  var link = document.createElement("a");
  link.style.display = "none";
  link.href = URL.createObjectURL(blob);
  link.download = fileName;
  document.body.appendChild(link);
  link.click();
  URL.revokeObjectURL(link.href);
  document.body.removeChild(link);
};

/** 2.Excel: 导出并下载blob数据 */
request.doExport = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(url, param) {
    var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var method = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "POST";
    var type = arguments[4];
    var rsp;
    return regenerator.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return request.do(url, param, data, _defineProperty({}, KEY_EXPORT_TYPE, "blob"), method);

          case 2:
            rsp = _context2.sent;

            // 若响应数据为流
            if (!rsp.code) {
              this.doDownload(rsp.data, rsp.fileName, type);
            }
            return _context2.abrupt("return", rsp);

          case 5:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function (_x14, _x15) {
    return _ref2.apply(this, arguments);
  };
}();

/** 2.1.post方式下载blob数据 */
request.doExportByPOST = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee3(url, param) {
    var data = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var type = arguments[3];
    return regenerator.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            return _context3.abrupt("return", this.doExport(url, param, data, "POST", type));

          case 1:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, this);
  }));

  return function (_x18, _x19) {
    return _ref3.apply(this, arguments);
  };
}();

/** 2.2.get方式下载blob数据 */
request.doExportByGET = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee4(url, param, type) {
    return regenerator.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            return _context4.abrupt("return", this.doExport(url, param, null, "GET", type));

          case 1:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4, this);
  }));

  return function (_x21, _x22, _x23) {
    return _ref4.apply(this, arguments);
  };
}();

/** 3.Excel: 自定义导入, 自动下载失败记录 */
request.doImport = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee5(url, file, param, data) {
    var rsp;
    return regenerator.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return request.doPostFormData(url, param, _extends$1({ file: file }, data), _defineProperty({}, KEY_EXPORT_TYPE, "blob"));

          case 2:
            rsp = _context5.sent;

            if (rsp.code) {
              _context5.next = 7;
              break;
            }

            com.showErrorMessage("部分导入失败");
            this.doDownload(rsp.data, rsp.fileName);
            return _context5.abrupt("return");

          case 7:
            com.showSuccessMessage("全部导入成功");

          case 8:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, this);
  }));

  return function (_x24, _x25, _x26, _x27) {
    return _ref5.apply(this, arguments);
  };
}();

/** 4.Excel:导入数据el-upload组件 */
request.doElementUI = function (url) {
  var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var successHandle = arguments[2];

  return {
    action: url,
    fileList: [],
    data: data,
    onReady: function onReady() {
      com.showLoading();
    },

    success: function success(rsp) {
      com.hideLoading();
      if (rsp.code == CODE_SUCCESS) {
        com.showSuccessMessage("导入成功");
        successHandle && successHandle(rsp);
      } else {
        com.showErrorMessage(rsp.msg);
      }
    },
    failure: function failure() {
      com.hideLoading();
      com.showErrorMessage("导入失败");
    }
  };
};

var _createProperty = function (object, index, value) {
  if (index in object) _objectDp.f(object, index, _propertyDesc(0, value));
  else object[index] = value;
};

_export(_export.S + _export.F * !_iterDetect(function (iter) {  }), 'Array', {
  // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)
  from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
    var O = _toObject(arrayLike);
    var C = typeof this == 'function' ? this : Array;
    var aLen = arguments.length;
    var mapfn = aLen > 1 ? arguments[1] : undefined;
    var mapping = mapfn !== undefined;
    var index = 0;
    var iterFn = core_getIteratorMethod(O);
    var length, result, step, iterator;
    if (mapping) mapfn = _ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);
    // if object isn't iterable or it's array with default iterator - use simple case
    if (iterFn != undefined && !(C == Array && _isArrayIter(iterFn))) {
      for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {
        _createProperty(result, index, mapping ? _iterCall(iterator, mapfn, [step.value, index], true) : step.value);
      }
    } else {
      length = _toLength(O.length);
      for (result = new C(length); length > index; index++) {
        _createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);
      }
    }
    result.length = index;
    return result;
  }
});

var from$2 = _core.Array.from;

var from = createCommonjsModule(function (module) {
module.exports = { "default": from$2, __esModule: true };
});

unwrapExports(from);

var toConsumableArray = createCommonjsModule(function (module, exports) {
exports.__esModule = true;



var _from2 = _interopRequireDefault(from);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
      arr2[i] = arr[i];
    }

    return arr2;
  } else {
    return (0, _from2.default)(arr);
  }
};
});

var _toConsumableArray = unwrapExports(toConsumableArray);

// 组件数据处理

// 接口返回取值到组件, 人员搜索框需要对象类型


// 明细组件数据格式化, 接口服务人员搜索框需要集合的 json string


// 查询条件兼容各种组件形式
function __redundancy_query__(that, cur) {
  var value = "cur" in cur ? that.$(cur.cur).getValue() || cur.def : cur.def;
  // 兼容人员搜索框, 单选 + 多选
  if (cur.cur && cur.cur.includes("employeeField_")) {
    var arrEmp = [];
    var state = that.$(cur.cur).getValue() || [];
    // 单选
    if (state.length === undefined) {
      arrEmp.push(state.value);
    }
    // 多选且有值
    if (state.length) {
      arrEmp.push.apply(arrEmp, _toConsumableArray(state.map(function (emp) {
        return emp.value;
      })));
    }
    value = arrEmp;
    // 兼容匹配isAll, 避免被忽略
    if (!value.length) value = undefined;
  }
  // 兼容日期查询: 时间戳, cur为开始, end为默认, 若无则传def
  if (cur.src.includes("dateField_")) {
    var end = "end" in cur ? that.$(cur.end).getValue() || cur.def : cur.def;
    value = [value, end];
    // 兼容匹配isAll, 避免被忽略
    if (!value || !end) value = undefined;
  }
  // 兼容部门, 精确匹配, 兼容多选
  if (cur.cur && cur.cur.includes("departmentSelectField_")) {
    var depart = that.$(cur.cur).getValue();
    // 兼容匹配isAll, 避免被忽略
    if (!depart.length) {
      value = undefined;
    } else {
      value = depart.map(function (item) {
        return item.value;
      }).join(",");
    }
  }
  // 20.8.20 关联表单
  if (cur.cur && cur.cur.includes("associationFormField_") && value.length) {
    value = value.shift().title;
  }
  return value;
}

// 前端接口
var dp = {};

// 更新数据逻辑: 相对路径 `/${window.pageConfig.appType}/v1/form/searchFormDatas.json`
dp.updateForm = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
    var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        formInstId = _ref2.formInstId,
        updateData = _ref2.updateData,
        _ref2$dpRemote = _ref2.dpRemote,
        dpRemote = _ref2$dpRemote === undefined ? "updateForm" : _ref2$dpRemote,
        _ref2$isLoading = _ref2.isLoading,
        isLoading = _ref2$isLoading === undefined ? true : _ref2$isLoading,
        hideToast = _ref2.hideToast,
        _ref2$message = _ref2.message,
        message = _ref2$message === undefined ? "操作成功" : _ref2$message;

    var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        title = _ref3.title,
        content = _ref3.content;

    var rsp;
    return regenerator.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (formInstId) {
              _context.next = 2;
              break;
            }

            throw new Error("The params of formInstId is empty.");

          case 2:
            if (!(title || content)) {
              _context.next = 5;
              break;
            }

            _context.next = 5;
            return mjs.com.showConfirm(title, content);

          case 5:
            if (isLoading) mjs.com.showLoading();
            _context.next = 8;
            return mjs.$this.dataSourceMap[dpRemote].load({ formInstId: formInstId, updateFormDataJson: _JSON$stringify(updateData) }).catch(function (error) {
              if (!hideToast) mjs.com.showErrorMessage(error.message);
            });

          case 8:
            rsp = _context.sent;

            if (isLoading) mjs.com.hideLoading();

            if (rsp) {
              _context.next = 12;
              break;
            }

            return _context.abrupt("return");

          case 12:
            if (rsp && !hideToast) mjs.com.showMessage(message);

          case 13:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function () {
    return _ref.apply(this, arguments);
  };
}();

// 查询实例列表逻辑: 相对路径 `/${window.pageConfig.appType}/v1/form/searchFormDatas.json`
dp.queryForm = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee3() {
    var _this = this;

    var _ref5 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        formUuid = _ref5.formUuid,
        _ref5$conditions = _ref5.conditions,
        conditions = _ref5$conditions === undefined ? [] : _ref5$conditions,
        _ref5$dpRemote = _ref5.dpRemote,
        dpRemote = _ref5$dpRemote === undefined ? "queryForm" : _ref5$dpRemote,
        _ref5$isLoading = _ref5.isLoading,
        isLoading = _ref5$isLoading === undefined ? true : _ref5$isLoading,
        _ref5$hideToast = _ref5.hideToast,
        hideToast = _ref5$hideToast === undefined ? true : _ref5$hideToast,
        _ref5$matchAllConditi = _ref5.matchAllCondition,
        matchAllCondition = _ref5$matchAllConditi === undefined ? false : _ref5$matchAllConditi,
        _ref5$message = _ref5.message,
        message = _ref5$message === undefined ? "查询成功" : _ref5$message;

    var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref6$currentPage = _ref6.currentPage,
        currentPage = _ref6$currentPage === undefined ? 1 : _ref6$currentPage,
        _ref6$pageSize = _ref6.pageSize,
        pageSize = _ref6$pageSize === undefined ? config.pageSize : _ref6$pageSize,
        queryAll = _ref6.queryAll;

    var searchCondition, searchLength, queryFunc, resp, list, pages, promiseReq, pageCount, index, respArr;
    return regenerator.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            // 查询条件格式化
            searchCondition = conditions.reduce(function (acc, cur) {
              var value = __redundancy_query__(mjs.$this, cur);
              if (value) {
                acc[cur.src] = value;
              }
              return acc;
            }, {});
            searchLength = _Object$keys(searchCondition).length;

            if (!(conditions.length && !searchLength)) {
              _context3.next = 4;
              break;
            }

            return _context3.abrupt("return", []);

          case 4:
            if (!(matchAllCondition && searchLength != conditions.length)) {
              _context3.next = 6;
              break;
            }

            return _context3.abrupt("return", []);

          case 6:
            queryFunc = function () {
              var _ref7 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2(currentPage) {
                var params;
                return regenerator.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        params = {
                          searchFieldJson: _JSON$stringify(searchCondition),
                          currentPage: currentPage,
                          pageSize: pageSize
                        };
                        // 兼容默认参数已设置FormUuid, 为空会被覆盖

                        if (formUuid) params.formUuid = formUuid;
                        _context2.next = 4;
                        return mjs.$this.dataSourceMap[dpRemote].load(params).catch(function (error) {
                          if (!hideToast) mjs.com.showErrorMessage(error.message);
                        });

                      case 4:
                        return _context2.abrupt("return", _context2.sent);

                      case 5:
                      case "end":
                        return _context2.stop();
                    }
                  }
                }, _callee2, _this);
              }));

              return function queryFunc(_x5) {
                return _ref7.apply(this, arguments);
              };
            }();

            if (isLoading) mjs.com.showLoading();
            _context3.next = 10;
            return queryFunc(currentPage);

          case 10:
            resp = _context3.sent;
            list = resp.data;
            pages = Math.ceil(resp.totalCount / pageSize);

            if (!(queryAll && pages > currentPage)) {
              _context3.next = 21;
              break;
            }

            promiseReq = [];
            pageCount = Math.ceil(config.upperLimit / pageSize);

            for (index = currentPage + 1; index < pageCount + currentPage && index <= pages; index++) {
              promiseReq.push(queryFunc(index));
            }
            _context3.next = 19;
            return _Promise.all(promiseReq);

          case 19:
            respArr = _context3.sent;

            respArr.forEach(function (rsp) {
              list.push.apply(list, _toConsumableArray(rsp.data));
            });

          case 21:
            if (isLoading) mjs.com.hideLoading();
            if (resp && !hideToast) mjs.com.showMessage(message);
            return _context3.abrupt("return", { totalCount: resp.totalCount, data: list });

          case 24:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3, this);
  }));

  return function () {
    return _ref4.apply(this, arguments);
  };
}();

// 明细全量查询: Promise并发
dp.queryDetail = function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee5() {
    var _this2 = this;

    var _ref9 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        formUuid = _ref9.formUuid,
        _ref9$conditions = _ref9.conditions,
        conditions = _ref9$conditions === undefined ? {} : _ref9$conditions,
        _ref9$dpRemote = _ref9.dpRemote,
        dpRemote = _ref9$dpRemote === undefined ? "queryForm" : _ref9$dpRemote;

    var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref10$currentPage = _ref10.currentPage,
        currentPage = _ref10$currentPage === undefined ? 1 : _ref10$currentPage,
        _ref10$pageSize = _ref10.pageSize,
        pageSize = _ref10$pageSize === undefined ? config.pageSize : _ref10$pageSize,
        _ref10$detailCount = _ref10.detailCount,
        detailCount = _ref10$detailCount === undefined ? config.detailCount : _ref10$detailCount;

    var searchCondition, queryFunc, resp, list, pages, promiseReq, pageCount, index, respArr;
    return regenerator.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            searchCondition = conditions.reduce(function (acc, cur) {
              var value = __redundancy_query__(mjs.$this, cur);
              if (value) {
                acc[cur.src] = value;
              }
              return acc;
            }, {});

            queryFunc = function () {
              var _ref11 = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee4(currentPage) {
                var params;
                return regenerator.wrap(function _callee4$(_context4) {
                  while (1) {
                    switch (_context4.prev = _context4.next) {
                      case 0:
                        params = {
                          searchFieldJson: _JSON$stringify(searchCondition),
                          currentPage: currentPage,
                          pageSize: pageSize
                        };
                        // 兼容默认参数已设置FormUuid, 为空会被覆盖

                        if (formUuid) params.formUuid = formUuid;
                        _context4.next = 4;
                        return mjs.$this.dataSourceMap[dpRemote].load(params);

                      case 4:
                        return _context4.abrupt("return", _context4.sent);

                      case 5:
                      case "end":
                        return _context4.stop();
                    }
                  }
                }, _callee4, _this2);
              }));

              return function queryFunc(_x8) {
                return _ref11.apply(this, arguments);
              };
            }();

            mjs.com.showLoading();
            _context5.next = 5;
            return queryFunc(currentPage);

          case 5:
            resp = _context5.sent;
            list = resp.data;
            pages = Math.ceil(resp.totalCount / pageSize);

            if (!(pages > currentPage)) {
              _context5.next = 16;
              break;
            }

            promiseReq = [];
            pageCount = Math.ceil(detailCount / pageSize);

            for (index = currentPage + 1; index < pageCount + currentPage && index <= pages; index++) {
              promiseReq.push(queryFunc(index));
            }
            _context5.next = 14;
            return _Promise.all(promiseReq);

          case 14:
            respArr = _context5.sent;

            respArr.forEach(function (res) {
              list.push.apply(list, _toConsumableArray(res.data));
            });

          case 16:
            mjs.com.hideLoading();
            return _context5.abrupt("return", { totalCount: resp.totalCount, data: list });

          case 18:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5, this);
  }));

  return function () {
    return _ref8.apply(this, arguments);
  };
}();

/**
 * @exports 返回变量型跨域
 * @returns 如获取ip: https://pv.sohu.com/cityjson?ie=utf-8, 返回值：var returnCitySN = {"cip": "124.79.25.204", "cid": "310101", "cname": "上海市黄浦区"};
 **/
function crossDomainByScript(src, prop) {
  if (!src) _Promise.reject("地址不能为空");
  return new _Promise(function (resolve) {
    var script = document.createElement("script");
    script.setAttribute("type", "text/javascript");
    script.setAttribute("src", src);
    document.body.appendChild(script);
    script.onload = function () {
      resolve(window[prop]);
    };
  });
}

/*** mjs 之 云璞tb与宜搭对接 ***/

var cp = {

  // 公共配置
  init: function init() {
    mjs.conf.api = "https://mc.cloudpure.cn/tb-yd/";
    return this; // this 指向当前项目本身
  },


  // 获取企业项目模板
  getTemplate: function getTemplate(compId) {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
      var rsp;
      return regenerator.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return mjs.request.xhr.doPost("tb/template", {}, {}, _defineProperty({}, KEY_NO_LOADING, true));

            case 2:
              rsp = _context.sent;

              mjs.$this.$(compId).set("dataSource", rsp.data.map(function (item) {
                return { label: item.name, value: item.id };
              }));

            case 4:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, _this);
    }))();
  },


  // 获取企业项目模板
  createProject: function createProject() {
    var _this2 = this;

    return _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee2() {
      var body, templateId, rsp;
      return regenerator.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              body = {
                userName: loginUser.userName,
                projectName: mjs.$this.$("textField_l9m4krcc").getValue()
              };
              templateId = mjs.$this.$("selectField_laqbuhr7").getValue();

              if (templateId) {
                body.templateId = templateId;
              }
              _context2.next = 5;
              return mjs.request.xhr.doPost("tb/project", {}, body);

            case 5:
              rsp = _context2.sent;

            case 6:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, _this2);
    }))();
  }
};

var _validateCollection = function (it, TYPE) {
  if (!_isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
  return it;
};

var dP$2 = _objectDp.f;









var fastKey = _meta.fastKey;

var SIZE = _descriptors ? '_s' : 'size';

var getEntry = function (that, key) {
  // fast case
  var index = fastKey(key);
  var entry;
  if (index !== 'F') return that._i[index];
  // frozen object case
  for (entry = that._f; entry; entry = entry.n) {
    if (entry.k == key) return entry;
  }
};

var _collectionStrong = {
  getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      _anInstance(that, C, NAME, '_i');
      that._t = NAME;         // collection type
      that._i = _objectCreate(null); // index
      that._f = undefined;    // first entry
      that._l = undefined;    // last entry
      that[SIZE] = 0;         // size
      if (iterable != undefined) _forOf(iterable, IS_MAP, that[ADDER], that);
    });
    _redefineAll(C.prototype, {
      // 23.1.3.1 Map.prototype.clear()
      // 23.2.3.2 Set.prototype.clear()
      clear: function clear() {
        for (var that = _validateCollection(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {
          entry.r = true;
          if (entry.p) entry.p = entry.p.n = undefined;
          delete data[entry.i];
        }
        that._f = that._l = undefined;
        that[SIZE] = 0;
      },
      // 23.1.3.3 Map.prototype.delete(key)
      // 23.2.3.4 Set.prototype.delete(value)
      'delete': function (key) {
        var that = _validateCollection(this, NAME);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.n;
          var prev = entry.p;
          delete that._i[entry.i];
          entry.r = true;
          if (prev) prev.n = next;
          if (next) next.p = prev;
          if (that._f == entry) that._f = next;
          if (that._l == entry) that._l = prev;
          that[SIZE]--;
        } return !!entry;
      },
      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
      forEach: function forEach(callbackfn /* , that = undefined */) {
        _validateCollection(this, NAME);
        var f = _ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.n : this._f) {
          f(entry.v, entry.k, this);
          // revert to the last existing entry
          while (entry && entry.r) entry = entry.p;
        }
      },
      // 23.1.3.7 Map.prototype.has(key)
      // 23.2.3.7 Set.prototype.has(value)
      has: function has(key) {
        return !!getEntry(_validateCollection(this, NAME), key);
      }
    });
    if (_descriptors) dP$2(C.prototype, 'size', {
      get: function () {
        return _validateCollection(this, NAME)[SIZE];
      }
    });
    return C;
  },
  def: function (that, key, value) {
    var entry = getEntry(that, key);
    var prev, index;
    // change existing entry
    if (entry) {
      entry.v = value;
    // create new entry
    } else {
      that._l = entry = {
        i: index = fastKey(key, true), // <- index
        k: key,                        // <- key
        v: value,                      // <- value
        p: prev = that._l,             // <- previous entry
        n: undefined,                  // <- next entry
        r: false                       // <- removed
      };
      if (!that._f) that._f = entry;
      if (prev) prev.n = entry;
      that[SIZE]++;
      // add to index
      if (index !== 'F') that._i[index] = entry;
    } return that;
  },
  getEntry: getEntry,
  setStrong: function (C, NAME, IS_MAP) {
    // add .keys, .values, .entries, [@@iterator]
    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
    _iterDefine(C, NAME, function (iterated, kind) {
      this._t = _validateCollection(iterated, NAME); // target
      this._k = kind;                     // kind
      this._l = undefined;                // previous
    }, function () {
      var that = this;
      var kind = that._k;
      var entry = that._l;
      // revert to the last existing entry
      while (entry && entry.r) entry = entry.p;
      // get next entry
      if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
        // or finish the iteration
        that._t = undefined;
        return _iterStep(1);
      }
      // return step by kind
      if (kind == 'keys') return _iterStep(0, entry.k);
      if (kind == 'values') return _iterStep(0, entry.v);
      return _iterStep(0, [entry.k, entry.v]);
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // add [@@species], 23.1.2.2, 23.2.2.2
    _setSpecies(NAME);
  }
};

var SPECIES$2 = _wks('species');

var _arraySpeciesConstructor = function (original) {
  var C;
  if (_isArray(original)) {
    C = original.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || _isArray(C.prototype))) C = undefined;
    if (_isObject(C)) {
      C = C[SPECIES$2];
      if (C === null) C = undefined;
    }
  } return C === undefined ? Array : C;
};

// 9.4.2.3 ArraySpeciesCreate(originalArray, length)


var _arraySpeciesCreate = function (original, length) {
  return new (_arraySpeciesConstructor(original))(length);
};

// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex





var _arrayMethods = function (TYPE, $create) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  var create = $create || _arraySpeciesCreate;
  return function ($this, callbackfn, that) {
    var O = _toObject($this);
    var self = _iobject(O);
    var f = _ctx(callbackfn, that, 3);
    var length = _toLength(self.length);
    var index = 0;
    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var val, res;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      val = self[index];
      res = f(val, index, O);
      if (TYPE) {
        if (IS_MAP) result[index] = res;   // map
        else if (res) switch (TYPE) {
          case 3: return true;             // some
          case 5: return val;              // find
          case 6: return index;            // findIndex
          case 2: result.push(val);        // filter
        } else if (IS_EVERY) return false; // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
  };
};

var dP$3 = _objectDp.f;
var each = _arrayMethods(0);


var _collection = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {
  var Base = _global[NAME];
  var C = Base;
  var ADDER = IS_MAP ? 'set' : 'add';
  var proto = C && C.prototype;
  var O = {};
  if (!_descriptors || typeof C != 'function' || !(IS_WEAK || proto.forEach && !_fails(function () {
    new C().entries().next();
  }))) {
    // create collection constructor
    C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);
    _redefineAll(C.prototype, methods);
    _meta.NEED = true;
  } else {
    C = wrapper(function (target, iterable) {
      _anInstance(target, C, NAME, '_c');
      target._c = new Base();
      if (iterable != undefined) _forOf(iterable, IS_MAP, target[ADDER], target);
    });
    each('add,clear,delete,forEach,get,has,set,keys,values,entries,toJSON'.split(','), function (KEY) {
      var IS_ADDER = KEY == 'add' || KEY == 'set';
      if (KEY in proto && !(IS_WEAK && KEY == 'clear')) _hide(C.prototype, KEY, function (a, b) {
        _anInstance(this, C, KEY);
        if (!IS_ADDER && IS_WEAK && !_isObject(a)) return KEY == 'get' ? undefined : false;
        var result = this._c[KEY](a === 0 ? 0 : a, b);
        return IS_ADDER ? this : result;
      });
    });
    IS_WEAK || dP$3(C.prototype, 'size', {
      get: function () {
        return this._c.size;
      }
    });
  }

  _setToStringTag(C, NAME);

  O[NAME] = C;
  _export(_export.G + _export.W + _export.F, O);

  if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);

  return C;
};

var SET = 'Set';

// 23.2 Set Objects
var es6_set = _collection(SET, function (get) {
  return function Set() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
}, {
  // 23.2.3.1 Set.prototype.add(value)
  add: function add(value) {
    return _collectionStrong.def(_validateCollection(this, SET), value = value === 0 ? 0 : value, value);
  }
}, _collectionStrong);

var _arrayFromIterable = function (iter, ITERATOR) {
  var result = [];
  _forOf(iter, false, result.push, result, ITERATOR);
  return result;
};

// https://github.com/DavidBruant/Map-Set.prototype.toJSON


var _collectionToJson = function (NAME) {
  return function toJSON() {
    if (_classof(this) != NAME) throw TypeError(NAME + "#toJSON isn't generic");
    return _arrayFromIterable(this);
  };
};

// https://github.com/DavidBruant/Map-Set.prototype.toJSON


_export(_export.P + _export.R, 'Set', { toJSON: _collectionToJson('Set') });

// https://tc39.github.io/proposal-setmap-offrom/


var _setCollectionOf = function (COLLECTION) {
  _export(_export.S, COLLECTION, { of: function of() {
    var length = arguments.length;
    var A = new Array(length);
    while (length--) A[length] = arguments[length];
    return new this(A);
  } });
};

// https://tc39.github.io/proposal-setmap-offrom/#sec-set.of
_setCollectionOf('Set');

// https://tc39.github.io/proposal-setmap-offrom/





var _setCollectionFrom = function (COLLECTION) {
  _export(_export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {
    var mapFn = arguments[1];
    var mapping, A, n, cb;
    _aFunction(this);
    mapping = mapFn !== undefined;
    if (mapping) _aFunction(mapFn);
    if (source == undefined) return new this();
    A = [];
    if (mapping) {
      n = 0;
      cb = _ctx(mapFn, arguments[2], 2);
      _forOf(source, false, function (nextItem) {
        A.push(cb(nextItem, n++));
      });
    } else {
      _forOf(source, false, A.push, A);
    }
    return new this(A);
  } });
};

// https://tc39.github.io/proposal-setmap-offrom/#sec-set.from
_setCollectionFrom('Set');

var set$1 = _core.Set;

var set = createCommonjsModule(function (module) {
module.exports = { "default": set$1, __esModule: true };
});

var _Set = unwrapExports(set);

/*** mjs 之 谷元发票识别 ***/

var guyuan = {

  // 修改公共配置
  init: function init() {
    {
      mjs.conf.api = "https://mc.cloudpure.cn/api/guyuan/";
    }
    return this; // this 指向当前项目本身
  },


  // 发票识别, 混票
  mixedInvoice: function mixedInvoice(file) {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee() {
      var rsp, headers, prop, invoices;
      return regenerator.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return mjs.request.xhr.doPost(mjs.conf.api + "/invoice-iv", {}, {
                url: file.url,
                isPdf: file.type.includes("pdf"),
                size: file.size / 1024 / 1024
              });

            case 2:
              rsp = _context.sent;

              // 明细数据匹配表头
              headers = mjs.$this.$("tableField_liv5f4d2").props.children[0].props.children.map(function (_ref) {
                var _ref$props = _ref.props,
                    label = _ref$props.label,
                    fieldId = _ref$props.fieldId;
                return { label: label, compId: fieldId };
              });
              prop = rsp.data.dto; // 通用字段定义

              invoices = rsp.data.result.map(function (item) {
                var rowData = _Object$keys(prop).reduce(function (acc, cur) {
                  var comp = headers.find(function (c) {
                    return c.label == cur;
                  });
                  if (comp) {
                    acc[comp.compId] = item[prop[cur]];
                  }
                  // 非标准表头，格式化
                  if (cur == "价税合计") {
                    acc.numberField_liihyrt7 = item.amount;
                  }
                  if (cur == "开票日期") {
                    acc.textField_livimrja = item[prop[cur]];
                    acc.dateField_liihyrt9 = new Date(acc.textField_livimrja).getTime();
                  }
                  return acc;
                }, {});
                // 发票数据标题: 销售方 + 发票类型 + 价税合计
                rowData.textField_ljmgqvbz = item.sellerName + "-" + item.kindName + "-" + item.amount;
                return rowData;
              });

              mjs.$this.$('tableField_liv5f4d2').setValue(invoices);

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, _this);
    }))();
  },


  // 批量验证
  batchCheck: function batchCheck() {
    return new _Promise(function (resolve, reject) {
      var details = mjs.$this.$('tableField_liv5f4d2').getValue();
      var param = details.map(function (item) {
        return {
          kindName: item.selectField_liihyrta,
          serial: item.textField_liihyrt8,
          code: item.textField_lil34mnc,
          date: item.textField_livimrja,
          amount: item.numberField_liihyrt7,
          excludingTax: item.numberField_livimrj8,
          checkCode: item.textField_lil34mne,
          buyerName: item.selectField_lix0cyqx,
          buyerTaxId: item.textField_lil34mng,
          sellerName: item.textField_liihyrt3,
          sellerTaxId: item.textField_lil34mnf
        };
      });
      mjs.request.xhr.doPost(mjs.conf.api + "/invoice-va", {}, {
        param: param
      }).then(function () {
        return resolve();
      }).catch(function () {
        return reject();
      }); // ppExt: 需要拦截错误, 否则一次失败后程序阻断
    });
  },


  // 发票查重, 验真
  validate: function validate() {
    return new _Promise(function (resolve, reject) {
      if (mjs.env == 2) {
        if (mjs.$this.$('selectField_liihyrt6').getValue() == "已使用") {
          return mjs.com.toastError("发票已被使用，不允许修改！");
        }
        // 校验通过: 发票未使用状态且不在流程中 || 否改为否，标识状态不做校验
        if (mjs.$this.$('radioField_liihyrtb').getValue() == "是" || mjs.corp.guyuan.status == "否") {
          return mjs.com.toastError(null, resolve);
        }
      }
      // 非作废校验
      var param = {
        kindName: mjs.$this.$("selectField_liihyrta").getValue(),
        serial: mjs.$this.$("textField_liihyrt8").getValue(),
        code: mjs.$this.$("textField_lil34mnc").getValue(),
        date: mjs.$this.$("textField_liwadykg").getValue(),
        amount: mjs.$this.$("numberField_liihyrt7").getValue(),
        excludingTax: mjs.$this.$("numberField_liwauxaq").getValue(),
        checkCode: mjs.$this.$("textField_lil34mne").getValue(),
        buyerName: mjs.$this.$('selectField_lix0cyqx').getValue(),
        buyerTaxId: mjs.$this.$('textField_lil34mng').getValue(),
        sellerName: mjs.$this.$('textField_liihyrt3').getValue(),
        sellerTaxId: mjs.$this.$('textField_lil34mnf').getValue()
      };
      mjs.request.xhr.doPost(mjs.conf.api + "/invoice-va", {}, {
        param: [param]
      }).then(function () {
        return resolve();
      }).catch(function (err) {
        return reject(err);
      }); // ppExt: 需要拦截错误, 否则一次失败后程序阻断
    });
  },


  // 提交校验 [日常报销/项目付款]
  submit: function submit() {
    var associationIds = mjs.$this.$('tableField_krmybpq6').getValue().reduce(function (acc, cur) {
      acc.push.apply(acc, _toConsumableArray((cur.associationFormField_liya90jt || cur.associationFormField_ljnoa248).map(function (item) {
        return item.instanceId;
      })));
      return acc;
    }, []);
    // […new Set(arr)] 返回的是数组内set，取length异常，为1个Set对象，但循环处理数据正常。因此可通过：new Set(ids).size != ids.length
    if (new _Set(associationIds).size != associationIds.length) {
      return mjs.com.toastError("请勿重复选择发票！");
    }
    // prd 费用明细中的报销金额修改金额, 不能大于发票金额
    var idx = -1;
    mjs.$this.$('tableField_krmybpq6').getValue().forEach(function (item, index) {
      if (item.numberField_krn4ig4x > (item.numberField_ljau8ps7 || item.numberField_ljnoa249)) {
        idx = index;
        return;
      }
    });
    if (idx >= 0) {
      return mjs.com.toastError("\u7B2C\u3010" + (idx + 1) + "\u3011\u8BB0\u5F55, \u62A5\u9500\u91D1\u989D\u5DF2\u5927\u4E8E\u53D1\u7968\u91D1\u989D\uFF01");
    }
    // 兼容: 退回为监听宜搭dom事件, 先执行接口调用, 才会校验宜搭必填, 过滤无效调用 || 先匹配校验是否可调用
    var bx = (mjs.$this.$("numberField_krn54uoe") || mjs.$this.$("numberField_kroa4wk1")).getValue();
    var fk = (mjs.$this.$("numberField_krn7ufyt") || mjs.$this.$("numberField_krf2spcw")).getValue();
    if (bx != fk) {
      return mjs.com.toastError("费用明细合计与支付金额不一致！");
    }
    return true;
  }
};

/*** mc 系列之 mjs
 * 对接宜搭公共JavaScript库
 * 公共库地址：https://mc.cloudpure.cn/mjs/mjs.min.js
 * 本地库地址: http://127.0.0.1:7001/dist/mjs.js
 ***/

var init = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/regenerator.mark(function _callee(_this) {
    var config$$1 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var msg;
    return regenerator.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            console.log(this);
            this.$this = _this; // this全局化
            this.env = com.checkEnv(); // 环境: 0提交(其它)，1查看，2编辑(审批)
            loadVConsole(config$$1.vconsole);
            this.auth = auth; // 授权
            this.dom = dom; // 样式
            this.com = com; // 通用
            this.bus = bus; // 事件
            this.conf = config; // 配置
            this.optimize = optimize; // 优化
            this.storage = storage; // 存储
            this.date = date; // 日期
            this.request = { dp: dp, xhr: request, net: { crossDomainByScript: crossDomainByScript } }; // 请求
            this.ding = ding;
            this.corp = {
              cp: cp, guyuan: guyuan
              // 输出日志;
            };msg = "mjs load success. \u2668 \u8BBF\u95EE\u5E94\u7528: " + pageConfig.appType + " " + pageConfig.appName + " \xA9\uFE0F \u7248\u6743\u8BF7\u8BF7\u8054\u7CFB: https://www.aliwork.com/o/mc";

            console.log(msg, mjs, config$$1);

          case 17:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function init(_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.init = init;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=mjs.js.map
